/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMetaExtended;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanRegistry;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.PropertyNamer;
import org.apache.juneau.PropertyNamerDefault;
import org.apache.juneau.Visibility;
import org.apache.juneau.annotation.Bean;
import org.apache.juneau.annotation.BeanConstructor;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.annotation.BeanProperty;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.ReflectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.transform.BeanFilter;
import org.apache.juneau.utils.MetadataMap;

public class BeanMeta<T> {
    protected final ClassMeta<T> classMeta;
    protected final Class<T> c;
    protected final Map<String, BeanPropertyMeta> properties;
    protected final Map<Method, String> getterProps;
    protected final Map<Method, String> setterProps;
    protected final BeanContext ctx;
    protected final BeanFilter beanFilter;
    protected final Map<Class<?>, Class<?>[]> typeVarImpls;
    protected final Constructor<T> constructor;
    protected final String[] constructorArgs;
    private final MetadataMap extMeta;
    final String typePropertyName;
    private final BeanPropertyMeta typeProperty;
    final BeanPropertyMeta dynaProperty;
    private final String dictionaryName;
    final String notABeanReason;
    final BeanRegistry beanRegistry;
    final boolean sortProperties;

    protected BeanMeta(ClassMeta<T> classMeta, BeanContext ctx, BeanFilter beanFilter, String[] pNames) {
        this.classMeta = classMeta;
        this.ctx = ctx;
        this.c = classMeta.getInnerClass();
        Builder b = new Builder(classMeta, ctx, beanFilter, pNames);
        this.notABeanReason = b.init(this);
        this.beanFilter = beanFilter;
        this.dictionaryName = b.dictionaryName;
        this.properties = b.properties == null ? null : Collections.unmodifiableMap(b.properties);
        this.getterProps = Collections.unmodifiableMap(b.getterProps);
        this.setterProps = Collections.unmodifiableMap(b.setterProps);
        this.dynaProperty = b.dynaProperty;
        this.typeVarImpls = b.typeVarImpls == null ? null : Collections.unmodifiableMap(b.typeVarImpls);
        this.constructor = b.constructor;
        this.constructorArgs = b.constructorArgs;
        this.extMeta = b.extMeta;
        this.beanRegistry = b.beanRegistry;
        this.typePropertyName = b.typePropertyName;
        this.typeProperty = new BeanPropertyMeta.Builder(this, this.typePropertyName, ctx.string(), this.beanRegistry).build();
        this.sortProperties = b.sortProperties;
    }

    @BeanIgnore
    public ClassMeta<T> getClassMeta() {
        return this.classMeta;
    }

    public String getDictionaryName() {
        return this.dictionaryName;
    }

    public BeanPropertyMeta getTypeProperty() {
        return this.typeProperty;
    }

    private static List<BeanMethod> findBeanMethods(Class<?> c, Class<?> stopClass, Visibility v, Set<String> fixedBeanProps, PropertyNamer pn) {
        LinkedList<BeanMethod> l = new LinkedList<BeanMethod>();
        for (Class<?> c2 : BeanMeta.findClasses(c, stopClass)) {
            for (Method m : c2.getDeclaredMethods()) {
                BeanIgnore bi;
                int mod = m.getModifiers();
                if (Modifier.isStatic(mod) || m.isBridge() || (bi = ClassUtils.getMethodAnnotation(BeanIgnore.class, c, m)) != null) continue;
                BeanProperty bp = ClassUtils.getMethodAnnotation(BeanProperty.class, c, m);
                if (!v.isVisible(m) && bp == null) continue;
                String n = m.getName();
                Class<?>[] pt = m.getParameterTypes();
                Class<?> rt = m.getReturnType();
                boolean isGetter = false;
                boolean isSetter = false;
                String bpName = BeanMeta.bpName(bp);
                if (pt.length == 0) {
                    if (n.startsWith("get") && !rt.equals(Void.TYPE)) {
                        isGetter = true;
                        n = n.substring(3);
                    } else if (n.startsWith("is") && (rt.equals(Boolean.TYPE) || rt.equals(Boolean.class))) {
                        isGetter = true;
                        n = n.substring(2);
                    } else if (!bpName.isEmpty()) {
                        isGetter = true;
                        n = bpName;
                    }
                } else if (pt.length == 1) {
                    if (n.startsWith("set") && (ClassUtils.isParentClass(rt, c) || rt.equals(Void.TYPE))) {
                        isSetter = true;
                        n = n.substring(3);
                    } else if (!bpName.isEmpty()) {
                        isSetter = true;
                        n = bpName;
                    }
                } else if (pt.length == 2 && "*".equals(bpName)) {
                    isSetter = true;
                    n = bpName;
                }
                n = pn.getPropertyName(n);
                if (!isGetter && !isSetter) continue;
                if (!bpName.isEmpty()) {
                    n = bpName;
                    if (!fixedBeanProps.isEmpty() && !fixedBeanProps.contains(n)) {
                        n = null;
                    }
                }
                if (n == null) continue;
                l.add(new BeanMethod(n, isSetter, m));
            }
        }
        return l;
    }

    private static Collection<Field> findBeanFields(Class<?> c, Class<?> stopClass, Visibility v) {
        LinkedList<Field> l = new LinkedList<Field>();
        for (Class<?> c2 : BeanMeta.findClasses(c, stopClass)) {
            for (Field f : c2.getDeclaredFields()) {
                int m = f.getModifiers();
                if (Modifier.isStatic(m) || Modifier.isTransient(m) || f.isAnnotationPresent(BeanIgnore.class) || !v.isVisible(f) && !f.isAnnotationPresent(BeanProperty.class)) continue;
                l.add(f);
            }
        }
        return l;
    }

    private static List<Class<?>> findClasses(Class<?> c, Class<?> stopClass) {
        LinkedList l = new LinkedList();
        BeanMeta.findClasses(c, l, stopClass);
        return l;
    }

    private static void findClasses(Class<?> c, LinkedList<Class<?>> l, Class<?> stopClass) {
        while (c != null && stopClass != c) {
            l.addFirst(c);
            for (Class<?> ci : c.getInterfaces()) {
                BeanMeta.findClasses(ci, l, stopClass);
            }
            c = c.getSuperclass();
        }
    }

    public Collection<BeanPropertyMeta> getPropertyMetas() {
        return this.properties.values();
    }

    public Collection<BeanPropertyMeta> getPropertyMetas(String ... pNames) {
        if (pNames == null) {
            return this.getPropertyMetas();
        }
        ArrayList<BeanPropertyMeta> l = new ArrayList<BeanPropertyMeta>(pNames.length);
        for (int i = 0; i < pNames.length; ++i) {
            l.add(this.getPropertyMeta(pNames[i]));
        }
        return l;
    }

    public <M extends BeanMetaExtended> M getExtendedMeta(Class<M> metaDataClass) {
        return (M)((BeanMetaExtended)this.extMeta.get(metaDataClass, this));
    }

    public BeanPropertyMeta getPropertyMeta(String name) {
        BeanPropertyMeta bpm = this.properties.get(name);
        if (bpm == null) {
            bpm = this.dynaProperty;
        }
        return bpm;
    }

    protected T newBean(Object outer) throws IllegalArgumentException, InstantiationException, IllegalAccessException, InvocationTargetException {
        if (this.classMeta.isMemberClass()) {
            if (this.constructor != null) {
                return this.constructor.newInstance(outer);
            }
        } else {
            if (this.constructor != null) {
                return this.constructor.newInstance(null);
            }
            InvocationHandler h = this.classMeta.getProxyInvocationHandler();
            if (h != null) {
                ClassLoader cl = this.classMeta.getBeanContext().classLoader;
                if (cl == null) {
                    cl = this.getClass().getClassLoader();
                }
                return (T)Proxy.newProxyInstance(cl, new Class[]{this.classMeta.innerClass, Serializable.class}, h);
            }
        }
        return null;
    }

    private static void findTypeVarImpls(Type t, Map<Class<?>, Class<?>[]> m) {
        ParameterizedType pt;
        Type rt;
        if (t instanceof Class) {
            Class c = (Class)t;
            BeanMeta.findTypeVarImpls(c.getGenericSuperclass(), m);
            for (Type ci : c.getGenericInterfaces()) {
                BeanMeta.findTypeVarImpls(ci, m);
            }
        } else if (t instanceof ParameterizedType && (rt = (pt = (ParameterizedType)t).getRawType()) instanceof Class) {
            Type[] gImpls = pt.getActualTypeArguments();
            Class[] gTypes = new Class[gImpls.length];
            for (int i = 0; i < gImpls.length; ++i) {
                Type gt = gImpls[i];
                if (gt instanceof Class) {
                    gTypes[i] = (Class)gt;
                    continue;
                }
                if (!(gt instanceof TypeVariable)) continue;
                TypeVariable tv = (TypeVariable)gt;
                for (Type upperBound : tv.getBounds()) {
                    if (!(upperBound instanceof Class)) continue;
                    gTypes[i] = (Class)upperBound;
                }
            }
            m.put((Class)rt, gTypes);
            BeanMeta.findTypeVarImpls(pt.getRawType(), m);
        }
    }

    private static String bpName(BeanProperty bp) {
        if (bp == null) {
            return "";
        }
        if (!bp.name().isEmpty()) {
            return bp.name();
        }
        return bp.value();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.c.getName());
        sb.append(" {\n");
        for (BeanPropertyMeta pm : this.properties.values()) {
            sb.append('\t').append(pm.toString()).append(",\n");
        }
        sb.append('}');
        return sb.toString();
    }

    private static class BeanMethod {
        String propertyName;
        boolean isSetter;
        Method method;
        Class<?> type;

        BeanMethod(String propertyName, boolean isSetter, Method method) {
            this.propertyName = propertyName;
            this.isSetter = isSetter;
            this.method = method;
            this.type = isSetter ? method.getParameterTypes()[0] : method.getReturnType();
        }

        boolean matchesPropertyType(BeanPropertyMeta.Builder b) {
            if (b == null) {
                return false;
            }
            if ("*".equals(b.name)) {
                return true;
            }
            Class<?> pt = null;
            if (b.getter != null) {
                pt = b.getter.getReturnType();
            } else if (b.field != null) {
                pt = b.field.getType();
            }
            if (pt == null) {
                return false;
            }
            if (!ClassUtils.isParentClass(this.type, pt)) {
                return false;
            }
            if (b.setter == null) {
                return true;
            }
            Class<?> prevType = b.setter.getParameterTypes()[0];
            return ClassUtils.isParentClass(prevType, this.type, true);
        }

        public String toString() {
            return this.method.toString();
        }
    }

    private static final class Builder<T> {
        ClassMeta<T> classMeta;
        BeanContext ctx;
        BeanFilter beanFilter;
        String[] pNames;
        Map<String, BeanPropertyMeta> properties;
        Map<Method, String> getterProps = new HashMap<Method, String>();
        Map<Method, String> setterProps = new HashMap<Method, String>();
        BeanPropertyMeta dynaProperty;
        Map<Class<?>, Class<?>[]> typeVarImpls;
        Constructor<T> constructor;
        String[] constructorArgs = new String[0];
        MetadataMap extMeta = new MetadataMap();
        PropertyNamer propertyNamer;
        BeanRegistry beanRegistry;
        String dictionaryName;
        String typePropertyName;
        boolean sortProperties;

        private Builder(ClassMeta<T> classMeta, BeanContext ctx, BeanFilter beanFilter, String[] pNames) {
            this.classMeta = classMeta;
            this.ctx = ctx;
            this.beanFilter = beanFilter;
            this.pNames = pNames;
        }

        /*
         * WARNING - void declaration
         */
        private String init(BeanMeta<T> beanMeta) {
            Class<T> c = this.classMeta.getInnerClass();
            try {
                Object m;
                Class<Object> stopClass;
                Bean bean;
                Visibility conVis = this.ctx.beanConstructorVisibility;
                Visibility cVis = this.ctx.beanClassVisibility;
                Visibility mVis = this.ctx.beanMethodVisibility;
                Visibility fVis = this.ctx.beanFieldVisibility;
                ArrayList bdClasses = new ArrayList();
                if (this.beanFilter != null && this.beanFilter.getBeanDictionary() != null) {
                    bdClasses.addAll(Arrays.asList(this.beanFilter.getBeanDictionary()));
                }
                if ((bean = this.classMeta.innerClass.getAnnotation(Bean.class)) != null && !bean.typeName().isEmpty()) {
                    bdClasses.add(this.classMeta.innerClass);
                }
                this.beanRegistry = new BeanRegistry(this.ctx, null, bdClasses.toArray(new Class[bdClasses.size()]));
                for (Bean b : ReflectionUtils.findAnnotationsParentFirst(Bean.class, this.classMeta.innerClass)) {
                    if (b.typePropertyName().isEmpty()) continue;
                    this.typePropertyName = b.typePropertyName();
                }
                if (this.typePropertyName == null) {
                    this.typePropertyName = this.ctx.getBeanTypePropertyName();
                }
                Class<T> c2 = this.beanFilter != null && this.beanFilter.getInterfaceClass() != null ? this.beanFilter.getInterfaceClass() : c;
                Class clazz = stopClass = this.beanFilter != null ? this.beanFilter.getStopClass() : Object.class;
                if (stopClass == null) {
                    stopClass = Object.class;
                }
                LinkedHashMap<String, BeanPropertyMeta.Builder> normalProps = new LinkedHashMap<String, BeanPropertyMeta.Builder>();
                if (this.ctx.isNotABean(c)) {
                    return "Class matches exclude-class list";
                }
                if (!cVis.isVisible(c.getModifiers()) && !c.isAnonymousClass()) {
                    return "Class is not public";
                }
                if (c.isAnnotationPresent(BeanIgnore.class)) {
                    return "Class is annotated with @BeanIgnore";
                }
                if (this.beanFilter == null && this.ctx.beansRequireSerializable && !ClassUtils.isParentClass(Serializable.class, c)) {
                    return "Class is not serializable";
                }
                for (Constructor<?> constructor : c.getConstructors()) {
                    if (!constructor.isAnnotationPresent(BeanConstructor.class)) continue;
                    if (this.constructor != null) {
                        throw new BeanRuntimeException(c, "Multiple instances of '@BeanConstructor' found.", new Object[0]);
                    }
                    this.constructor = constructor;
                    this.constructorArgs = StringUtils.split(constructor.getAnnotation(BeanConstructor.class).properties());
                    if (this.constructorArgs.length != constructor.getParameterTypes().length) {
                        throw new BeanRuntimeException(c, "Number of properties defined in '@BeanConstructor' annotation does not match number of parameters in constructor.", new Object[0]);
                    }
                    if (Visibility.setAccessible(this.constructor)) continue;
                    throw new BeanRuntimeException(c, "Could not set accessibility to true on method with @BeanConstructor annotation.  Method=''{0}''", this.constructor.getName());
                }
                if (this.constructor == null) {
                    this.constructor = this.ctx.getImplClassConstructor(c, conVis);
                }
                if (this.constructor == null) {
                    this.constructor = ClassUtils.findNoArgConstructor(c, conVis);
                }
                if (this.constructor == null && this.beanFilter == null && this.ctx.beansRequireDefaultConstructor) {
                    return "Class does not have the required no-arg constructor";
                }
                if (!Visibility.setAccessible(this.constructor)) {
                    throw new BeanRuntimeException(c, "Could not set accessibility to true on no-arg constructor", new Object[0]);
                }
                LinkedHashSet<String> fixedBeanProps = new LinkedHashSet<String>();
                String[] includeProperties = this.ctx.getIncludeProperties(c);
                String[] excludeProperties = this.ctx.getExcludeProperties(c);
                if (this.beanFilter != null) {
                    if (this.beanFilter.getProperties() != null && includeProperties == null) {
                        for (String string : this.beanFilter.getProperties()) {
                            fixedBeanProps.add(string);
                        }
                    }
                    if (this.beanFilter.getPropertyNamer() != null) {
                        this.propertyNamer = this.beanFilter.getPropertyNamer();
                    }
                }
                if (includeProperties != null) {
                    fixedBeanProps.addAll(Arrays.asList(includeProperties));
                }
                if (this.propertyNamer == null) {
                    this.propertyNamer = new PropertyNamerDefault();
                }
                for (String string : fixedBeanProps) {
                    normalProps.put(string, new BeanPropertyMeta.Builder(beanMeta, string));
                }
                if (this.ctx.useJavaBeanIntrospector) {
                    void var15_26;
                    Object var15_23 = null;
                    if (!c2.isInterface()) {
                        BeanInfo beanInfo = Introspector.getBeanInfo(c2, stopClass);
                    } else {
                        BeanInfo beanInfo = Introspector.getBeanInfo(c2, null);
                    }
                    if (var15_26 != null) {
                        void var18_64;
                        PropertyDescriptor[] propertyDescriptorArray = var15_26.getPropertyDescriptors();
                        int n = propertyDescriptorArray.length;
                        boolean bl = false;
                        while (var18_64 < n) {
                            PropertyDescriptor pd = propertyDescriptorArray[var18_64];
                            String name = pd.getName();
                            if (!normalProps.containsKey(name)) {
                                normalProps.put(name, new BeanPropertyMeta.Builder(beanMeta, name));
                            }
                            ((BeanPropertyMeta.Builder)normalProps.get(name)).setGetter(pd.getReadMethod()).setSetter(pd.getWriteMethod());
                            ++var18_64;
                        }
                    }
                } else {
                    for (Field field : BeanMeta.findBeanFields(c2, stopClass, fVis)) {
                        String name = this.findPropertyName(field, fixedBeanProps);
                        if (name == null) continue;
                        if (!normalProps.containsKey(name)) {
                            normalProps.put(name, new BeanPropertyMeta.Builder(beanMeta, name));
                        }
                        ((BeanPropertyMeta.Builder)normalProps.get(name)).setField(field);
                    }
                    List list = BeanMeta.findBeanMethods(c2, stopClass, mVis, fixedBeanProps, this.propertyNamer);
                    for (BeanMethod bm : list) {
                        String string = bm.propertyName;
                        m = bm.method;
                        if (!normalProps.containsKey(string)) {
                            normalProps.put(string, new BeanPropertyMeta.Builder(beanMeta, string));
                        }
                        BeanPropertyMeta.Builder bpm = (BeanPropertyMeta.Builder)normalProps.get(string);
                        if (bm.isSetter) continue;
                        bpm.setGetter((Method)m);
                    }
                    for (BeanMethod bm : list) {
                        BeanPropertyMeta.Builder builder;
                        if (!bm.isSetter || !bm.matchesPropertyType(builder = (BeanPropertyMeta.Builder)normalProps.get(bm.propertyName))) continue;
                        builder.setSetter(bm.method);
                    }
                }
                this.typeVarImpls = new HashMap();
                BeanMeta.findTypeVarImpls(c, this.typeVarImpls);
                if (this.typeVarImpls.isEmpty()) {
                    this.typeVarImpls = null;
                }
                Iterator iterator = normalProps.values().iterator();
                while (iterator.hasNext()) {
                    BeanPropertyMeta.Builder builder = (BeanPropertyMeta.Builder)iterator.next();
                    try {
                        if (builder.validate(this.ctx, this.beanRegistry, this.typeVarImpls)) {
                            if (builder.getter != null) {
                                this.getterProps.put(builder.getter, builder.name);
                            }
                            if (builder.setter == null) continue;
                            this.setterProps.put(builder.setter, builder.name);
                            continue;
                        }
                        iterator.remove();
                    }
                    catch (ClassNotFoundException e) {
                        throw new BeanRuntimeException(c, e.getLocalizedMessage(), new Object[0]);
                    }
                }
                for (String string : fixedBeanProps) {
                    if (normalProps.containsKey(string)) continue;
                    throw new BeanRuntimeException(c, "The property ''{0}'' was defined on the @Bean(properties=X) annotation but was not found on the class definition.", string);
                }
                for (String string : this.constructorArgs) {
                    m = (BeanPropertyMeta.Builder)normalProps.get(string);
                    if (m == null) {
                        throw new BeanRuntimeException(c, "The property ''{0}'' was defined on the @BeanConstructor(properties=X) annotation but was not found on the class definition.", string);
                    }
                    ((BeanPropertyMeta.Builder)m).setAsConstructorArg();
                }
                if (this.beanFilter == null && this.ctx.beansRequireSomeProperties && normalProps.size() == 0) {
                    return "No properties detected on bean class";
                }
                this.sortProperties = (this.ctx.sortProperties || this.beanFilter != null && this.beanFilter.isSortProperties()) && fixedBeanProps.isEmpty();
                Map<Object, Object> map = this.properties = this.sortProperties ? new TreeMap() : new LinkedHashMap();
                if (this.beanFilter != null && this.beanFilter.getTypeName() != null) {
                    this.dictionaryName = this.beanFilter.getTypeName();
                }
                if (this.dictionaryName == null) {
                    this.dictionaryName = this.findDictionaryName(this.classMeta);
                }
                for (Map.Entry entry : normalProps.entrySet()) {
                    BeanPropertyMeta pMeta = ((BeanPropertyMeta.Builder)entry.getValue()).build();
                    if (pMeta.isDyna()) {
                        this.dynaProperty = pMeta;
                    }
                    this.properties.put((String)entry.getKey(), pMeta);
                }
                if (this.beanFilter != null) {
                    String[] stringArray = this.beanFilter.getProperties();
                    String[] stringArray2 = this.beanFilter.getExcludeProperties();
                    if (stringArray2 != null && excludeProperties == null) {
                        for (String k : stringArray2) {
                            this.properties.remove(k);
                        }
                    } else if (stringArray != null) {
                        LinkedHashMap<String, BeanPropertyMeta> properties2 = new LinkedHashMap<String, BeanPropertyMeta>();
                        for (String k : stringArray) {
                            if (!this.properties.containsKey(k)) continue;
                            properties2.put(k, this.properties.get(k));
                        }
                        this.properties = properties2;
                    }
                }
                if (excludeProperties != null) {
                    for (String string : excludeProperties) {
                        this.properties.remove(string);
                    }
                }
                if (this.pNames != null) {
                    void var18_74;
                    LinkedHashMap<String, BeanPropertyMeta> linkedHashMap = new LinkedHashMap<String, BeanPropertyMeta>();
                    String[] stringArray = this.pNames;
                    int n = stringArray.length;
                    boolean bl = false;
                    while (var18_74 < n) {
                        String k = stringArray[var18_74];
                        if (this.properties.containsKey(k)) {
                            linkedHashMap.put(k, this.properties.get(k));
                        }
                        ++var18_74;
                    }
                    this.properties = linkedHashMap;
                }
            }
            catch (BeanRuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                return "Exception:  " + StringUtils.getStackTrace(e);
            }
            return null;
        }

        private String findDictionaryName(ClassMeta<?> cm) {
            String s;
            String s2;
            BeanRegistry br = cm.getBeanRegistry();
            if (br != null && (s2 = br.getTypeName(this.classMeta)) != null) {
                return s2;
            }
            Class pcm = cm.innerClass.getSuperclass();
            if (pcm != null && (s = this.findDictionaryName(this.ctx.getClassMeta(pcm))) != null) {
                return s;
            }
            for (Class<?> icm : cm.innerClass.getInterfaces()) {
                String s3 = this.findDictionaryName(this.ctx.getClassMeta(icm));
                if (s3 == null) continue;
                return s3;
            }
            return null;
        }

        private String findPropertyName(Field f, Set<String> fixedBeanProps) {
            BeanProperty bp = f.getAnnotation(BeanProperty.class);
            String name = BeanMeta.bpName(bp);
            if (!name.isEmpty()) {
                if (fixedBeanProps.isEmpty() || fixedBeanProps.contains(name)) {
                    return name;
                }
                return null;
            }
            name = this.propertyNamer.getPropertyName(f.getName());
            if (fixedBeanProps.isEmpty() || fixedBeanProps.contains(name)) {
                return name;
            }
            return null;
        }
    }
}

