/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import java.io.IOException;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import org.apache.juneau.BeanMapEntry;
import org.apache.juneau.BeanMeta;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.BeanRuntimeException;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Delegate;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ReaderParser;

public class BeanMap<T>
extends AbstractMap<String, Object>
implements Delegate<T> {
    protected T bean;
    protected Map<String, Object> propertyCache;
    protected Map<String, List<?>> arrayPropertyCache;
    protected BeanMeta<T> meta;
    private final BeanSession session;
    private final String beanTypePropertyName;

    protected BeanMap(BeanSession session, T bean, BeanMeta<T> meta) {
        this.session = session;
        this.bean = bean;
        this.meta = meta;
        if (meta.constructorArgs.length > 0) {
            this.propertyCache = new TreeMap<String, Object>();
        }
        this.beanTypePropertyName = session.getBeanTypePropertyName(meta.classMeta);
    }

    public BeanMeta<T> getMeta() {
        return this.meta;
    }

    public final BeanSession getBeanSession() {
        return this.session;
    }

    public T getBean() {
        T b = this.getBean(true);
        if (this.arrayPropertyCache != null) {
            for (Map.Entry<String, List<?>> e : this.arrayPropertyCache.entrySet()) {
                String key = e.getKey();
                List<?> value = e.getValue();
                BeanPropertyMeta bpm = this.getPropertyMeta(key);
                try {
                    bpm.setArray(b, value);
                }
                catch (Exception e1) {
                    throw new RuntimeException(e1);
                }
            }
            this.arrayPropertyCache = null;
        }
        return b;
    }

    public T getBean(boolean create) {
        if (this.bean == null && create && this.meta.constructorArgs.length > 0) {
            String[] props = this.meta.constructorArgs;
            Constructor c = this.meta.constructor;
            Object[] args = new Object[props.length];
            for (int i = 0; i < props.length; ++i) {
                args[i] = this.propertyCache.remove(props[i]);
            }
            try {
                this.bean = c.newInstance(args);
                for (Map.Entry<String, Object> e : this.propertyCache.entrySet()) {
                    this.put(e.getKey(), e.getValue());
                }
                this.propertyCache = null;
            }
            catch (IllegalArgumentException e) {
                throw new BeanRuntimeException("IllegalArgumentException occurred on call to class constructor ''{0}'' with argument types ''{1}''", c.getName(), JsonSerializer.DEFAULT_LAX.toString(ClassUtils.getClasses(args)));
            }
            catch (Exception e) {
                throw new BeanRuntimeException(e);
            }
        }
        return this.bean;
    }

    @Override
    public Object put(String property, Object value) {
        BeanPropertyMeta p = this.meta.properties.get(property);
        if (p == null) {
            if (this.meta.ctx.ignoreUnknownBeanProperties) {
                return null;
            }
            if (property.equals(this.beanTypePropertyName)) {
                return null;
            }
            throw new BeanRuntimeException(this.meta.c, "Bean property ''{0}'' not found.", property);
        }
        if (this.meta.beanFilter != null && this.meta.beanFilter.writeProperty(this.bean, property, value)) {
            return null;
        }
        return p.set(this, property, value);
    }

    public void add(String property, Object value) {
        BeanPropertyMeta p = this.meta.properties.get(property);
        if (p == null) {
            if (this.meta.ctx.ignoreUnknownBeanProperties) {
                return;
            }
            throw new BeanRuntimeException(this.meta.c, "Bean property ''{0}'' not found.", property);
        }
        p.add(this, property, value);
    }

    @Override
    public Object get(Object property) {
        String pName = StringUtils.toString(property);
        BeanPropertyMeta p = this.getPropertyMeta(pName);
        if (p == null) {
            return null;
        }
        if (this.meta.beanFilter != null) {
            return this.meta.beanFilter.readProperty(this.bean, pName, p.get(this, pName));
        }
        return p.get(this, pName);
    }

    public Object getRaw(Object property) {
        String pName = StringUtils.toString(property);
        BeanPropertyMeta p = this.getPropertyMeta(pName);
        if (p == null) {
            return null;
        }
        return p.getRaw(this, pName);
    }

    public BeanMap<T> load(String input) throws ParseException {
        this.putAll(new ObjectMap(input, (Parser)this.meta.ctx.defaultParser));
        return this;
    }

    public BeanMap<T> load(Reader r, ReaderParser p) throws ParseException, IOException {
        this.putAll(new ObjectMap(r, (Parser)p));
        return this;
    }

    public BeanMap<T> load(Map entries) {
        this.putAll(entries);
        return this;
    }

    @Override
    public Set<String> keySet() {
        if (this.meta.dynaProperty == null) {
            return this.meta.properties.keySet();
        }
        LinkedHashSet<String> l = new LinkedHashSet<String>();
        for (String p : this.meta.properties.keySet()) {
            if ("*".equals(p)) continue;
            l.add(p);
        }
        try {
            l.addAll(this.meta.dynaProperty.getDynaMap(this.bean).keySet());
        }
        catch (Exception e) {
            throw new BeanRuntimeException(e);
        }
        return l;
    }

    public BeanMapEntry getProperty(String propertyName) {
        BeanPropertyMeta p = this.getPropertyMeta(propertyName);
        if (p == null) {
            return null;
        }
        return new BeanMapEntry(this, p, propertyName);
    }

    public BeanPropertyMeta getPropertyMeta(String propertyName) {
        BeanPropertyMeta bpMeta = this.meta.properties.get(propertyName);
        if (bpMeta == null) {
            bpMeta = this.meta.dynaProperty;
        }
        return bpMeta;
    }

    @Override
    public ClassMeta<T> getClassMeta() {
        return this.meta.getClassMeta();
    }

    public List<BeanPropertyValue> getValues(boolean ignoreNulls, BeanPropertyValue ... prependVals) {
        Collection<BeanPropertyMeta> properties = this.getProperties();
        int capacity = ignoreNulls && properties.size() > 10 ? 10 : properties.size() + prependVals.length;
        ArrayList<BeanPropertyValue> l = new ArrayList<BeanPropertyValue>(capacity);
        for (BeanPropertyValue v : prependVals) {
            if (v == null) continue;
            l.add(v);
        }
        for (BeanPropertyMeta bpm : properties) {
            try {
                if (bpm.isDyna()) {
                    for (String pName : bpm.getDynaMap(this.bean).keySet()) {
                        Object val = bpm.get(this, pName);
                        if (val == null && ignoreNulls) continue;
                        l.add(new BeanPropertyValue(bpm, pName, val, null));
                    }
                    continue;
                }
                Object val = bpm.get(this, null);
                if (val == null && ignoreNulls) continue;
                l.add(new BeanPropertyValue(bpm, bpm.getName(), val, null));
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable t) {
                l.add(new BeanPropertyValue(bpm, bpm.getName(), null, t));
            }
        }
        if (this.meta.sortProperties && this.meta.dynaProperty != null) {
            Collections.sort(l);
        }
        return l;
    }

    public String resolveVars(String s) {
        return StringUtils.replaceVars(s, this);
    }

    protected Collection<BeanPropertyMeta> getProperties() {
        return this.meta.properties.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        if (this.meta.dynaProperty != null) {
            LinkedHashSet<Map.Entry<String, Object>> s = new LinkedHashSet<Map.Entry<String, Object>>();
            for (BeanPropertyMeta pMeta : this.getProperties()) {
                if (pMeta.isDyna()) {
                    try {
                        for (Map.Entry<String, Object> e : pMeta.getDynaMap(this.bean).entrySet()) {
                            s.add(new BeanMapEntry(this, pMeta, e.getKey()));
                        }
                        continue;
                    }
                    catch (Exception e) {
                        throw new BeanRuntimeException(e);
                    }
                }
                s.add(new BeanMapEntry(this, pMeta, pMeta.getName()));
            }
            return s;
        }
        AbstractSet<Map.Entry<String, Object>> s = new AbstractSet<Map.Entry<String, Object>>(){
            final Collection<BeanPropertyMeta> pSet;
            {
                this.pSet = BeanMap.this.getProperties();
            }

            @Override
            public Iterator<Map.Entry<String, Object>> iterator() {
                return new Iterator<Map.Entry<String, Object>>(){
                    final Iterator<BeanPropertyMeta> pIterator;
                    {
                        this.pIterator = pSet.iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.pIterator.hasNext();
                    }

                    @Override
                    public Map.Entry<String, Object> next() {
                        return new BeanMapEntry(BeanMap.this, this.pIterator.next(), null);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException("Cannot remove item from iterator.");
                    }
                };
            }

            @Override
            public int size() {
                return this.pSet.size();
            }
        };
        return s;
    }

    void setBean(Object bean) {
        this.bean = bean;
    }
}

