/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.yaml.proto;

import java.io.IOException;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserReader;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.parser.ReaderParserSession;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.yaml.proto.YamlParserContext;

public final class YamlParserSession
extends ReaderParserSession {
    private static final AsciiSet decChars = new AsciiSet("0123456789");

    protected YamlParserSession(YamlParserContext ctx, ParserSessionArgs args) {
        super(ctx, args);
    }

    protected final boolean isWhitespace(int cp) {
        if (this.isStrict()) {
            return cp <= 32 && (cp == 9 || cp == 10 || cp == 13 || cp == 32);
        }
        return Character.isWhitespace(cp);
    }

    protected final boolean isCommentOrWhitespace(int cp) {
        if (cp == 47) {
            return true;
        }
        if (this.isStrict()) {
            return cp <= 32 && (cp == 9 || cp == 10 || cp == 13 || cp == 32);
        }
        return Character.isWhitespace(cp);
    }

    @Override
    protected <T> T doParse(ParserPipe pipe, ClassMeta<T> type) throws Exception {
        ParserReader r = pipe.getParserReader();
        if (r == null) {
            return null;
        }
        T o = this.parseAnything(type, r, this.getOuter(), null);
        this.validateEnd(r);
        return o;
    }

    @Override
    protected <K, V> Map<K, V> doParseIntoMap(ParserPipe pipe, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        ParserReader r = pipe.getParserReader();
        m = this.parseIntoMap2(r, m, this.getClassMeta(keyType, new Type[0]), this.getClassMeta(valueType, new Type[0]), null);
        this.validateEnd(r);
        return m;
    }

    @Override
    protected <E> Collection<E> doParseIntoCollection(ParserPipe pipe, Collection<E> c, Type elementType) throws Exception {
        ParserReader r = pipe.getParserReader();
        c = this.parseIntoCollection2(r, c, this.getClassMeta(elementType, new Type[0]), null);
        this.validateEnd(r);
        return c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T> T parseAnything(ClassMeta<T> eType, ParserReader r, Object outer, BeanPropertyMeta pMeta) throws Exception {
        PojoSwap<Object, Object> swap;
        if (eType == null) {
            eType = this.object();
        }
        ClassMeta<Object> sType = (swap = eType.getPojoSwap(this)) == null ? eType : swap.getSwapClassMeta(this);
        this.setCurrentClass(sType);
        Object o = null;
        this.skipCommentsAndSpace(r);
        int c = r.peek();
        if (c == -1) {
            if (this.isStrict()) {
                throw new ParseException(r.getLocation(this), "Empty input.", new Object[0]);
            }
        } else if (c == 44 || c == 125 || c == 93) {
            if (this.isStrict()) {
                throw new ParseException(r.getLocation(this), "Missing value detected.", new Object[0]);
            }
        } else if (c == 110) {
            this.parseKeyword("null", r);
        } else if (sType.isObject()) {
            if (c == 123) {
                ObjectMap objectMap = new ObjectMap(this);
                this.parseIntoMap2(r, objectMap, this.string(), this.object(), pMeta);
                o = this.cast(objectMap, pMeta, eType);
            } else if (c == 91) {
                o = this.parseIntoCollection2(r, new ObjectList(this), this.object(), pMeta);
            } else if (c == 39 || c == 34) {
                o = this.parseString(r);
                if (sType.isChar()) {
                    o = Character.valueOf(o.toString().charAt(0));
                }
            } else if (c >= 48 && c <= 57 || c == 45 || c == 46) {
                o = this.parseNumber(r, null);
            } else if (c == 116) {
                this.parseKeyword("true", r);
                o = Boolean.TRUE;
            } else {
                this.parseKeyword("false", r);
                o = Boolean.FALSE;
            }
        } else if (sType.isBoolean()) {
            o = this.parseBoolean(r);
        } else if (sType.isCharSequence()) {
            o = this.parseString(r);
        } else if (sType.isChar()) {
            o = Character.valueOf(this.parseString(r).charAt(0));
        } else if (sType.isNumber()) {
            o = this.parseNumber(r, sType.getInnerClass());
        } else if (sType.isMap()) {
            Map<String, Object> map = sType.canCreateNewInstance(outer) ? (Map)sType.newInstance(outer) : new ObjectMap(this);
            o = this.parseIntoMap2(r, map, sType.getKeyType(), sType.getValueType(), pMeta);
        } else if (sType.isCollection()) {
            if (c == 123) {
                ObjectMap objectMap = new ObjectMap(this);
                this.parseIntoMap2(r, objectMap, this.string(), this.object(), pMeta);
                o = this.cast(objectMap, pMeta, eType);
            } else {
                Collection<Object> collection = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance() : new ObjectList(this);
                o = this.parseIntoCollection2(r, collection, sType, pMeta);
            }
        } else if (sType.canCreateNewBean(outer)) {
            BeanMap<Object> beanMap = this.newBeanMap(outer, sType.getInnerClass());
            o = this.parseIntoBeanMap2(r, beanMap).getBean();
        } else if (sType.canCreateNewInstanceFromString(outer) && (c == 39 || c == 34)) {
            o = sType.newInstanceFromString(outer, this.parseString(r));
        } else if (sType.canCreateNewInstanceFromNumber(outer) && StringUtils.isFirstNumberChar((char)c)) {
            o = sType.newInstanceFromNumber(this, outer, this.parseNumber(r, sType.getNewInstanceFromNumberClass()));
        } else if (sType.isArray() || sType.isArgs()) {
            if (c == 123) {
                ObjectMap objectMap = new ObjectMap(this);
                this.parseIntoMap2(r, objectMap, this.string(), this.object(), pMeta);
                o = this.cast(objectMap, pMeta, eType);
            } else {
                ArrayList arrayList = (ArrayList)this.parseIntoCollection2(r, new ArrayList(), sType, pMeta);
                o = this.toArray(sType, arrayList);
            }
        } else if (c == 123) {
            ObjectMap objectMap = new ObjectMap(this);
            this.parseIntoMap2(r, objectMap, sType.getKeyType(), sType.getValueType(), pMeta);
            if (!objectMap.containsKey(this.getBeanTypePropertyName(eType))) throw new ParseException(r.getLocation(this), "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", sType.getInnerClass().getName(), sType.getNotABeanReason());
            o = this.cast(objectMap, pMeta, eType);
        } else {
            if (!sType.canCreateNewInstanceFromString(outer) || this.isStrict()) throw new ParseException(r.getLocation(this), "Unrecognized syntax for class type ''{0}'', starting character ''{1}''", sType, Character.valueOf((char)c));
            o = sType.newInstanceFromString(outer, this.parseString(r));
        }
        if (swap != null && o != null) {
            o = swap.unswap(this, o, eType);
        }
        if (outer == null) return (T)o;
        YamlParserSession.setParent(eType, o, outer);
        return (T)o;
    }

    private Number parseNumber(ParserReader r, Class<? extends Number> type) throws Exception {
        int c = r.peek();
        if (c == 39 || c == 34) {
            return this.parseNumber(r, this.parseString(r), type);
        }
        return this.parseNumber(r, StringUtils.parseNumberString(r), type);
    }

    private Number parseNumber(ParserReader r, String s, Class<? extends Number> type) throws Exception {
        if (this.isStrict()) {
            char c2;
            if (s.length() == 0) {
                throw new ParseException(r.getLocation(this), "Invalid JSON number: ''{0}''", s);
            }
            boolean isNegative = false;
            int c = s.charAt(0);
            if (c == 45) {
                isNegative = true;
                int n = c = s.length() == 1 ? 120 : (int)s.charAt(1);
            }
            if (c == 46) {
                throw new ParseException(this.loc(r), "Invalid JSON number: ''{0}''", s);
            }
            if (c == 48 && s.length() > (isNegative ? 2 : 1) && (c2 = s.charAt(isNegative ? 2 : 1)) != '.' && c2 != 'e' && c2 != 'E') {
                throw new ParseException(this.loc(r), "Invalid JSON number: ''{0}''", s);
            }
            int i = s.indexOf(46);
            if (!(i == -1 || s.length() != i + 1 && decChars.contains(s.charAt(i + 1)))) {
                throw new ParseException(this.loc(r), "Invalid JSON number: ''{0}''", s);
            }
        }
        return StringUtils.parseNumber(s, type);
    }

    private Boolean parseBoolean(ParserReader r) throws Exception {
        int c = r.peek();
        if (c == 39 || c == 34) {
            return Boolean.valueOf(this.parseString(r));
        }
        if (c == 116) {
            this.parseKeyword("true", r);
            return Boolean.TRUE;
        }
        this.parseKeyword("false", r);
        return Boolean.FALSE;
    }

    private <K, V> Map<K, V> parseIntoMap2(ParserReader r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType, BeanPropertyMeta pMeta) throws Exception {
        if (keyType == null) {
            keyType = this.string();
        }
        int S0 = 0;
        int S1 = 1;
        int S3 = 3;
        int S4 = 4;
        int S5 = 5;
        int S6 = 6;
        int state = S0;
        String currAttr = null;
        int c = 0;
        while (c != -1) {
            c = r.read();
            if (state == S0) {
                if (c != 123) continue;
                state = S1;
                continue;
            }
            if (state == S1) {
                if (c == 125) {
                    return m;
                }
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                currAttr = this.parseFieldName(r.unread());
                state = S3;
                continue;
            }
            if (state == S3) {
                if (c != 58) continue;
                state = S4;
                continue;
            }
            if (state == S4) {
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                K key = this.convertAttrToType(m, currAttr, keyType);
                V value = this.parseAnything(valueType, r.unread(), m, pMeta);
                YamlParserSession.setName(valueType, value, key);
                m.put(key, value);
                state = S5;
                continue;
            }
            if (state == S5) {
                if (c == 44) {
                    state = S6;
                    continue;
                }
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                if (c != 125) break;
                return m;
            }
            if (state != S6) continue;
            if (c == 125) break;
            if (this.isCommentOrWhitespace(c)) {
                this.skipCommentsAndSpace(r.unread());
                continue;
            }
            currAttr = this.parseFieldName(r.unread());
            state = S3;
        }
        if (state == S0) {
            throw new ParseException(this.loc(r), "Expected '{' at beginning of JSON object.", new Object[0]);
        }
        if (state == S1) {
            throw new ParseException(this.loc(r), "Could not find attribute name on JSON object.", new Object[0]);
        }
        if (state == S3) {
            throw new ParseException(this.loc(r), "Could not find ':' following attribute name on JSON object.", new Object[0]);
        }
        if (state == S4) {
            throw new ParseException(this.loc(r), "Expected one of the following characters: {,[,',\",LITERAL.", new Object[0]);
        }
        if (state == S5) {
            throw new ParseException(this.loc(r), "Could not find '}' marking end of JSON object.", new Object[0]);
        }
        if (state == S6) {
            throw new ParseException(this.loc(r), "Unexpected '}' found in JSON object.", new Object[0]);
        }
        return null;
    }

    private String parseFieldName(ParserReader r) throws Exception {
        int c = r.peek();
        if (c == 39 || c == 34) {
            return this.parseString(r);
        }
        if (this.isStrict()) {
            throw new ParseException(this.loc(r), "Unquoted attribute detected.", new Object[0]);
        }
        r.mark();
        while (c != -1) {
            c = r.read();
            if (c != 58 && !this.isWhitespace(c) && c != 47) continue;
            r.unread();
            String s = r.getMarked().intern();
            return s.equals("null") ? null : s;
        }
        throw new ParseException(this.loc(r), "Could not find the end of the field name.", new Object[0]);
    }

    private <E> Collection<E> parseIntoCollection2(ParserReader r, Collection<E> l, ClassMeta<?> type, BeanPropertyMeta pMeta) throws Exception {
        int S0 = 0;
        int S1 = 1;
        int S2 = 2;
        int S3 = 3;
        int argIndex = 0;
        int state = S0;
        int c = 0;
        while (c != -1) {
            c = r.read();
            if (state == S0) {
                if (c != 91) continue;
                state = S1;
                continue;
            }
            if (state == S1) {
                if (c == 93) {
                    return l;
                }
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                if (c == -1) continue;
                l.add(this.parseAnything(type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), r.unread(), l, pMeta));
                state = S2;
                continue;
            }
            if (state == S2) {
                if (c == 44) {
                    state = S3;
                    continue;
                }
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                if (c != 93) break;
                return l;
            }
            if (state != S3) continue;
            if (this.isCommentOrWhitespace(c)) {
                this.skipCommentsAndSpace(r.unread());
                continue;
            }
            if (c == 93) break;
            if (c == -1) continue;
            l.add(this.parseAnything(type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), r.unread(), l, pMeta));
            state = S2;
        }
        if (state == S0) {
            throw new ParseException(this.loc(r), "Expected '[' at beginning of JSON array.", new Object[0]);
        }
        if (state == S1) {
            throw new ParseException(this.loc(r), "Expected one of the following characters: {,[,',\",LITERAL.", new Object[0]);
        }
        if (state == S2) {
            throw new ParseException(this.loc(r), "Expected ',' or ']'.", new Object[0]);
        }
        if (state == S3) {
            throw new ParseException(this.loc(r), "Unexpected trailing comma in array.", new Object[0]);
        }
        return null;
    }

    private <T> BeanMap<T> parseIntoBeanMap2(ParserReader r, BeanMap<T> m) throws Exception {
        int S0 = 0;
        int S1 = 1;
        int S3 = 3;
        int S4 = 4;
        int S5 = 5;
        int state = S0;
        String currAttr = "";
        int c = 0;
        int currAttrLine = -1;
        int currAttrCol = -1;
        while (c != -1) {
            c = r.read();
            if (state == S0) {
                if (c != 123) continue;
                state = S1;
                continue;
            }
            if (state == S1) {
                if (c == 125) {
                    return m;
                }
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                r.unread();
                currAttrLine = r.getLine();
                currAttrCol = r.getColumn();
                currAttr = this.parseFieldName(r);
                state = S3;
                continue;
            }
            if (state == S3) {
                if (c != 58) continue;
                state = S4;
                continue;
            }
            if (state == S4) {
                if (this.isCommentOrWhitespace(c)) {
                    this.skipCommentsAndSpace(r.unread());
                    continue;
                }
                if (!currAttr.equals(this.getBeanTypePropertyName(m.getClassMeta()))) {
                    BeanPropertyMeta pMeta = m.getPropertyMeta(currAttr);
                    this.setCurrentProperty(pMeta);
                    if (pMeta == null) {
                        this.onUnknownProperty(r.getPipe(), currAttr, m, currAttrLine, currAttrCol);
                        this.parseAnything(this.object(), r.unread(), m.getBean(false), null);
                    } else {
                        ClassMeta<?> cm = pMeta.getClassMeta();
                        Object value = this.parseAnything(cm, r.unread(), m.getBean(false), pMeta);
                        YamlParserSession.setName(cm, value, currAttr);
                        pMeta.set(m, currAttr, value);
                    }
                    this.setCurrentProperty(null);
                }
                state = S5;
                continue;
            }
            if (state != S5) continue;
            if (c == 44) {
                state = S1;
                continue;
            }
            if (this.isCommentOrWhitespace(c)) {
                this.skipCommentsAndSpace(r.unread());
                continue;
            }
            if (c != 125) continue;
            return m;
        }
        if (state == S0) {
            throw new ParseException(this.loc(r), "Expected '{' at beginning of JSON object.", new Object[0]);
        }
        if (state == S1) {
            throw new ParseException(this.loc(r), "Could not find attribute name on JSON object.", new Object[0]);
        }
        if (state == S3) {
            throw new ParseException(this.loc(r), "Could not find ':' following attribute name on JSON object.", new Object[0]);
        }
        if (state == S4) {
            throw new ParseException(this.loc(r), "Expected one of the following characters: {,[,',\",LITERAL.", new Object[0]);
        }
        if (state == S5) {
            throw new ParseException(this.loc(r), "Could not find '}' marking end of JSON object.", new Object[0]);
        }
        return null;
    }

    private String parseString(ParserReader r) throws Exception {
        r.mark();
        int qc = r.read();
        if (qc != 34 && this.isStrict()) {
            String msg = qc == 39 ? "Invalid quote character \"{0}\" being used." : "Did not find quote character marking beginning of string.  Character=\"{0}\"";
            throw new ParseException(this.loc(r), msg, Character.valueOf((char)qc));
        }
        boolean isQuoted = qc == 39 || qc == 34;
        String s = null;
        boolean isInEscape = false;
        int c = 0;
        while (c != -1) {
            c = r.read();
            if (this.isStrict() && c <= 31) {
                throw new ParseException("Unescaped control character encountered: ''0x{0}''", String.format("%04X", c));
            }
            if (isInEscape) {
                switch (c) {
                    case 110: {
                        r.replace('\n');
                        break;
                    }
                    case 114: {
                        r.replace('\r');
                        break;
                    }
                    case 116: {
                        r.replace('\t');
                        break;
                    }
                    case 102: {
                        r.replace('\f');
                        break;
                    }
                    case 98: {
                        r.replace('\b');
                        break;
                    }
                    case 92: {
                        r.replace('\\');
                        break;
                    }
                    case 47: {
                        r.replace('/');
                        break;
                    }
                    case 39: {
                        r.replace('\'');
                        break;
                    }
                    case 34: {
                        r.replace('\"');
                        break;
                    }
                    case 117: {
                        String n = r.read(4);
                        try {
                            r.replace(Integer.parseInt(n, 16), 6);
                            break;
                        }
                        catch (NumberFormatException e) {
                            throw new ParseException(this.loc(r), "Invalid Unicode escape sequence in string.", new Object[0]);
                        }
                    }
                    default: {
                        throw new ParseException(this.loc(r), "Invalid escape sequence in string.", new Object[0]);
                    }
                }
                isInEscape = false;
                continue;
            }
            if (c == 92) {
                isInEscape = true;
                r.delete();
                continue;
            }
            if (isQuoted) {
                if (c != qc) continue;
                s = r.getMarked(1, -1);
                break;
            }
            if (c == 44 || c == 125 || c == 93 || this.isWhitespace(c)) {
                s = r.getMarked(0, -1);
                r.unread();
                break;
            }
            if (c != -1) continue;
            s = r.getMarked(0, 0);
            break;
        }
        if (s == null) {
            throw new ParseException(this.loc(r), "Could not find expected end character ''{0}''.", Character.valueOf((char)qc));
        }
        this.skipCommentsAndSpace(r);
        if (r.peek() == 43) {
            if (this.isStrict()) {
                throw new ParseException(this.loc(r), "String concatenation detected.", new Object[0]);
            }
            r.read();
            this.skipCommentsAndSpace(r);
            s = s + this.parseString(r);
        }
        return this.trim(s);
    }

    private void parseKeyword(String keyword, ParserReader r) throws Exception {
        try {
            String s = r.read(keyword.length());
            if (s.equals(keyword)) {
                return;
            }
            throw new ParseException(this.loc(r), "Unrecognized syntax.", new Object[0]);
        }
        catch (IndexOutOfBoundsException e) {
            throw new ParseException(this.loc(r), "Unrecognized syntax.", new Object[0]);
        }
    }

    private void skipCommentsAndSpace(ParserReader r) throws Exception {
        int c = 0;
        while ((c = r.read()) != -1) {
            if (this.isWhitespace(c)) continue;
            if (c == 47) {
                if (this.isStrict()) {
                    throw new ParseException(this.loc(r), "Javascript comment detected.", new Object[0]);
                }
                this.skipComments(r);
                continue;
            }
            r.unread();
            return;
        }
    }

    private void skipComments(ParserReader r) throws ParseException, IOException {
        block3: {
            int c;
            block2: {
                c = r.read();
                if (c != 42) break block2;
                while (c != -1) {
                    c = r.read();
                    if (c != 42 || (c = r.read()) != 47) continue;
                    return;
                }
                break block3;
            }
            if (c != 47) break block3;
            while (c != -1) {
                c = r.read();
                if (c != -1 && c != 10) continue;
                return;
            }
        }
        throw new ParseException(this.loc(r), "Open ended comment.", new Object[0]);
    }

    private void validateEnd(ParserReader r) throws Exception {
        this.skipCommentsAndSpace(r);
        int c = r.read();
        if (c != -1 && c != 59) {
            throw new ParseException(this.loc(r), "Remainder after parse: ''{0}''.", Character.valueOf((char)c));
        }
    }

    private ObjectMap loc(ParserReader r) {
        return this.getLastLocation().append("line", r.getLine()).append("column", r.getColumn());
    }
}

