/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.xml;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.xml.Namespace;

public final class NamespaceFactory {
    private static ConcurrentHashMap<String, Namespace> cache = new ConcurrentHashMap();

    public static Namespace get(String name, String uri) {
        String key = name + "+" + uri;
        Namespace n = cache.get(key);
        if (n == null) {
            n = new Namespace(name, uri);
            Namespace n2 = cache.putIfAbsent(key, n);
            return n2 == null ? n : n2;
        }
        return n;
    }

    public static Namespace parseNamespace(Object o) {
        if (o == null) {
            return null;
        }
        if (o instanceof Namespace) {
            return (Namespace)o;
        }
        try {
            Map m;
            Map map = m = o instanceof Map ? (Map)o : new ObjectMap(o.toString());
            if (m.size() == 0) {
                return null;
            }
            if (m.size() > 1) {
                throw new FormattedRuntimeException("Too many namespaces specified.  Only one allowed. ''{0}''", o);
            }
            Map.Entry e = m.entrySet().iterator().next();
            return NamespaceFactory.get(e.getKey().toString(), e.getValue().toString());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Namespace[] parseNamespaces(Object o) {
        try {
            Namespace[] n;
            if (o instanceof Namespace[]) {
                return (Namespace[])o;
            }
            if (o instanceof CharSequence) {
                o = new ObjectMap(o.toString());
            }
            int i = 0;
            if (o instanceof Collection) {
                Collection c = (Collection)o;
                n = new Namespace[c.size()];
                for (Object o2 : c) {
                    n[i++] = NamespaceFactory.parseNamespace(o2);
                }
            } else if (o instanceof Map) {
                Map m = (Map)o;
                n = new Namespace[m.size()];
                for (Map.Entry e : m.entrySet()) {
                    n[i++] = NamespaceFactory.get(e.getKey().toString(), e.getValue().toString());
                }
            } else {
                throw new FormattedRuntimeException("Invalid type passed to NamespaceFactory.listFromObject: ''{0}''", o);
            }
            return n;
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

