/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.PartType;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.parser.PartParser;
import org.apache.juneau.uon.UonParser;
import org.apache.juneau.uon.UonParserSession;
import org.apache.juneau.uon.UonReader;
import org.apache.juneau.urlencoding.UrlEncodingParserBuilder;
import org.apache.juneau.urlencoding.UrlEncodingParserContext;
import org.apache.juneau.urlencoding.UrlEncodingParserSession;

public class UrlEncodingParser
extends UonParser
implements PartParser {
    public static final UrlEncodingParser DEFAULT = new UrlEncodingParser(PropertyStore.create());
    private final UrlEncodingParserContext ctx = this.createContext(UrlEncodingParserContext.class);

    public UrlEncodingParser(PropertyStore propertyStore) {
        super(propertyStore.copy().append("UonParser.decodeChars", true), "application/x-www-form-urlencoded");
    }

    @Override
    public UrlEncodingParserBuilder builder() {
        return new UrlEncodingParserBuilder(this.propertyStore);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String[]> parseIntoSimpleMap(String qs, Map<String, String[]> map) throws Exception {
        TreeMap<String, String[]> m;
        TreeMap<String, String[]> treeMap = m = map == null ? new TreeMap<String, String[]>() : map;
        if (StringUtils.isEmpty(qs)) {
            return m;
        }
        ParserPipe p = new ParserPipe(qs, false, false, null, null);
        UonReader r = new UonReader(p, true);
        boolean S1 = true;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        try {
            int c = r.peekSkipWs();
            if (c == 63) {
                r.read();
            }
            int state = 1;
            String currAttr = null;
            while (c != -1) {
                c = r.read();
                if (state == 1) {
                    if (c == -1) continue;
                    r.unread();
                    r.mark();
                    state = 2;
                    continue;
                }
                if (state == 2) {
                    if (c == -1) {
                        UrlEncodingParser.add(m, r.getMarked(), null);
                        continue;
                    }
                    if (c == 1) {
                        m.put(r.getMarked(0, -1), null);
                        state = 1;
                        continue;
                    }
                    if (c != 2) continue;
                    currAttr = r.getMarked(0, -1);
                    state = 3;
                    continue;
                }
                if (state == 3) {
                    if (c == -1 || c == 1) {
                        UrlEncodingParser.add(m, currAttr, "");
                        continue;
                    }
                    if (c == 2) {
                        r.replace('=');
                    }
                    r.unread();
                    r.mark();
                    state = 4;
                    continue;
                }
                if (state != 4) continue;
                if (c == -1) {
                    UrlEncodingParser.add(m, currAttr, r.getMarked());
                    continue;
                }
                if (c == 1) {
                    UrlEncodingParser.add(m, currAttr, r.getMarked(0, -1));
                    state = 1;
                    continue;
                }
                if (c != 2) continue;
                r.replace('=');
            }
        }
        finally {
            r.close();
        }
        return m;
    }

    private static void add(Map<String, String[]> m, String key, String val) {
        boolean b = m.containsKey(key);
        if (val == null) {
            if (!b) {
                m.put(key, null);
            }
        } else if (b && m.get(key) != null) {
            m.put(key, ArrayUtils.append((Object[])m.get(key), val));
        } else {
            m.put(key, new String[]{val});
        }
    }

    @Override
    public <T> T parse(PartType partType, String in, ClassMeta<T> type) throws ParseException {
        if (in == null) {
            return null;
        }
        if (type.isString() && in.length() > 0) {
            char x = StringUtils.firstNonWhitespaceChar(in);
            if (x != '\'' && x != 'n' && in.indexOf(126) == -1) {
                return (T)in;
            }
            if (x == 'n' && "null".equals(in)) {
                return null;
            }
        }
        UonParserSession session = this.createParameterSession();
        ParserPipe pipe = session.createPipe(in);
        try {
            UonReader r = session.getUonReader(pipe, false);
            T t = session.parseAnything(type, r, null, true, null);
            return t;
        }
        catch (ParseException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ParseException(session.getLastLocation(), e);
        }
        finally {
            pipe.close();
            session.close();
        }
    }

    @Override
    public UrlEncodingParserSession createSession(ParserSessionArgs args) {
        return new UrlEncodingParserSession(this.ctx, args);
    }
}

