/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.parser;

import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.CoreObject;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.parser.ParserSession;
import org.apache.juneau.parser.ParserSessionArgs;

public abstract class Parser
extends CoreObject {
    private final MediaType[] consumes;

    Parser(PropertyStore propertyStore, String ... consumes) {
        super(propertyStore);
        this.consumes = new MediaType[consumes.length];
        for (int i = 0; i < consumes.length; ++i) {
            this.consumes[i] = MediaType.forString(consumes[i]);
        }
    }

    @Override
    public ParserBuilder builder() {
        return new ParserBuilder(this.propertyStore);
    }

    public abstract boolean isReaderParser();

    public abstract ParserSession createSession(ParserSessionArgs var1);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T parse(Object input, Type type, Type ... args) throws ParseException {
        ParserSession session = this.createSession();
        try {
            Object t = session.parse(input, type, args);
            return t;
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T parse(Object input, Class<T> type) throws ParseException {
        ParserSession session = this.createSession();
        try {
            T t = session.parse(input, type);
            return t;
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T parse(Object input, ClassMeta<T> type) throws ParseException {
        ParserSession session = this.createSession();
        try {
            T t = session.parse(input, type);
            return t;
        }
        finally {
            session.close();
        }
    }

    public final ParserSession createSession() {
        return this.createSession(this.createDefaultSessionArgs());
    }

    protected final ParserSessionArgs createDefaultSessionArgs() {
        return new ParserSessionArgs(ObjectMap.EMPTY_MAP, null, null, null, this.getPrimaryMediaType(), null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <K, V> Map<K, V> parseIntoMap(Object input, Map<K, V> m, Type keyType, Type valueType) throws ParseException {
        ParserSession session = this.createSession();
        try {
            Map<K, V> map = session.parseIntoMap(input, m, keyType, valueType);
            return map;
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <E> Collection<E> parseIntoCollection(Object input, Collection<E> c, Type elementType) throws ParseException {
        ParserSession session = this.createSession();
        try {
            Collection<E> collection = session.parseIntoCollection(input, c, elementType);
            return collection;
        }
        finally {
            session.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final Object[] parseArgs(Object input, Type[] argTypes) throws ParseException {
        if (argTypes == null || argTypes.length == 0) {
            return new Object[0];
        }
        ParserSession session = this.createSession();
        try {
            Object[] objectArray = session.parseArgs(input, argTypes);
            return objectArray;
        }
        finally {
            session.close();
        }
    }

    public final MediaType[] getMediaTypes() {
        return this.consumes;
    }

    public final MediaType getPrimaryMediaType() {
        return this.consumes == null || this.consumes.length == 0 ? null : this.consumes[0];
    }
}

