/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.nio.charset.Charset;
import org.apache.juneau.FormattedIllegalArgumentException;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.utils.IOPipe;

public final class IOUtils {
    public static final Charset UTF8 = Charset.forName("UTF-8");

    public static String readFile(String path) throws IOException {
        return IOUtils.read(new File(path));
    }

    public static String read(File in) throws IOException {
        if (in == null || !in.exists()) {
            return null;
        }
        InputStreamReader r = new InputStreamReader((InputStream)new FileInputStream(in), Charset.defaultCharset());
        return IOUtils.read(r, 0, 1024);
    }

    public static String read(Object o) throws IOException {
        if (o instanceof CharSequence) {
            return o.toString();
        }
        if (o instanceof File) {
            return IOUtils.read((File)o);
        }
        if (o instanceof Reader) {
            return IOUtils.read((Reader)o);
        }
        if (o instanceof InputStream) {
            return IOUtils.read((InputStream)o);
        }
        if (o instanceof byte[]) {
            return IOUtils.read(new ByteArrayInputStream((byte[])o));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int write(File out, Reader in) throws IOException {
        ThrowableUtils.assertFieldNotNull(out, "out");
        ThrowableUtils.assertFieldNotNull(in, "in");
        OutputStreamWriter w = new OutputStreamWriter((OutputStream)new FileOutputStream(out), Charset.defaultCharset());
        try {
            int n = IOPipe.create(in, w).closeOut().run();
            return n;
        }
        finally {
            ((Writer)w).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int write(File out, InputStream in) throws IOException {
        ThrowableUtils.assertFieldNotNull(out, "out");
        ThrowableUtils.assertFieldNotNull(in, "in");
        FileOutputStream os = new FileOutputStream(out);
        try {
            int n = IOPipe.create(in, os).closeOut().run();
            return n;
        }
        finally {
            ((OutputStream)os).close();
        }
    }

    public static String read(Reader in) throws IOException {
        return IOUtils.read(in, 0, 1024);
    }

    public static String read(InputStream in, Charset cs) throws IOException {
        if (in == null) {
            return null;
        }
        return IOUtils.read(new InputStreamReader(in, cs));
    }

    public static String read(InputStream in) throws IOException {
        if (in == null) {
            return null;
        }
        return IOUtils.read(new InputStreamReader(in, Charset.defaultCharset()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static byte[] readBytes(InputStream in, int bufferSize) throws IOException {
        if (in == null) {
            return null;
        }
        ByteArrayOutputStream buff = new ByteArrayOutputStream(bufferSize);
        byte[] b = new byte[Math.min(bufferSize, 8192)];
        try {
            int nRead;
            while ((nRead = in.read(b, 0, b.length)) != -1) {
                buff.write(b, 0, nRead);
            }
            buff.flush();
            byte[] byArray = buff.toByteArray();
            return byArray;
        }
        finally {
            in.close();
        }
    }

    public static byte[] readBytes(File f) throws IOException {
        if (f == null || !f.exists() || !f.canRead()) {
            return null;
        }
        FileInputStream fis = new FileInputStream(f);
        try {
            byte[] byArray = IOUtils.readBytes(fis, (int)f.length());
            return byArray;
        }
        finally {
            fis.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String read(Reader in, int length, int bufferSize) throws IOException {
        if (in == null) {
            return null;
        }
        length = length <= 0 ? bufferSize : length;
        StringBuilder sb = new StringBuilder(length);
        try {
            char[] buf = new char[Math.min(bufferSize, length)];
            int i = 0;
            while ((i = in.read(buf)) != -1) {
                sb.append(buf, 0, i);
            }
            String string = sb.toString();
            return string;
        }
        finally {
            in.close();
        }
    }

    public static void pipe(Reader in, Writer out) throws IOException {
        ThrowableUtils.assertFieldNotNull(out, "out");
        ThrowableUtils.assertFieldNotNull(in, "in");
        IOPipe.create(in, out).run();
    }

    public static void pipe(Object in, Writer out) throws IOException {
        IOUtils.pipe(IOUtils.toReader(in), out);
    }

    public static void pipe(InputStream in, OutputStream out) throws IOException {
        ThrowableUtils.assertFieldNotNull(out, "out");
        ThrowableUtils.assertFieldNotNull(in, "in");
        IOPipe.create(in, out).run();
    }

    public static void pipe(Object in, OutputStream out) throws IOException {
        IOUtils.pipe(IOUtils.toInputStream(in), out);
    }

    public static Reader getBufferedReader(Reader r) {
        if (r == null || r instanceof BufferedReader || r instanceof StringReader) {
            return r;
        }
        return new BufferedReader(r);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long count(InputStream is) throws IOException {
        ThrowableUtils.assertFieldNotNull(is, "is");
        long c = 0L;
        try {
            long i;
            while ((i = is.skip(1024L)) != 0L) {
                c += i;
            }
        }
        finally {
            is.close();
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long count(Reader r) throws IOException {
        ThrowableUtils.assertFieldNotNull(r, "r");
        long c = 0L;
        try {
            long i;
            while ((i = r.skip(1024L)) != 0L) {
                c += i;
            }
        }
        finally {
            r.close();
        }
        return c;
    }

    public static int getBufferSize(String contentLength) {
        try {
            if (!StringUtils.isEmpty(contentLength)) {
                long l = Long.decode(contentLength);
                if (l > 0x100000L) {
                    return 0x100000;
                }
                if (l <= 0L) {
                    return 8192;
                }
                return (int)l;
            }
        }
        catch (Exception e) {
            return 8192;
        }
        return 8192;
    }

    public static void closeQuietly(InputStream is) {
        try {
            if (is != null) {
                is.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(OutputStream os) {
        try {
            if (os != null) {
                os.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Reader r) {
        try {
            if (r != null) {
                r.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Writer w) {
        try {
            if (w != null) {
                w.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void closeQuietly(Object ... o) {
        for (Object o2 : o) {
            if (o2 instanceof InputStream) {
                IOUtils.closeQuietly((InputStream)o2);
            }
            if (o2 instanceof OutputStream) {
                IOUtils.closeQuietly((OutputStream)o2);
            }
            if (o2 instanceof Reader) {
                IOUtils.closeQuietly((Reader)o2);
            }
            if (!(o2 instanceof Writer)) continue;
            IOUtils.closeQuietly((Writer)o2);
        }
    }

    public static void flush(Object ... o) throws IOException {
        IOException ex = null;
        for (Object o2 : o) {
            try {
                if (o2 instanceof OutputStream) {
                    ((OutputStream)o2).flush();
                }
                if (!(o2 instanceof Writer)) continue;
                ((Writer)o2).flush();
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static void close(Object ... o) throws IOException {
        IOException ex = null;
        for (Object o2 : o) {
            try {
                if (o2 instanceof InputStream) {
                    ((InputStream)o2).close();
                }
                if (o2 instanceof OutputStream) {
                    ((OutputStream)o2).close();
                }
                if (o2 instanceof Reader) {
                    ((Reader)o2).close();
                }
                if (!(o2 instanceof Writer)) continue;
                ((Writer)o2).close();
            }
            catch (IOException e) {
                ex = e;
            }
        }
        if (ex != null) {
            throw ex;
        }
    }

    public static Reader toReader(Object o) throws IOException {
        if (o == null) {
            return null;
        }
        if (o instanceof CharSequence) {
            return new StringReader(o.toString());
        }
        if (o instanceof File) {
            return new FileReader((File)o);
        }
        if (o instanceof Reader) {
            return (Reader)o;
        }
        if (o instanceof InputStream) {
            return new InputStreamReader((InputStream)o, "UTF-8");
        }
        if (o instanceof byte[]) {
            return new InputStreamReader((InputStream)new ByteArrayInputStream((byte[])o), "UTF-8");
        }
        throw new FormattedIllegalArgumentException("Invalid object of type {0} passed to IOUtils.toReader(Object)", o.getClass());
    }

    public static InputStream toInputStream(Object o) throws IOException {
        if (o == null) {
            return null;
        }
        if (o instanceof InputStream) {
            return (InputStream)o;
        }
        if (o instanceof File) {
            return new FileInputStream((File)o);
        }
        if (o instanceof byte[]) {
            return new ByteArrayInputStream((byte[])o);
        }
        if (o instanceof CharSequence) {
            return new ByteArrayInputStream(((CharSequence)o).toString().getBytes(UTF8));
        }
        if (o instanceof Reader) {
            return new ByteArrayInputStream(IOUtils.read((Reader)o).getBytes(UTF8));
        }
        throw new FormattedIllegalArgumentException("Invalid object of type {0} passed to IOUtils.toInputStream(Object)", o.getClass());
    }
}

