/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.GenericDeclaration;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanContext;
import org.apache.juneau.FormattedIllegalArgumentException;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectList;
import org.apache.juneau.Visibility;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.utils.AList;
import org.apache.juneau.utils.AMap;

public final class ClassUtils {
    private static final Map<Class<?>, Class<?>> pmap1 = new HashMap();
    private static final Map<Class<?>, Class<?>> pmap2 = new HashMap();
    private static Comparator<Method> METHOD_COMPARATOR;
    private static Comparator<Field> FIELD_COMPARATOR;
    private static final Map<Class<?>, Object> primitiveDefaultMap;

    public static ObjectList getReadableClassNames(Object[] o) {
        ObjectList l = new ObjectList();
        for (int i = 0; i < o.length; ++i) {
            l.add(o[i] == null ? "null" : ClassUtils.getReadableClassName(o[i].getClass()));
        }
        return l;
    }

    public static String getReadableClassName(Class<?> c) {
        if (c == null) {
            return null;
        }
        return ClassUtils.getReadableClassName(c.getName());
    }

    public static String getReadableClassNameForObject(Object o) {
        if (o == null) {
            return null;
        }
        return ClassUtils.getReadableClassName(o.getClass().getName());
    }

    public static String getReadableClassName(String className) {
        String c;
        if (className == null) {
            return null;
        }
        if (!StringUtils.startsWith(className, '[')) {
            return className;
        }
        int depth = 0;
        for (int i = 0; i < className.length() && className.charAt(i) == '['; ++i) {
            ++depth;
        }
        char type = className.charAt(depth);
        switch (type) {
            case 'Z': {
                c = "boolean";
                break;
            }
            case 'B': {
                c = "byte";
                break;
            }
            case 'C': {
                c = "char";
                break;
            }
            case 'D': {
                c = "double";
                break;
            }
            case 'F': {
                c = "float";
                break;
            }
            case 'I': {
                c = "int";
                break;
            }
            case 'J': {
                c = "long";
                break;
            }
            case 'S': {
                c = "short";
                break;
            }
            default: {
                c = className.substring(depth + 1, className.length() - 1);
            }
        }
        StringBuilder sb = new StringBuilder(c.length() + 2 * depth).append(c);
        for (int i = 0; i < depth; ++i) {
            sb.append("[]");
        }
        return sb.toString();
    }

    public static Class<?> getClassFromReadableName(ClassLoader cl, String name) throws ClassNotFoundException {
        return cl.loadClass(name);
    }

    public static boolean isParentClass(Class<?> parent, Class<?> child, boolean strict) {
        return parent.isAssignableFrom(child) && (!strict || !parent.equals(child));
    }

    public static boolean isParentClass(Class<?> parent, Class<?> child) {
        return ClassUtils.isParentClass(parent, child, false);
    }

    public static boolean isParentClass(Class<?> parent, Type child) {
        if (child instanceof Class) {
            return ClassUtils.isParentClass(parent, (Class)child);
        }
        return false;
    }

    public static String getMethodSignature(Method m) {
        StringBuilder sb = new StringBuilder(m.getName());
        Class<?>[] pt = m.getParameterTypes();
        if (pt.length > 0) {
            sb.append('(');
            for (int i = 0; i < pt.length; ++i) {
                if (i > 0) {
                    sb.append(',');
                }
                sb.append(ClassUtils.getReadableClassName(pt[i]));
            }
            sb.append(')');
        }
        return sb.toString();
    }

    public static Class<?> getPrimitiveWrapper(Class<?> c) {
        return pmap1.get(c);
    }

    public static Class<?> getPrimitiveForWrapper(Class<?> c) {
        return pmap2.get(c);
    }

    public static Class<?> getWrapperIfPrimitive(Class<?> c) {
        if (!c.isPrimitive()) {
            return c;
        }
        return pmap1.get(c);
    }

    public static boolean isNotDeprecated(Class<?> c) {
        return !c.isAnnotationPresent(Deprecated.class);
    }

    public static boolean isNotDeprecated(Method m) {
        return !m.isAnnotationPresent(Deprecated.class);
    }

    public static boolean isNotDeprecated(Constructor<?> c) {
        return !c.isAnnotationPresent(Deprecated.class);
    }

    public static boolean isPublic(Class<?> c) {
        return Modifier.isPublic(c.getModifiers());
    }

    public static boolean isStatic(Class<?> c) {
        return Modifier.isStatic(c.getModifiers());
    }

    public static boolean isAbstract(Class<?> c) {
        return Modifier.isAbstract(c.getModifiers());
    }

    public static boolean isPublic(Method m) {
        return Modifier.isPublic(m.getModifiers());
    }

    public static boolean isStatic(Method m) {
        return Modifier.isStatic(m.getModifiers());
    }

    public static boolean isPublic(Constructor<?> c) {
        return Modifier.isPublic(c.getModifiers());
    }

    public static <T extends Annotation> T getMethodAnnotation(Class<T> a, Method m) {
        return ClassUtils.getMethodAnnotation(a, m.getDeclaringClass(), m);
    }

    public static <T extends Annotation> T getMethodAnnotation(Class<T> a, Class<?> c, Method method) {
        T t;
        for (Method m : c.getDeclaredMethods()) {
            T t2;
            if (!ClassUtils.isSameMethod(method, m) || (t2 = m.getAnnotation(a)) == null) continue;
            return t2;
        }
        Class<?> pc = c.getSuperclass();
        if (pc != null && (t = ClassUtils.getMethodAnnotation(a, pc, method)) != null) {
            return t;
        }
        for (Class<?> ic : c.getInterfaces()) {
            T t3 = ClassUtils.getMethodAnnotation(a, ic, method);
            if (t3 == null) continue;
            return t3;
        }
        return null;
    }

    private static boolean isSameMethod(Method m1, Method m2) {
        return m1.getName().equals(m2.getName()) && Arrays.equals(m1.getParameterTypes(), m2.getParameterTypes());
    }

    public static final <T> Constructor<T> findNoArgConstructor(Class<T> c, Visibility v) {
        int mod = c.getModifiers();
        if (Modifier.isAbstract(mod)) {
            return null;
        }
        boolean isMemberClass = c.isMemberClass() && !ClassUtils.isStatic(c);
        for (Constructor<?> cc : c.getConstructors()) {
            mod = cc.getModifiers();
            if (cc.getParameterTypes().length != (isMemberClass ? 1 : 0) || !v.isVisible(mod) || !ClassUtils.isNotDeprecated(cc)) continue;
            return v.transform(cc);
        }
        return null;
    }

    public static Class<?> resolveParameterType(Class<?> c, int index, Class<?> oc) {
        HashMap<Type, Type> typeMap = new HashMap<Type, Type>();
        while (c != oc.getSuperclass()) {
            ClassUtils.extractTypes(typeMap, oc);
            oc = oc.getSuperclass();
        }
        Type gsc = oc.getGenericSuperclass();
        if (!(gsc instanceof ParameterizedType)) {
            return Object.class;
        }
        ParameterizedType opt = (ParameterizedType)gsc;
        Type actualType = opt.getActualTypeArguments()[index];
        if (typeMap.containsKey(actualType)) {
            actualType = (Type)typeMap.get(actualType);
        }
        if (actualType instanceof Class) {
            return (Class)actualType;
        }
        if (actualType instanceof GenericArrayType) {
            Class cmpntType = (Class)((GenericArrayType)actualType).getGenericComponentType();
            return Array.newInstance(cmpntType, 0).getClass();
        }
        if (actualType instanceof TypeVariable) {
            TypeVariable typeVariable = (TypeVariable)actualType;
            LinkedList nestedOuterTypes = new LinkedList();
            for (Class<?> ec = oc.getEnclosingClass(); ec != null; ec = ec.getEnclosingClass()) {
                try {
                    Class<?> outerClass = oc.getClass();
                    nestedOuterTypes.add(outerClass);
                    HashMap<Type, Type> outerTypeMap = new HashMap<Type, Type>();
                    ClassUtils.extractTypes(outerTypeMap, outerClass);
                    for (Map.Entry entry : outerTypeMap.entrySet()) {
                        TypeVariable keyType;
                        Type key = (Type)entry.getKey();
                        Type value = (Type)entry.getValue();
                        if (!(key instanceof TypeVariable) || !(keyType = (TypeVariable)key).getName().equals(typeVariable.getName()) || !ClassUtils.isInnerClass(keyType.getGenericDeclaration(), typeVariable.getGenericDeclaration())) continue;
                        if (value instanceof Class) {
                            return (Class)value;
                        }
                        typeVariable = (TypeVariable)entry.getValue();
                    }
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            throw new FormattedRuntimeException("Could not resolve type: {0}", actualType);
        }
        throw new FormattedRuntimeException("Invalid type found in resolveParameterType: {0}", actualType);
    }

    private static boolean isInnerClass(GenericDeclaration od, GenericDeclaration id) {
        if (od instanceof Class && id instanceof Class) {
            Class oc = (Class)od;
            Class<?> ic = (Class<?>)id;
            while ((ic = ic.getEnclosingClass()) != null) {
                if (ic != oc) continue;
                return true;
            }
        }
        return false;
    }

    private static void extractTypes(Map<Type, Type> typeMap, Class<?> c) {
        Type gs = c.getGenericSuperclass();
        if (gs instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)gs;
            TypeVariable<Class<T>>[] typeParameters = ((Class)pt.getRawType()).getTypeParameters();
            Type[] actualTypeArguments = pt.getActualTypeArguments();
            for (int i = 0; i < typeParameters.length; ++i) {
                if (typeMap.containsKey(actualTypeArguments[i])) {
                    actualTypeArguments[i] = typeMap.get(actualTypeArguments[i]);
                }
                typeMap.put(typeParameters[i], actualTypeArguments[i]);
            }
        }
    }

    public static Method findPublicMethod(Class<?> c, String name, Class<?> returnType, Class<?> ... parameterTypes) {
        for (Method m : c.getMethods()) {
            Class<?>[] pt;
            Class<?> rt;
            if (!ClassUtils.isPublic(m) || !m.getName().equals(name) || !ClassUtils.isParentClass(returnType, rt = m.getReturnType()) || (pt = m.getParameterTypes()).length != parameterTypes.length) continue;
            boolean matches = true;
            for (int i = 0; i < pt.length; ++i) {
                if (ClassUtils.isParentClass(pt[i], parameterTypes[i])) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return m;
        }
        return null;
    }

    public static <T> Constructor<T> findPublicConstructor(Class<T> c, Class<?> ... parameterTypes) {
        for (Constructor<?> n : c.getConstructors()) {
            Class<?>[] pt;
            if (!ClassUtils.isPublic(n) || (pt = n.getParameterTypes()).length != parameterTypes.length) continue;
            boolean matches = true;
            for (int i = 0; i < pt.length; ++i) {
                if (ClassUtils.isParentClass(pt[i], parameterTypes[i])) continue;
                matches = false;
                break;
            }
            if (!matches) continue;
            return n;
        }
        return null;
    }

    public static <T> Constructor<T> findPublicConstructor(Class<T> c, Object ... args) {
        return ClassUtils.findPublicConstructor(c, ClassUtils.getClasses(args));
    }

    public static Class<?>[] getClasses(Object ... args) {
        Class[] pt = new Class[args.length];
        for (int i = 0; i < args.length; ++i) {
            pt[i] = args[i] == null ? null : args[i].getClass();
        }
        return pt;
    }

    public static MethodInfo getMethodInfo(Method m) {
        return new MethodInfo(m);
    }

    public static MethodInfo[] getMethodInfo(Collection<Method> m) {
        MethodInfo[] mi = new MethodInfo[m.size()];
        int i = 0;
        for (Method mm : m) {
            mi[i++] = ClassUtils.getMethodInfo(mm);
        }
        return mi;
    }

    public static <T> T newInstance(Class<T> c, Object c2, Object ... args) {
        return ClassUtils.newInstanceFromOuter(null, c, c2, args);
    }

    public static <T> T newInstanceFromOuter(Object outer, Class<T> c, Object c2, Object ... args) {
        if (c2 == null) {
            return null;
        }
        if (c2 instanceof Class) {
            try {
                Object[] args2;
                Class c3 = (Class)c2;
                if (c3.isInterface() || ClassUtils.isAbstract(c3)) {
                    return null;
                }
                Constructor<T> con = ClassUtils.findPublicConstructor(c3, args);
                if (con != null) {
                    return con.newInstance(args);
                }
                if (outer != null && (con = ClassUtils.findPublicConstructor(c3, args2 = new AList<Object>().append(outer).appendAll((Object[])args).toArray())) != null) {
                    return con.newInstance(args2);
                }
                return c3.getConstructor(ClassUtils.getClasses(args)).newInstance(args);
            }
            catch (Exception e) {
                throw new FormattedRuntimeException(e, "Could not instantiate class {0}", c.getName());
            }
        }
        if (ClassUtils.isParentClass(c, c2.getClass())) {
            return (T)c2;
        }
        throw new FormattedRuntimeException("Object of type {0} found but was expecting {1}.", c2.getClass(), c.getClass());
    }

    public static Iterable<Field> getAllFields(final Class c, final boolean parentFirst) {
        return new Iterable<Field>(){

            @Override
            public Iterator<Field> iterator() {
                return new Iterator<Field>(){
                    final Iterator<Class<?>> classIterator;
                    Field[] fields;
                    int fIndex;
                    Field next;
                    {
                        this.classIterator = ClassUtils.getParentClasses(c, parentFirst, false);
                        this.fields = this.classIterator.hasNext() ? ClassUtils.sort(this.classIterator.next().getDeclaredFields()) : new Field[]{};
                        this.fIndex = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        this.prime();
                        return this.next != null;
                    }

                    private void prime() {
                        if (this.next == null) {
                            while (this.fIndex >= this.fields.length) {
                                if (this.classIterator.hasNext()) {
                                    this.fields = ClassUtils.sort(this.classIterator.next().getDeclaredFields());
                                    this.fIndex = 0;
                                    continue;
                                }
                                this.fIndex = -1;
                            }
                            if (this.fIndex != -1) {
                                this.next = this.fields[this.fIndex++];
                            }
                        }
                    }

                    @Override
                    public Field next() {
                        this.prime();
                        Field f = this.next;
                        this.next = null;
                        return f;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    public static Iterable<Method> getAllMethods(final Class c, final boolean parentFirst) {
        return new Iterable<Method>(){

            @Override
            public Iterator<Method> iterator() {
                return new Iterator<Method>(){
                    final Iterator<Class<?>> classIterator;
                    Method[] methods;
                    int mIndex;
                    Method next;
                    {
                        this.classIterator = ClassUtils.getParentClasses(c, parentFirst, true);
                        this.methods = this.classIterator.hasNext() ? ClassUtils.sort(this.classIterator.next().getDeclaredMethods()) : new Method[]{};
                        this.mIndex = 0;
                    }

                    @Override
                    public boolean hasNext() {
                        this.prime();
                        return this.next != null;
                    }

                    private void prime() {
                        if (this.next == null) {
                            while (this.mIndex >= this.methods.length) {
                                if (this.classIterator.hasNext()) {
                                    this.methods = ClassUtils.sort(this.classIterator.next().getDeclaredMethods());
                                    this.mIndex = 0;
                                    continue;
                                }
                                this.mIndex = -1;
                            }
                            if (this.mIndex != -1) {
                                this.next = this.methods[this.mIndex++];
                            }
                        }
                    }

                    @Override
                    public Method next() {
                        this.prime();
                        Method m = this.next;
                        this.next = null;
                        return m;
                    }

                    @Override
                    public void remove() {
                    }
                };
            }
        };
    }

    public static Method[] sort(Method[] m) {
        Arrays.sort(m, METHOD_COMPARATOR);
        return m;
    }

    public static Field[] sort(Field[] m) {
        Arrays.sort(m, FIELD_COMPARATOR);
        return m;
    }

    public static Iterator<Class<?>> getParentClasses(Class<?> c, boolean parentFirst, boolean includeInterfaces) {
        List<Class<?>> l = ClassUtils.getParentClasses(new ArrayList(), c, parentFirst, includeInterfaces);
        return l.iterator();
    }

    private static List<Class<?>> getParentClasses(List<Class<?>> l, Class<?> c, boolean parentFirst, boolean includeInterfaces) {
        if (parentFirst) {
            if (includeInterfaces) {
                for (Class<?> i : c.getInterfaces()) {
                    l.add(i);
                }
            }
            if (c.getSuperclass() != Object.class && c.getSuperclass() != null) {
                ClassUtils.getParentClasses(l, c.getSuperclass(), parentFirst, includeInterfaces);
            }
            l.add(c);
        } else {
            l.add(c);
            if (c.getSuperclass() != Object.class && c.getSuperclass() != null) {
                ClassUtils.getParentClasses(l, c.getSuperclass(), parentFirst, includeInterfaces);
            }
            if (includeInterfaces) {
                for (Class<?> i : c.getInterfaces()) {
                    l.add(i);
                }
            }
        }
        return l;
    }

    public static Object getPrimitiveDefault(Class<?> primitiveClass) {
        return primitiveDefaultMap.get(primitiveClass);
    }

    public static String toString(Method m) {
        StringBuilder sb = new StringBuilder(m.getDeclaringClass().getName() + "." + m.getName() + "(");
        for (int i = 0; i < m.getParameterTypes().length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(m.getParameterTypes()[i].getSimpleName());
        }
        sb.append(")");
        return sb.toString();
    }

    public static String toString(Field f) {
        return f.getDeclaringClass().getName() + "." + f.getName();
    }

    public static void assertArgsOfType(Method m, Class<?> ... args) throws FormattedIllegalArgumentException {
        for (Class<?> c1 : m.getParameterTypes()) {
            boolean foundMatch = false;
            for (Class<?> c2 : args) {
                if (c1 != c2) continue;
                foundMatch = true;
            }
            if (foundMatch) continue;
            throw new FormattedIllegalArgumentException("Invalid argument of type {0} passed in method {1}.  Only arguments of type {2} are allowed.", c1, m, args);
        }
    }

    static {
        pmap1.put(Boolean.TYPE, Boolean.class);
        pmap1.put(Byte.TYPE, Byte.class);
        pmap1.put(Short.TYPE, Short.class);
        pmap1.put(Character.TYPE, Character.class);
        pmap1.put(Integer.TYPE, Integer.class);
        pmap1.put(Long.TYPE, Long.class);
        pmap1.put(Float.TYPE, Float.class);
        pmap1.put(Double.TYPE, Double.class);
        pmap2.put(Boolean.class, Boolean.TYPE);
        pmap2.put(Byte.class, Byte.TYPE);
        pmap2.put(Short.class, Short.TYPE);
        pmap2.put(Character.class, Character.TYPE);
        pmap2.put(Integer.class, Integer.TYPE);
        pmap2.put(Long.class, Long.TYPE);
        pmap2.put(Float.class, Float.TYPE);
        pmap2.put(Double.class, Double.TYPE);
        METHOD_COMPARATOR = new Comparator<Method>(){

            @Override
            public int compare(Method o1, Method o2) {
                int i = o1.getName().compareTo(o2.getName());
                if (i == 0 && (i = o1.getParameterTypes().length - o2.getParameterTypes().length) == 0) {
                    for (int j = 0; j < o1.getParameterTypes().length && i == 0; ++j) {
                        i = o1.getParameterTypes()[j].getName().compareTo(o2.getParameterTypes()[j].getName());
                    }
                }
                return i;
            }
        };
        FIELD_COMPARATOR = new Comparator<Field>(){

            @Override
            public int compare(Field o1, Field o2) {
                return o1.getName().compareTo(o2.getName());
            }
        };
        primitiveDefaultMap = Collections.unmodifiableMap(new AMap<Class<Boolean>, Boolean>().append(Boolean.TYPE, false).append(Character.TYPE, (Boolean)((Object)Character.valueOf('\u0000'))).append(Short.TYPE, (Boolean)((Object)Short.valueOf((short)0))).append(Integer.TYPE, (Boolean)((Object)Integer.valueOf(0))).append(Long.TYPE, (Boolean)((Object)Long.valueOf(0L))).append(Float.TYPE, (Boolean)((Object)Float.valueOf(0.0f))).append(Double.TYPE, (Boolean)((Object)Double.valueOf(0.0))).append(Byte.TYPE, (Boolean)((Object)Byte.valueOf((byte)0))).append(Boolean.class, false).append(Character.class, (Boolean)((Object)Character.valueOf('\u0000'))).append(Short.class, (Boolean)((Object)Short.valueOf((short)0))).append(Integer.class, (Boolean)((Object)Integer.valueOf(0))).append(Long.class, (Boolean)((Object)Long.valueOf(0L))).append(Float.class, (Boolean)((Object)Float.valueOf(0.0f))).append(Double.class, (Boolean)((Object)Double.valueOf(0.0))).append(Byte.class, (Boolean)((Object)Byte.valueOf((byte)0))));
    }

    public static class MethodInfo {
        public final String methodName;
        public final String[] parameterTypes;
        public final String returnType;

        MethodInfo(Method m) {
            this.methodName = m.getName();
            Type[] pt = m.getGenericParameterTypes();
            this.parameterTypes = new String[pt.length];
            for (int i = 0; i < pt.length; ++i) {
                this.parameterTypes[i] = BeanContext.DEFAULT.getClassMeta(pt[i], new Type[0]).toString();
            }
            this.returnType = BeanContext.DEFAULT.getClassMeta(m.getGenericReturnType(), new Type[0]).toString();
        }
    }

    public static final class ClassComparator
    implements Comparator<Class<?>>,
    Serializable {
        private static final long serialVersionUID = 1L;

        @Override
        public int compare(Class<?> object1, Class<?> object2) {
            return object1.getName().compareTo(object2.getName());
        }
    }
}

