/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.encoders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.juneau.encoders.Encoder;
import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.CollectionUtils;

public class EncoderGroupBuilder {
    private final List<Encoder> encoders = new ArrayList<Encoder>();

    public EncoderGroupBuilder() {
    }

    public EncoderGroupBuilder(EncoderGroup copyFrom) {
        CollectionUtils.addReverse(this.encoders, copyFrom.getEncoders());
    }

    public EncoderGroupBuilder append(Class<?> ... e) {
        for (int i = e.length - 1; i >= 0; --i) {
            this.encoders.add(ClassUtils.newInstance(Encoder.class, e[i], new Object[0]));
        }
        return this;
    }

    public EncoderGroupBuilder append(Encoder ... e) {
        CollectionUtils.addReverse(this.encoders, e);
        return this;
    }

    public EncoderGroupBuilder append(List<Encoder> e) {
        CollectionUtils.addReverse(this.encoders, e);
        return this;
    }

    public EncoderGroupBuilder append(EncoderGroup eg) {
        this.append(eg.getEncoders());
        return this;
    }

    public EncoderGroup build() {
        ArrayList<Encoder> l = new ArrayList<Encoder>();
        for (Encoder e : this.encoders) {
            l.add(ClassUtils.newInstance(Encoder.class, e, new Object[0]));
        }
        Collections.reverse(l);
        return new EncoderGroup(l.toArray(new Encoder[l.size()]));
    }
}

