/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.resources;

import java.io.FileWriter;
import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.microservice.Resource;
import org.apache.juneau.microservice.RestMicroservice;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.annotation.HtmlDoc;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.labels.ResourceDescription;

@RestResource(path="/debug", title="Debug", description="Debug Utilities.", htmldoc=@HtmlDoc(links={"up: request:/..", "jetty-thread-dump: servlet:/jetty/dump?method=POST", "options: servlet:/?method=OPTIONS"}), allowMethodParam="OPTIONS,POST")
public class DebugResource
extends Resource {
    private static final long serialVersionUID = 1L;

    @RestMethod(name="GET", path="/", description="Show contents of config file.")
    public ResourceDescription[] getChildren() throws Exception {
        return new ResourceDescription[]{new ResourceDescription("jetty/dump", "Jetty thread dump")};
    }

    @RestMethod(name="GET", path="/jetty/dump", description="Generates and retrieves the jetty thread dump.")
    public Reader getJettyDump(RestRequest req, RestResponse res) {
        res.setContentType("text/plain");
        return new StringReader(RestMicroservice.getInstance().getServer().dump());
    }

    @RestMethod(name="POST", path="/jetty/dump", description="Generates and saves the jetty thread dump file to jetty-thread-dump.log.")
    public String createJettyDump(RestRequest req, RestResponse res) throws Exception {
        String dump = RestMicroservice.getInstance().getServer().dump();
        IOUtils.pipe((Object)dump, (Writer)new FileWriter(req.getConfigFile().getString("Logging/logDir") + "/jetty-thread-dump.log"));
        return "OK";
    }
}

