/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.juneau.internal.SystemUtils;
import org.eclipse.jetty.util.log.AbstractLogger;

public class JettyLogger
extends AbstractLogger {
    private static final boolean SHOW_SOURCE = SystemUtils.getFirstBoolean((Boolean)true, (String[])new String[]{"org.eclipse.jetty.util.log.SOURCE", "org.eclipse.jetty.util.log.javautil.SOURCE"});
    private Level configuredLevel;
    private Logger logger;

    public JettyLogger() {
        this("org.eclipse.jetty.util.log.javautil");
    }

    public JettyLogger(String name) {
        this.logger = Logger.getLogger(name);
        this.configuredLevel = this.logger.getLevel();
    }

    public String getName() {
        return this.logger.getName();
    }

    public void warn(String msg, Object ... args) {
        if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, JettyLogger.format(msg, args), null);
        }
    }

    public void warn(Throwable thrown) {
        if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, "", thrown);
        }
    }

    public void warn(String msg, Throwable thrown) {
        if (this.isLoggable(Level.WARNING)) {
            this.log(Level.WARNING, msg, thrown);
        }
    }

    public void info(String msg, Object ... args) {
        if (this.isLoggable(Level.INFO)) {
            this.log(Level.INFO, JettyLogger.format(msg, args), null);
        }
    }

    public void info(Throwable thrown) {
        if (this.isLoggable(Level.INFO)) {
            this.log(Level.INFO, "", thrown);
        }
    }

    public void info(String msg, Throwable thrown) {
        if (this.isLoggable(Level.INFO)) {
            this.log(Level.INFO, msg, thrown);
        }
    }

    public boolean isDebugEnabled() {
        return this.isLoggable(Level.FINE);
    }

    public void setDebugEnabled(boolean enabled) {
        if (enabled) {
            this.configuredLevel = this.logger.getLevel();
            this.logger.setLevel(Level.FINE);
        } else {
            this.logger.setLevel(this.configuredLevel);
        }
    }

    public void debug(String msg, Object ... args) {
        if (this.isLoggable(Level.FINE)) {
            this.log(Level.FINE, JettyLogger.format(msg, args), null);
        }
    }

    public void debug(String msg, long arg) {
        if (this.isLoggable(Level.FINE)) {
            this.log(Level.FINE, JettyLogger.format(msg, arg), null);
        }
    }

    public void debug(Throwable thrown) {
        if (this.isLoggable(Level.FINE)) {
            this.log(Level.FINE, "", thrown);
        }
    }

    public void debug(String msg, Throwable thrown) {
        if (this.isLoggable(Level.FINE)) {
            this.log(Level.FINE, msg, thrown);
        }
    }

    protected org.eclipse.jetty.util.log.Logger newLogger(String fullname) {
        return new JettyLogger(fullname);
    }

    public void ignore(Throwable ignored) {
        if (this.isLoggable(Level.FINEST)) {
            this.log(Level.FINEST, "IGNORED EXCEPTION ", ignored);
        }
    }

    private static String format(String msg, Object ... args) {
        msg = String.valueOf(msg);
        if (args.length == 0) {
            return msg;
        }
        StringBuilder sb = new StringBuilder();
        int start = 0;
        for (Object arg : args) {
            int bi = msg.indexOf("{}", start);
            if (bi < 0) {
                sb.append(msg.substring(start)).append(" ").append(arg);
                start = msg.length();
                continue;
            }
            sb.append(msg.substring(start, bi)).append(String.valueOf(arg));
            start = bi + 2;
        }
        sb.append(msg.substring(start));
        return sb.toString();
    }

    private void log(Level level, String msg, Throwable thrown) {
        LogRecord r = new LogRecord(level, msg);
        if (thrown != null) {
            r.setThrown(thrown);
        }
        r.setLoggerName(this.logger.getName());
        if (SHOW_SOURCE) {
            StackTraceElement[] stack = new Throwable().getStackTrace();
            for (int i = 0; i < stack.length; ++i) {
                StackTraceElement e = stack[i];
                if (e.getClassName().equals(((Object)((Object)this)).getClass().getName())) continue;
                r.setSourceClassName(e.getClassName());
                r.setSourceMethodName(e.getMethodName());
                break;
            }
        }
        this.logger.log(r);
    }

    private boolean isLoggable(Level level) {
        return this.logger.isLoggable(level);
    }
}

