/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.ini;

import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.Writable;
import org.apache.juneau.ini.ConfigFileFormat;
import org.apache.juneau.ini.ConfigFileListener;
import org.apache.juneau.ini.ConfigUtils;
import org.apache.juneau.ini.Section;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverSession;

public abstract class ConfigFile
implements Map<String, Section> {
    public abstract String get(String var1, String var2);

    public abstract String put(String var1, String var2, Object var3, Serializer var4, boolean var5, boolean var6) throws SerializeException;

    public abstract String put(String var1, String var2, String var3, boolean var4);

    public abstract String remove(String var1, String var2);

    public abstract Set<String> getSectionKeys(String var1);

    public abstract ConfigFile loadIfModified() throws IOException;

    public abstract ConfigFile load() throws IOException;

    public abstract ConfigFile load(Reader var1) throws IOException;

    public abstract ConfigFile addLines(String var1, String ... var2);

    public abstract ConfigFile addHeaderComments(String var1, String ... var2);

    public abstract ConfigFile clearHeaderComments(String var1);

    protected abstract BeanSession getBeanSession();

    protected abstract String serialize(Object var1, Serializer var2, boolean var3) throws SerializeException;

    protected abstract <T> T parse(String var1, Parser var2, Type var3, Type ... var4) throws ParseException;

    protected abstract void readLock();

    protected abstract void readUnlock();

    public final String getString(String key, String def) {
        ThrowableUtils.assertFieldNotNull((Object)key, (String)"key");
        String s = this.get(ConfigUtils.getSectionName(key), ConfigUtils.getSectionKey(key));
        return StringUtils.isEmpty((String)s) && def != null ? def : s;
    }

    public final String removeString(String key) {
        ThrowableUtils.assertFieldNotNull((Object)key, (String)"key");
        return this.remove(ConfigUtils.getSectionName(key), ConfigUtils.getSectionKey(key));
    }

    public final <T> T getObject(String key, Type type, Type ... args) throws ParseException {
        return this.getObject(key, (Parser)null, type, args);
    }

    public final <T> T getObject(String key, Parser parser, Type type, Type ... args) throws ParseException {
        ThrowableUtils.assertFieldNotNull((Object)key, (String)"key");
        ThrowableUtils.assertFieldNotNull((Object)type, (String)"type");
        return this.parse(this.getString(key), parser, type, args);
    }

    public final <T> T getObject(String key, Class<T> type) throws ParseException {
        return this.getObject(key, (Parser)null, type);
    }

    public final <T> T getObject(String key, Parser parser, Class<T> type) throws ParseException {
        ThrowableUtils.assertFieldNotNull((Object)key, (String)"key");
        ThrowableUtils.assertFieldNotNull(type, (String)"c");
        return this.parse(this.getString(key), parser, type, new Type[0]);
    }

    public final <T> T getObjectWithDefault(String key, T def, Class<T> type) throws ParseException {
        return this.getObjectWithDefault(key, null, def, type);
    }

    public final <T> T getObjectWithDefault(String key, Parser parser, T def, Class<T> type) throws ParseException {
        ThrowableUtils.assertFieldNotNull((Object)key, (String)"key");
        ThrowableUtils.assertFieldNotNull(type, (String)"c");
        T t = this.parse(this.getString(key), parser, type, new Type[0]);
        return t == null ? def : t;
    }

    public final <T> T getObjectWithDefault(String key, T def, Type type, Type ... args) throws ParseException {
        return this.getObjectWithDefault(key, null, def, type, args);
    }

    public final <T> T getObjectWithDefault(String key, Parser parser, T def, Type type, Type ... args) throws ParseException {
        ThrowableUtils.assertFieldNotNull((Object)key, (String)"key");
        ThrowableUtils.assertFieldNotNull((Object)type, (String)"type");
        T t = this.parse(this.getString(key), parser, type, args);
        return t == null ? def : t;
    }

    public final <T> T getObject(String sectionName, String sectionKey, Class<T> c) throws ParseException {
        return this.getObject(sectionName, sectionKey, null, c);
    }

    public final <T> T getObject(String sectionName, String sectionKey, Parser parser, Class<T> c) throws ParseException {
        ThrowableUtils.assertFieldNotNull((Object)sectionName, (String)"sectionName");
        ThrowableUtils.assertFieldNotNull((Object)sectionKey, (String)"sectionKey");
        return this.parse(this.get(sectionName, sectionKey), parser, c, new Type[0]);
    }

    public final <T> T getObject(String sectionName, String sectionKey, Type type, Type ... args) throws ParseException {
        return this.getObject(sectionName, sectionKey, (Parser)null, type, args);
    }

    public final <T> T getObject(String sectionName, String sectionKey, Parser parser, Type type, Type ... args) throws ParseException {
        ThrowableUtils.assertFieldNotNull((Object)sectionName, (String)"sectionName");
        ThrowableUtils.assertFieldNotNull((Object)sectionKey, (String)"sectionKey");
        return this.parse(this.get(sectionName, sectionKey), parser, type, args);
    }

    public final String getString(String key) {
        return this.getString(key, null);
    }

    public final String[] getStringArray(String key) {
        return this.getStringArray(key, new String[0]);
    }

    public final String[] getStringArray(String key, String[] def) {
        String s = this.getString(key);
        if (s == null) {
            return def;
        }
        String[] r = StringUtils.isEmpty((String)s) ? new String[]{} : StringUtils.split((String)s);
        return r.length == 0 ? def : r;
    }

    public final int getInt(String key) {
        return this.getInt(key, 0);
    }

    public final int getInt(String key, int def) {
        String s = this.getString(key);
        if (StringUtils.isEmpty((String)s)) {
            return def;
        }
        return ConfigFile.parseIntWithSuffix(s);
    }

    public final boolean getBoolean(String key) {
        return this.getBoolean(key, false);
    }

    public final boolean getBoolean(String key, boolean def) {
        String s = this.getString(key);
        return StringUtils.isEmpty((String)s) ? def : Boolean.parseBoolean(s);
    }

    @Override
    public final String put(String key, Object value) throws SerializeException {
        return this.put(key, value, null, this.isEncoded(key), false);
    }

    public final String put(String key, Object value, Serializer serializer) throws SerializeException {
        return this.put(key, value, serializer, this.isEncoded(key), false);
    }

    public final String put(String key, Object value, boolean encoded) throws SerializeException {
        return this.put(key, value, null, encoded, false);
    }

    public final String put(String key, Object value, Serializer serializer, boolean encoded, boolean newline) throws SerializeException {
        ThrowableUtils.assertFieldNotNull((Object)key, (String)"key");
        return this.put(ConfigUtils.getSectionName(key), ConfigUtils.getSectionKey(key), this.serialize(value, serializer, newline), encoded);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectMap getSectionMap(String sectionName) {
        this.readLock();
        try {
            Set<String> keys = this.getSectionKeys(sectionName);
            if (keys == null) {
                ObjectMap objectMap = null;
                return objectMap;
            }
            ObjectMap m = new ObjectMap();
            for (String key : keys) {
                m.put((Object)key, (Object)this.get(sectionName, key));
            }
            ObjectMap objectMap = m;
            return objectMap;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final ObjectMap writeProperties(String sectionName, Object bean, boolean ignoreUnknownProperties, Class<?> ... permittedPropertyTypes) throws ParseException, IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        ThrowableUtils.assertFieldNotNull((Object)bean, (String)"bean");
        ObjectMap om = new ObjectMap();
        this.readLock();
        try {
            Set<String> keys = this.getSectionKeys(sectionName);
            if (keys == null) {
                throw new IllegalArgumentException("Section not found");
            }
            keys = new LinkedHashSet<String>(keys);
            for (Method m : bean.getClass().getMethods()) {
                String propName;
                Object value;
                int mod = m.getModifiers();
                if (!Modifier.isPublic(mod) || Modifier.isStatic(mod) || !m.getName().startsWith("set") || m.getParameterTypes().length != 1) continue;
                Class<?> pt = m.getParameterTypes()[0];
                if (permittedPropertyTypes != null && permittedPropertyTypes.length != 0 && !ArrayUtils.contains(pt, (Object[])permittedPropertyTypes) || (value = this.getObject(sectionName, propName = Introspector.decapitalize(m.getName().substring(3)), pt)) == null) continue;
                m.invoke(bean, value);
                om.put((Object)propName, value);
                keys.remove(propName);
            }
            if (!ignoreUnknownProperties && !keys.isEmpty()) {
                throw new ParseException("Invalid properties found in config file section ''{0}'': {1}", new Object[]{sectionName, keys});
            }
            ObjectMap objectMap = om;
            return objectMap;
        }
        finally {
            this.readUnlock();
        }
    }

    public final <T> T getSectionAsBean(String sectionName, Class<T> c) throws ParseException {
        return this.getSectionAsBean(sectionName, c, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final <T> T getSectionAsBean(String sectionName, Class<T> c, boolean ignoreUnknownProperties) throws ParseException {
        ThrowableUtils.assertFieldNotNull(c, (String)"c");
        this.readLock();
        try {
            BeanMap bm = this.getBeanSession().newBeanMap(c);
            for (String k : this.getSectionKeys(sectionName)) {
                BeanPropertyMeta bpm = bm.getPropertyMeta(k);
                if (bpm == null) {
                    if (ignoreUnknownProperties) continue;
                    throw new ParseException("Unknown property {0} encountered", new Object[]{k});
                }
                bm.put(k, this.getObject(sectionName + '/' + k, bpm.getClassMeta().getInnerClass()));
            }
            Object object = bm.getBean();
            return (T)object;
        }
        finally {
            this.readUnlock();
        }
    }

    public final <T> T getSectionAsInterface(final String sectionName, final Class<T> c) {
        ThrowableUtils.assertFieldNotNull(c, (String)"c");
        if (!c.isInterface()) {
            throw new UnsupportedOperationException("Class passed to getSectionAsInterface is not an interface.");
        }
        InvocationHandler h = new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                BeanInfo bi = Introspector.getBeanInfo(c, null);
                for (PropertyDescriptor pd : bi.getPropertyDescriptors()) {
                    Method rm = pd.getReadMethod();
                    Method wm = pd.getWriteMethod();
                    if (method.equals(rm)) {
                        return ConfigFile.this.getObject(sectionName, pd.getName(), rm.getGenericReturnType(), new Type[0]);
                    }
                    if (!method.equals(wm)) continue;
                    return ConfigFile.this.put(sectionName, pd.getName(), args[0], null, false, false);
                }
                throw new UnsupportedOperationException("Unsupported interface method.  method=[ " + method + " ]");
            }
        };
        return (T)Proxy.newProxyInstance(c.getClassLoader(), new Class[]{c}, h);
    }

    public final boolean containsNonEmptyValue(String key) {
        return !StringUtils.isEmpty((String)this.getString(key, null));
    }

    protected abstract Section getSection(String var1);

    protected abstract Section getSection(String var1, boolean var2);

    public abstract ConfigFile addSection(String var1);

    public abstract ConfigFile setSection(String var1, Map<String, String> var2);

    public abstract ConfigFile removeSection(String var1);

    public abstract boolean isEncoded(String var1);

    public abstract ConfigFile save() throws IOException;

    public final ConfigFile serializeTo(Writer out) throws IOException {
        return this.serializeTo(out, ConfigFileFormat.INI);
    }

    public abstract ConfigFile serializeTo(Writer var1, ConfigFileFormat var2) throws IOException;

    public abstract ConfigFile addListener(ConfigFileListener var1);

    public abstract ConfigFile merge(ConfigFile var1);

    public abstract String toString();

    public abstract ConfigFile getResolving(VarResolver var1);

    public abstract ConfigFile getResolving(VarResolverSession var1);

    public abstract ConfigFile getResolving();

    public abstract Writable toWritable();

    protected VarResolver getVarResolver() {
        return null;
    }

    private static int parseIntWithSuffix(String s) {
        ThrowableUtils.assertFieldNotNull((Object)s, (String)"s");
        int m = 1;
        if (s.endsWith("M")) {
            m = 0x100000;
            s = s.substring(0, s.length() - 1).trim();
        } else if (s.endsWith("K")) {
            m = 1024;
            s = s.substring(0, s.length() - 1).trim();
        }
        return Integer.parseInt(s) * m;
    }
}

