/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.InvocationTargetException;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.internal.StringUtils;

public class RestException
extends FormattedRuntimeException {
    private static final long serialVersionUID = 1L;
    private final int status;
    private int occurrence;

    public RestException(int status, String msg, Object ... args) {
        super(msg, args);
        this.status = status;
    }

    public RestException(int status, Throwable cause) {
        this(status, cause.getLocalizedMessage(), new Object[0]);
        this.initCause(cause);
    }

    public synchronized RestException initCause(Throwable cause) {
        super.initCause(cause);
        return this;
    }

    public Throwable getRootCause() {
        Object t = this;
        while (t != null) {
            if ((t = ((Throwable)t).getCause()) instanceof RestException || t instanceof InvocationTargetException) continue;
            return t;
        }
        return null;
    }

    public String getFullStackMessage(boolean scrubForXssVulnerabilities) {
        String msg = this.getMessage();
        StringBuilder sb = new StringBuilder();
        if (msg != null) {
            if (scrubForXssVulnerabilities) {
                msg = msg.replace('<', ' ').replace('>', ' ').replace('&', ' ');
            }
            sb.append(msg);
        }
        for (Throwable e = this.getCause(); e != null; e = e.getCause()) {
            msg = e.getMessage();
            if (msg != null && scrubForXssVulnerabilities) {
                msg = msg.replace('<', ' ').replace('>', ' ').replace('&', ' ');
            }
            String cls = e.getClass().getSimpleName();
            if (msg == null) {
                sb.append(StringUtils.format((String)"\nCaused by ({0})", (Object[])new Object[]{cls}));
                continue;
            }
            sb.append(StringUtils.format((String)"\nCaused by ({0}): {1}", (Object[])new Object[]{cls, msg}));
        }
        return sb.toString();
    }

    public int hashCode() {
        int i = 0;
        for (Object t = this; t != null; t = ((Throwable)t).getCause()) {
            for (StackTraceElement e : ((Throwable)t).getStackTrace()) {
                i ^= e.hashCode();
            }
        }
        return i;
    }

    void setOccurrence(int occurrence) {
        this.occurrence = occurrence;
    }

    public int getOccurrence() {
        return this.occurrence;
    }

    public int getStatus() {
        return this.status;
    }
}

