/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.lang.annotation.Annotation;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import javax.activation.MimetypesFileTypeMap;
import javax.servlet.Servlet;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Context;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.Visibility;
import org.apache.juneau.encoders.EncoderGroup;
import org.apache.juneau.html.HtmlDocTemplate;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.ini.ConfigFile;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.Pair;
import org.apache.juneau.internal.ReflectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.SystemUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ParserGroup;
import org.apache.juneau.rest.CallMethod;
import org.apache.juneau.rest.CallRouter;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestCallHandler;
import org.apache.juneau.rest.RestConfig;
import org.apache.juneau.rest.RestConverter;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestGuard;
import org.apache.juneau.rest.RestInfoProvider;
import org.apache.juneau.rest.RestLogger;
import org.apache.juneau.rest.RestParam;
import org.apache.juneau.rest.RestParamDefaults;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResourceResolver;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServlet;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.StreamResource;
import org.apache.juneau.rest.UrlPathPattern;
import org.apache.juneau.rest.annotation.Body;
import org.apache.juneau.rest.annotation.FormData;
import org.apache.juneau.rest.annotation.HasFormData;
import org.apache.juneau.rest.annotation.HasQuery;
import org.apache.juneau.rest.annotation.Header;
import org.apache.juneau.rest.annotation.HookEvent;
import org.apache.juneau.rest.annotation.Messages;
import org.apache.juneau.rest.annotation.Method;
import org.apache.juneau.rest.annotation.Path;
import org.apache.juneau.rest.annotation.PathRemainder;
import org.apache.juneau.rest.annotation.Properties;
import org.apache.juneau.rest.annotation.Query;
import org.apache.juneau.rest.annotation.RestHook;
import org.apache.juneau.rest.annotation.RestMethod;
import org.apache.juneau.rest.annotation.RestResource;
import org.apache.juneau.rest.vars.FileVar;
import org.apache.juneau.rest.vars.LocalizationVar;
import org.apache.juneau.rest.vars.RequestVar;
import org.apache.juneau.rest.vars.SerializedRequestAttrVar;
import org.apache.juneau.rest.vars.ServletInitParamVar;
import org.apache.juneau.rest.vars.UrlEncodeVar;
import org.apache.juneau.rest.vars.UrlVar;
import org.apache.juneau.rest.vars.WidgetVar;
import org.apache.juneau.rest.widget.Widget;
import org.apache.juneau.serializer.SerializerGroup;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.utils.MessageBundle;
import org.apache.juneau.utils.ResourceFinder;

public final class RestContext
extends Context {
    private final Object resource;
    final RestConfig config;
    private final boolean allowHeaderParams;
    private final boolean allowBodyParam;
    private final boolean renderResponseStackTraces;
    private final boolean useStackTraceHashes;
    private final String defaultCharset;
    private final String paramFormat;
    private final String clientVersionHeader;
    private final String fullPath;
    private final String contextPath;
    private final String htmlHeader;
    private final String htmlNav;
    private final String htmlAside;
    private final String htmlStyle;
    private final String htmlStylesheet;
    private final String htmlScript;
    private final String htmlFooter;
    private final String htmlNoResultsMessage;
    private final String[] htmlLinks;
    private final boolean htmlNoWrap;
    private final HtmlDocTemplate htmlTemplate;
    private final Map<String, Widget> htmlWidgets;
    private final Set<String> allowMethodParams;
    private final ObjectMap properties;
    private final Class<?>[] beanFilters;
    private final Class<?>[] pojoSwaps;
    private final Map<Class<?>, RestParam> paramResolvers;
    private final SerializerGroup serializers;
    private final ParserGroup parsers;
    private final UrlEncodingSerializer urlEncodingSerializer;
    private final UrlEncodingParser urlEncodingParser;
    private final EncoderGroup encoders;
    private final MediaType[] supportedContentTypes;
    private final MediaType[] supportedAcceptTypes;
    private final Map<String, String> defaultRequestHeaders;
    private final Map<String, Object> defaultResponseHeaders;
    private final BeanContext beanContext;
    private final RestConverter[] converters;
    private final RestGuard[] guards;
    private final ResponseHandler[] responseHandlers;
    private final MimetypesFileTypeMap mimetypesFileTypeMap;
    private final StreamResource favIcon;
    private final Map<String, String> staticFilesMap;
    private final String[] staticFilesPrefixes;
    private final MessageBundle msgs;
    private final ConfigFile configFile;
    private final VarResolver varResolver;
    private final Map<String, CallRouter> callRouters;
    private final Map<String, CallMethod> callMethods;
    private final Map<String, RestContext> childResources;
    private final RestLogger logger;
    private final RestCallHandler callHandler;
    private final RestInfoProvider infoProvider;
    private final RestException initException;
    private final RestContext parentContext;
    private final RestResourceResolver resourceResolver;
    private final java.lang.reflect.Method[] postInitMethods;
    private final java.lang.reflect.Method[] postInitChildFirstMethods;
    private final java.lang.reflect.Method[] preCallMethods;
    private final java.lang.reflect.Method[] postCallMethods;
    private final java.lang.reflect.Method[] startCallMethods;
    private final java.lang.reflect.Method[] endCallMethods;
    private final java.lang.reflect.Method[] destroyMethods;
    private final RestParam[][] preCallMethodParams;
    private final RestParam[][] postCallMethodParams;
    private final Class<?>[][] postInitMethodParams;
    private final Class<?>[][] postInitChildFirstMethodParams;
    private final Class<?>[][] startCallMethodParams;
    private final Class<?>[][] endCallMethodParams;
    private final Class<?>[][] destroyMethodParams;
    private final Map<String, StreamResource> staticFilesCache = new ConcurrentHashMap<String, StreamResource>();
    private final ResourceFinder resourceFinder;
    private final ConcurrentHashMap<Integer, AtomicInteger> stackTraceHashes = new ConcurrentHashMap();

    public RestContext(Object resource, ServletContext servletContext, RestConfig config) throws Exception {
        super(null);
        RestException _initException = null;
        try {
            this.resource = resource;
            this.config = config;
            this.resourceFinder = new ResourceFinder(resource.getClass());
            this.parentContext = config.parentContext;
            Builder b = new Builder(resource, config);
            this.allowHeaderParams = b.allowHeaderParams;
            this.allowBodyParam = b.allowBodyParam;
            this.renderResponseStackTraces = b.renderResponseStackTraces;
            this.useStackTraceHashes = b.useStackTraceHashes;
            this.allowMethodParams = Collections.unmodifiableSet(b.allowMethodParams);
            this.defaultCharset = b.defaultCharset;
            this.paramFormat = b.paramFormat;
            this.varResolver = b.varResolver;
            this.configFile = b.configFile;
            this.properties = b.properties;
            this.beanFilters = b.beanFilters;
            this.pojoSwaps = b.pojoSwaps;
            this.paramResolvers = Collections.unmodifiableMap(b.paramResolvers);
            this.serializers = b.serializers;
            this.parsers = b.parsers;
            this.urlEncodingSerializer = b.urlEncodingSerializer;
            this.urlEncodingParser = b.urlEncodingParser;
            this.encoders = b.encoders;
            this.supportedContentTypes = (MediaType[])ArrayUtils.toObjectArray(b.supportedContentTypes, MediaType.class);
            this.supportedAcceptTypes = (MediaType[])ArrayUtils.toObjectArray(b.supportedAcceptTypes, MediaType.class);
            this.clientVersionHeader = b.clientVersionHeader;
            this.defaultRequestHeaders = Collections.unmodifiableMap(b.defaultRequestHeaders);
            this.defaultResponseHeaders = Collections.unmodifiableMap(b.defaultResponseHeaders);
            this.beanContext = b.beanContext;
            this.converters = b.converters.toArray(new RestConverter[b.converters.size()]);
            this.guards = b.guards.toArray(new RestGuard[b.guards.size()]);
            this.responseHandlers = (ResponseHandler[])ArrayUtils.toObjectArray(b.responseHandlers, ResponseHandler.class);
            this.mimetypesFileTypeMap = b.mimetypesFileTypeMap;
            this.favIcon = b.favIcon;
            this.staticFilesMap = Collections.unmodifiableMap(b.staticFilesMap);
            this.staticFilesPrefixes = b.staticFilesPrefixes;
            this.msgs = b.messageBundle;
            this.childResources = Collections.synchronizedMap(new LinkedHashMap());
            this.logger = b.logger;
            this.fullPath = b.fullPath;
            this.contextPath = StringUtils.nullIfEmpty((String)b.contextPath);
            this.htmlWidgets = Collections.unmodifiableMap(b.htmlWidgets);
            this.htmlHeader = b.htmlHeader;
            this.htmlLinks = b.htmlLinks;
            this.htmlNav = b.htmlNav;
            this.htmlAside = b.htmlAside;
            this.htmlStyle = b.htmlStyle;
            this.htmlStylesheet = b.htmlStylesheet;
            this.htmlScript = b.htmlScript;
            this.htmlFooter = b.htmlFooter;
            this.htmlNoWrap = b.htmlNoWrap;
            this.htmlNoResultsMessage = b.htmlNoResultsMessage;
            this.htmlTemplate = b.htmlTemplate;
            LinkedList<String> methodsFound = new LinkedList<String>();
            LinkedHashMap<String, CallRouter.Builder> routers = new LinkedHashMap<String, CallRouter.Builder>();
            LinkedHashMap<String, CallMethod> _javaRestMethods = new LinkedHashMap<String, CallMethod>();
            LinkedHashMap<String, java.lang.reflect.Method> _startCallMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            LinkedHashMap<String, java.lang.reflect.Method> _preCallMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            LinkedHashMap<String, java.lang.reflect.Method> _postCallMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            LinkedHashMap<String, java.lang.reflect.Method> _endCallMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            LinkedHashMap<String, java.lang.reflect.Method> _postInitMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            LinkedHashMap<String, java.lang.reflect.Method> _postInitChildFirstMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            LinkedHashMap<String, java.lang.reflect.Method> _destroyMethods = new LinkedHashMap<String, java.lang.reflect.Method>();
            ArrayList<RestParam[]> _preCallMethodParams = new ArrayList<RestParam[]>();
            ArrayList<RestParam[]> _postCallMethodParams = new ArrayList<RestParam[]>();
            ArrayList<Class<?>[]> _startCallMethodParams = new ArrayList<Class<?>[]>();
            ArrayList<Class<?>[]> _endCallMethodParams = new ArrayList<Class<?>[]>();
            ArrayList<Class<?>[]> _postInitMethodParams = new ArrayList<Class<?>[]>();
            ArrayList<Class<?>[]> _postInitChildFirstMethodParams = new ArrayList<Class<?>[]>();
            ArrayList<Class<?>[]> _destroyMethodParams = new ArrayList<Class<?>[]>();
            for (java.lang.reflect.Method method : resource.getClass().getMethods()) {
                if (!method.isAnnotationPresent(RestMethod.class)) continue;
                RestMethod a = method.getAnnotation(RestMethod.class);
                methodsFound.add(method.getName() + "," + a.name() + "," + a.path());
                try {
                    if (!Modifier.isPublic(method.getModifiers())) {
                        throw new RestServletException("@RestMethod method {0}.{1} must be defined as public.", ((Object)((Object)this)).getClass().getName(), method.getName());
                    }
                    CallMethod sm = new CallMethod(resource, method, this);
                    String httpMethod = sm.getHttpMethod();
                    if ("PROXY".equals(httpMethod)) {
                        ClassMeta interfaceClass = this.beanContext.getClassMeta(method.getGenericReturnType(), new Type[0]);
                        final Map remoteableMethods = interfaceClass.getRemoteableMethods();
                        if (remoteableMethods.isEmpty()) {
                            throw new RestException(500, "Method {0} returns an interface {1} that doesn't define any remoteable methods.", ClassUtils.getMethodSignature((java.lang.reflect.Method)method), interfaceClass.getReadableName());
                        }
                        sm = new CallMethod(resource, method, this){

                            @Override
                            int invoke(String pathInfo, RestRequest req, RestResponse res) throws RestException {
                                int rc = super.invoke(pathInfo, req, res);
                                if (rc != 200) {
                                    return rc;
                                }
                                Object o = res.getOutput();
                                if ("GET".equals(req.getMethod())) {
                                    res.setOutput(ClassUtils.getMethodInfo(remoteableMethods.values()));
                                    return 200;
                                }
                                if ("POST".equals(req.getMethod())) {
                                    java.lang.reflect.Method m;
                                    if (pathInfo.indexOf(47) != -1) {
                                        pathInfo = pathInfo.substring(pathInfo.lastIndexOf(47) + 1);
                                    }
                                    if ((m = (java.lang.reflect.Method)remoteableMethods.get(pathInfo = StringUtils.urlDecode((String)pathInfo))) != null) {
                                        try {
                                            Parser p = req.getBody().getParser();
                                            BufferedReader input = p.isReaderParser() ? req.getReader() : req.getInputStream();
                                            Object output = m.invoke(o, p.parseArgs((Object)input, m.getGenericParameterTypes()));
                                            res.setOutput(output);
                                            return 200;
                                        }
                                        catch (Exception e) {
                                            throw new RestException(500, e);
                                        }
                                    }
                                }
                                return 404;
                            }
                        };
                        _javaRestMethods.put(method.getName(), sm);
                        RestContext.addToRouter(routers, "GET", sm);
                        RestContext.addToRouter(routers, "POST", sm);
                        continue;
                    }
                    _javaRestMethods.put(method.getName(), sm);
                    RestContext.addToRouter(routers, httpMethod, sm);
                }
                catch (RestServletException e) {
                    throw new RestServletException("Problem occurred trying to serialize methods on class {0}, methods={1}", ((Object)((Object)this)).getClass().getName(), JsonSerializer.DEFAULT_LAX.serialize(methodsFound)).initCause((Throwable)((Object)e));
                }
            }
            for (java.lang.reflect.Method m : ClassUtils.getAllMethods(resource.getClass(), (boolean)true)) {
                if (!ClassUtils.isPublic((java.lang.reflect.Method)m) || !m.isAnnotationPresent(RestHook.class)) continue;
                HookEvent he = m.getAnnotation(RestHook.class).value();
                String sig = ClassUtils.getMethodSignature((java.lang.reflect.Method)m);
                switch (he) {
                    case PRE_CALL: {
                        if (_preCallMethods.containsKey(sig)) break;
                        Visibility.setAccessible((java.lang.reflect.Method)m);
                        _preCallMethods.put(sig, m);
                        _preCallMethodParams.add(this.findParams(m, false, null, true));
                        break;
                    }
                    case POST_CALL: {
                        if (_postCallMethods.containsKey(sig)) break;
                        Visibility.setAccessible((java.lang.reflect.Method)m);
                        _postCallMethods.put(sig, m);
                        _postCallMethodParams.add(this.findParams(m, false, null, true));
                        break;
                    }
                    case START_CALL: {
                        if (_startCallMethods.containsKey(sig)) break;
                        Visibility.setAccessible((java.lang.reflect.Method)m);
                        _startCallMethods.put(sig, m);
                        _startCallMethodParams.add(m.getParameterTypes());
                        ClassUtils.assertArgsOfType((java.lang.reflect.Method)m, (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class});
                        break;
                    }
                    case END_CALL: {
                        if (_endCallMethods.containsKey(sig)) break;
                        Visibility.setAccessible((java.lang.reflect.Method)m);
                        _endCallMethods.put(sig, m);
                        _endCallMethodParams.add(m.getParameterTypes());
                        ClassUtils.assertArgsOfType((java.lang.reflect.Method)m, (Class[])new Class[]{HttpServletRequest.class, HttpServletResponse.class});
                        break;
                    }
                    case POST_INIT: {
                        if (_postInitMethods.containsKey(sig)) break;
                        Visibility.setAccessible((java.lang.reflect.Method)m);
                        _postInitMethods.put(sig, m);
                        _postInitMethodParams.add(m.getParameterTypes());
                        ClassUtils.assertArgsOfType((java.lang.reflect.Method)m, (Class[])new Class[]{RestContext.class});
                        break;
                    }
                    case POST_INIT_CHILD_FIRST: {
                        if (_postInitChildFirstMethods.containsKey(sig)) break;
                        Visibility.setAccessible((java.lang.reflect.Method)m);
                        _postInitChildFirstMethods.put(sig, m);
                        _postInitChildFirstMethodParams.add(m.getParameterTypes());
                        ClassUtils.assertArgsOfType((java.lang.reflect.Method)m, (Class[])new Class[]{RestContext.class});
                        break;
                    }
                    case DESTROY: {
                        if (_destroyMethods.containsKey(sig)) break;
                        Visibility.setAccessible((java.lang.reflect.Method)m);
                        _destroyMethods.put(sig, m);
                        _destroyMethodParams.add(m.getParameterTypes());
                        ClassUtils.assertArgsOfType((java.lang.reflect.Method)m, (Class[])new Class[]{RestContext.class});
                        break;
                    }
                }
            }
            this.callMethods = Collections.unmodifiableMap(_javaRestMethods);
            this.preCallMethods = _preCallMethods.values().toArray(new java.lang.reflect.Method[_preCallMethods.size()]);
            this.postCallMethods = _postCallMethods.values().toArray(new java.lang.reflect.Method[_postCallMethods.size()]);
            this.startCallMethods = _startCallMethods.values().toArray(new java.lang.reflect.Method[_startCallMethods.size()]);
            this.endCallMethods = _endCallMethods.values().toArray(new java.lang.reflect.Method[_endCallMethods.size()]);
            this.postInitMethods = _postInitMethods.values().toArray(new java.lang.reflect.Method[_postInitMethods.size()]);
            this.postInitChildFirstMethods = _postInitChildFirstMethods.values().toArray(new java.lang.reflect.Method[_postInitChildFirstMethods.size()]);
            this.destroyMethods = _destroyMethods.values().toArray(new java.lang.reflect.Method[_destroyMethods.size()]);
            this.preCallMethodParams = (RestParam[][])_preCallMethodParams.toArray((T[])new RestParam[_preCallMethodParams.size()][]);
            this.postCallMethodParams = (RestParam[][])_postCallMethodParams.toArray((T[])new RestParam[_postCallMethodParams.size()][]);
            this.startCallMethodParams = (Class[][])_startCallMethodParams.toArray((T[])new Class[_startCallMethodParams.size()][]);
            this.endCallMethodParams = (Class[][])_endCallMethodParams.toArray((T[])new Class[_endCallMethodParams.size()][]);
            this.postInitMethodParams = (Class[][])_postInitMethodParams.toArray((T[])new Class[_postInitMethodParams.size()][]);
            this.postInitChildFirstMethodParams = (Class[][])_postInitChildFirstMethodParams.toArray((T[])new Class[_postInitChildFirstMethodParams.size()][]);
            this.destroyMethodParams = (Class[][])_destroyMethodParams.toArray((T[])new Class[_destroyMethodParams.size()][]);
            LinkedHashMap<String, CallRouter> _callRouters = new LinkedHashMap<String, CallRouter>();
            for (CallRouter.Builder crb : routers.values()) {
                _callRouters.put(crb.getHttpMethodName(), crb.build());
            }
            this.callRouters = Collections.unmodifiableMap(_callRouters);
            this.resourceResolver = RestContext.resolve(resource, RestResourceResolver.class, b.resourceResolver, new Object[0]);
            for (Object o : config.childResources) {
                String path = null;
                Object r = null;
                if (o instanceof Pair) {
                    Pair p = (Pair)o;
                    path = (String)p.first();
                    r = p.second();
                } else if (o instanceof Class) {
                    Class c = (Class)o;
                    if (c == config.resourceClass) continue;
                    r = c;
                } else {
                    r = o;
                }
                RestConfig childConfig = null;
                if (o instanceof Class) {
                    Class oc = (Class)o;
                    childConfig = new RestConfig(config.inner, oc, this);
                    r = this.resourceResolver.resolve(oc, childConfig);
                } else {
                    r = o;
                    childConfig = new RestConfig(config.inner, o.getClass(), this);
                }
                childConfig.init(r);
                if (r instanceof RestServlet) {
                    ((RestServlet)((Object)r)).innerInit(childConfig);
                }
                RestContext rc2 = new RestContext(r, servletContext, childConfig);
                if (r instanceof RestServlet) {
                    ((RestServlet)((Object)r)).setContext(rc2);
                }
                path = childConfig.path;
                this.childResources.put(path, rc2);
            }
            this.callHandler = config.callHandler == null ? new RestCallHandler(this) : RestContext.resolve(resource, RestCallHandler.class, config.callHandler, new Object[]{this});
            this.infoProvider = config.infoProvider == null ? new RestInfoProvider(this) : RestContext.resolve(resource, RestInfoProvider.class, config.infoProvider, new Object[]{this});
        }
        catch (RestException e) {
            _initException = e;
            throw e;
        }
        catch (Exception e) {
            _initException = new RestException(500, e);
            throw e;
        }
        finally {
            this.initException = _initException;
        }
    }

    private static void addToRouter(Map<String, CallRouter.Builder> routers, String httpMethodName, CallMethod cm) throws RestServletException {
        if (!routers.containsKey(httpMethodName)) {
            routers.put(httpMethodName, new CallRouter.Builder(httpMethodName));
        }
        routers.get(httpMethodName).add(cm);
    }

    private static boolean getBoolean(Object o, String systemProperty, boolean def) {
        if (o == null) {
            o = SystemUtils.getFirstBoolean((Boolean)def, (String[])new String[]{systemProperty});
        }
        return "true".equalsIgnoreCase(o.toString());
    }

    private static String getString(Object o, String systemProperty, String def) {
        if (o == null) {
            o = SystemUtils.getFirstString((String)def, (String[])new String[]{systemProperty});
        }
        return o.toString();
    }

    protected RestResourceResolver getResourceResolver() {
        return this.resourceResolver;
    }

    public VarResolver getVarResolver() {
        return this.varResolver;
    }

    public ConfigFile getConfigFile() {
        return this.configFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StreamResource resolveStaticFile(String pathInfo) throws IOException {
        if (!this.staticFilesCache.containsKey(pathInfo)) {
            String p = StringUtils.urlDecode((String)StringUtils.trimSlashes((String)pathInfo));
            if (p.indexOf("..") != -1) {
                throw new RestException(404, "Invalid path", new Object[0]);
            }
            for (Map.Entry<String, String> e : this.staticFilesMap.entrySet()) {
                String p2;
                InputStream is;
                String remainder;
                String key = StringUtils.trimSlashes((String)e.getKey());
                if (!p.startsWith(key)) continue;
                String string = remainder = p.equals(key) ? "" : p.substring(key.length());
                if (!remainder.isEmpty() && !remainder.startsWith("/") || (is = this.getResource(p2 = StringUtils.trimSlashes((String)e.getValue()) + remainder, null)) == null) continue;
                try {
                    int i = p2.lastIndexOf(47);
                    String name = i == -1 ? p2 : p2.substring(i + 1);
                    String mediaType = this.mimetypesFileTypeMap.getContentType(name);
                    ObjectMap headers = new ObjectMap().append("Cache-Control", (Object)"max-age=86400, public");
                    this.staticFilesCache.put(pathInfo, new StreamResource(MediaType.forString((String)mediaType), (Map<String, Object>)headers, is));
                    StreamResource streamResource = this.staticFilesCache.get(pathInfo);
                    return streamResource;
                }
                finally {
                    is.close();
                }
            }
        }
        return this.staticFilesCache.get(pathInfo);
    }

    protected InputStream getResource(String name, Locale locale) throws IOException {
        return this.resourceFinder.getResourceAsStream(name, locale);
    }

    public String getResourceAsString(String name, Locale locale) throws IOException {
        return this.resourceFinder.getResourceAsString(name, locale);
    }

    public <T> T getResource(Class<T> c, MediaType mediaType, String name, Locale locale) throws IOException, ServletException {
        InputStream is = this.getResource(name, locale);
        if (is == null) {
            return null;
        }
        try {
            Parser p = this.parsers.getParser(mediaType);
            if (p != null) {
                try {
                    if (p.isReaderParser()) {
                        return (T)p.parse((Object)new InputStreamReader(is, IOUtils.UTF8), c);
                    }
                    return (T)p.parse((Object)is, c);
                }
                catch (ParseException e) {
                    throw new ServletException("Could not parse resource '' as media type '" + mediaType + "'.");
                }
            }
            throw new ServletException("Unknown media type '" + mediaType + "'");
        }
        catch (Exception e) {
            throw new ServletException("Could not parse resource with name '" + name + "'", (Throwable)e);
        }
    }

    public String getPath() {
        return this.fullPath;
    }

    public String getHtmlHeader() {
        return this.htmlHeader;
    }

    public String[] getHtmlLinks() {
        return this.htmlLinks;
    }

    public String getHtmlNav() {
        return this.htmlNav;
    }

    public String getHtmlAside() {
        return this.htmlAside;
    }

    public String getHtmlFooter() {
        return this.htmlFooter;
    }

    public String getHtmlStylesheet() {
        return this.htmlStylesheet;
    }

    public String getHtmlStyle() {
        return this.htmlStyle;
    }

    public String getHtmlScript() {
        return this.htmlScript;
    }

    public boolean getHtmlNoWrap() {
        return this.htmlNoWrap;
    }

    public HtmlDocTemplate getHtmlTemplate() {
        return this.htmlTemplate;
    }

    public String getHtmlNoResultsMessage() {
        return this.htmlNoResultsMessage;
    }

    public Map<String, Widget> getHtmlWidgets() {
        return this.htmlWidgets;
    }

    public RestLogger getLogger() {
        return this.logger;
    }

    public MessageBundle getMessages() {
        return this.msgs;
    }

    public RestInfoProvider getInfoProvider() {
        return this.infoProvider;
    }

    protected RestCallHandler getCallHandler() {
        return this.callHandler;
    }

    protected Map<String, CallRouter> getCallRouters() {
        return this.callRouters;
    }

    public Object getResource() {
        return this.resource;
    }

    public RestServlet getRestServlet() {
        return this.resource instanceof RestServlet ? (RestServlet)((Object)this.resource) : null;
    }

    protected void checkForInitException() throws RestException {
        if (this.initException != null) {
            throw this.initException;
        }
    }

    public RestContext getParentContext() {
        return this.parentContext;
    }

    public BeanContext getBeanContext() {
        return this.beanContext;
    }

    public ObjectMap getProperties() {
        return this.properties;
    }

    public SerializerGroup getSerializers() {
        return this.serializers;
    }

    public ParserGroup getParsers() {
        return this.parsers;
    }

    public String getServletInitParameter(String name) {
        return this.config.getInitParameter(name);
    }

    public Map<String, RestContext> getChildResources() {
        return Collections.unmodifiableMap(this.childResources);
    }

    protected int getStackTraceOccurrence(Throwable e) {
        if (!this.useStackTraceHashes) {
            return 0;
        }
        int h = e.hashCode();
        this.stackTraceHashes.putIfAbsent(h, new AtomicInteger());
        return this.stackTraceHashes.get(h).incrementAndGet();
    }

    protected boolean isRenderResponseStackTraces() {
        return this.renderResponseStackTraces;
    }

    protected boolean isAllowHeaderParams() {
        return this.allowHeaderParams;
    }

    protected boolean isAllowBodyParam() {
        return this.allowBodyParam;
    }

    protected String getDefaultCharset() {
        return this.defaultCharset;
    }

    protected String getParamFormat() {
        return this.paramFormat;
    }

    protected String getClientVersionHeader() {
        return this.clientVersionHeader;
    }

    protected boolean allowMethodParam(String m) {
        return !StringUtils.isEmpty((String)m) && (this.allowMethodParams.contains(m) || this.allowMethodParams.contains("*"));
    }

    protected Class<?>[] getBeanFilters() {
        return this.beanFilters;
    }

    protected Class<?>[] getPojoSwaps() {
        return this.pojoSwaps;
    }

    protected RestParam[] findParams(java.lang.reflect.Method method, boolean methodPlainParams, UrlPathPattern pathPattern, boolean isPreOrPost) throws ServletException {
        Type[] pt = method.getGenericParameterTypes();
        Annotation[][] pa = method.getParameterAnnotations();
        RestParam[] rp = new RestParam[pt.length];
        int attrIndex = 0;
        for (int i = 0; i < pt.length; ++i) {
            String name;
            Type t = pt[i];
            if (t instanceof Class) {
                Annotation[] c = (Annotation[])t;
                rp[i] = this.paramResolvers.get(c);
                if (rp[i] == null) {
                    rp[i] = RestParamDefaults.STANDARD_RESOLVERS.get(c);
                }
            }
            if (rp[i] == null) {
                for (Annotation a : pa[i]) {
                    if (a instanceof Header) {
                        rp[i] = new RestParamDefaults.HeaderObject((Header)a, t);
                        continue;
                    }
                    if (a instanceof FormData) {
                        rp[i] = new RestParamDefaults.FormDataObject(method, (FormData)a, t, methodPlainParams);
                        continue;
                    }
                    if (a instanceof Query) {
                        rp[i] = new RestParamDefaults.QueryObject(method, (Query)a, t, methodPlainParams);
                        continue;
                    }
                    if (a instanceof HasFormData) {
                        rp[i] = new RestParamDefaults.HasFormDataObject(method, (HasFormData)a, t);
                        continue;
                    }
                    if (a instanceof HasQuery) {
                        rp[i] = new RestParamDefaults.HasQueryObject(method, (HasQuery)a, t);
                        continue;
                    }
                    if (a instanceof Body) {
                        rp[i] = new RestParamDefaults.BodyObject(t);
                        continue;
                    }
                    if (a instanceof Method) {
                        rp[i] = new RestParamDefaults.MethodObject(method, t);
                        continue;
                    }
                    if (a instanceof PathRemainder) {
                        rp[i] = new RestParamDefaults.PathRemainderObject(method, t);
                        continue;
                    }
                    if (a instanceof Properties) {
                        rp[i] = new RestParamDefaults.PropsObject(method, t);
                        continue;
                    }
                    if (!(a instanceof Messages)) continue;
                    rp[i] = new RestParamDefaults.MessageBundleObject();
                }
            }
            if (rp[i] != null) continue;
            if (isPreOrPost) {
                throw new RestServletException("Invalid parameter specified for method ''{0}'' at index position {1}", method, i);
            }
            Path p = null;
            for (Annotation a : pa[i]) {
                if (!(a instanceof Path)) continue;
                p = (Path)a;
            }
            String string = name = p == null ? "" : StringUtils.firstNonEmpty((String[])new String[]{p.name(), p.value()});
            if (StringUtils.isEmpty((String)name)) {
                int idx = attrIndex++;
                String[] vars = pathPattern.getVars();
                if (vars.length <= idx) {
                    throw new RestServletException("Number of attribute parameters in method ''{0}'' exceeds the number of URL pattern variables.", method);
                }
                String idxs = String.valueOf(idx);
                for (int j = 0; j < vars.length; ++j) {
                    if (!StringUtils.isNumeric((String)vars[j]) || !vars[j].equals(idxs)) continue;
                    name = vars[j];
                }
                if (StringUtils.isEmpty((String)name)) {
                    name = pathPattern.getVars()[idx];
                }
            }
            rp[i] = new RestParamDefaults.PathParameterObject(name, t);
        }
        return rp;
    }

    void preCall(RestRequest req, RestResponse res) throws RestException {
        for (int i = 0; i < this.preCallMethods.length; ++i) {
            RestContext.preOrPost(this.resource, this.preCallMethods[i], this.preCallMethodParams[i], req, res);
        }
    }

    void postCall(RestRequest req, RestResponse res) throws RestException {
        for (int i = 0; i < this.postCallMethods.length; ++i) {
            RestContext.preOrPost(this.resource, this.postCallMethods[i], this.postCallMethodParams[i], req, res);
        }
    }

    private static void preOrPost(Object resource, java.lang.reflect.Method m, RestParam[] mp, RestRequest req, RestResponse res) throws RestException {
        if (m != null) {
            Object[] args = new Object[mp.length];
            for (int i = 0; i < mp.length; ++i) {
                try {
                    args[i] = mp[i].resolve(req, res);
                    continue;
                }
                catch (RestException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RestException(400, "Invalid data conversion.  Could not convert {0} ''{1}'' to type ''{2}'' on method ''{3}.{4}''.", mp[i].getParamType().name(), mp[i].getName(), mp[i].getType(), m.getDeclaringClass().getName(), m.getName()).initCause(e);
                }
            }
            try {
                m.invoke(resource, args);
            }
            catch (RestException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RestException(500, e.getLocalizedMessage(), new Object[0]).initCause(e);
            }
        }
    }

    void startCall(HttpServletRequest req, HttpServletResponse res) {
        for (int i = 0; i < this.startCallMethods.length; ++i) {
            RestContext.startOrFinish(this.resource, this.startCallMethods[i], this.startCallMethodParams[i], req, res);
        }
    }

    void finishCall(HttpServletRequest req, HttpServletResponse res) {
        for (int i = 0; i < this.endCallMethods.length; ++i) {
            RestContext.startOrFinish(this.resource, this.endCallMethods[i], this.endCallMethodParams[i], req, res);
        }
    }

    private static void startOrFinish(Object resource, java.lang.reflect.Method m, Class<?>[] p, HttpServletRequest req, HttpServletResponse res) {
        if (m != null) {
            Object[] args = new Object[p.length];
            for (int i = 0; i < p.length; ++i) {
                if (p[i] == HttpServletRequest.class) {
                    args[i] = req;
                    continue;
                }
                if (p[i] != HttpServletResponse.class) continue;
                args[i] = res;
            }
            try {
                m.invoke(resource, args);
            }
            catch (RestException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RestException(500, e.getLocalizedMessage(), new Object[0]).initCause(e);
            }
        }
    }

    void postInit() throws ServletException {
        for (int i = 0; i < this.postInitMethods.length; ++i) {
            this.postInitOrDestroy(this.resource, this.postInitMethods[i], this.postInitMethodParams[i]);
        }
        for (RestContext childContext : this.childResources.values()) {
            childContext.postInit();
        }
    }

    void postInitChildFirst() throws ServletException {
        for (RestContext childContext : this.childResources.values()) {
            childContext.postInitChildFirst();
        }
        for (int i = 0; i < this.postInitChildFirstMethods.length; ++i) {
            this.postInitOrDestroy(this.resource, this.postInitChildFirstMethods[i], this.postInitChildFirstMethodParams[i]);
        }
    }

    private void postInitOrDestroy(Object r, java.lang.reflect.Method m, Class<?>[] p) {
        if (m != null) {
            Object[] args = new Object[p.length];
            for (int i = 0; i < p.length; ++i) {
                if (p[i] == RestContext.class) {
                    args[i] = this;
                    continue;
                }
                if (p[i] == RestConfig.class) {
                    args[i] = this.config;
                    continue;
                }
                if (p[i] != ServletConfig.class) continue;
                args[i] = this.config.inner;
            }
            try {
                m.invoke(r, args);
            }
            catch (RestException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RestException(500, e.getLocalizedMessage(), new Object[0]).initCause(e);
            }
        }
    }

    protected UrlEncodingParser getUrlEncodingParser() {
        return this.urlEncodingParser;
    }

    protected UrlEncodingSerializer getUrlEncodingSerializer() {
        return this.urlEncodingSerializer;
    }

    protected EncoderGroup getEncoders() {
        return this.encoders;
    }

    protected MediaType[] getSupportedAcceptTypes() {
        return this.supportedAcceptTypes;
    }

    protected MediaType[] getSupportedContentTypes() {
        return this.supportedContentTypes;
    }

    protected Map<String, String> getDefaultRequestHeaders() {
        return this.defaultRequestHeaders;
    }

    public Map<String, Object> getDefaultResponseHeaders() {
        return this.defaultResponseHeaders;
    }

    protected RestConverter[] getConverters() {
        return this.converters;
    }

    protected RestGuard[] getGuards() {
        return this.guards;
    }

    protected ResponseHandler[] getResponseHandlers() {
        return this.responseHandlers;
    }

    protected String getMediaTypeForName(String name) {
        return this.mimetypesFileTypeMap.getContentType(name);
    }

    protected StreamResource getFavIcon() {
        return this.favIcon;
    }

    protected boolean isStaticFile(String p) {
        return StringUtils.pathStartsWith((String)p, (String[])this.staticFilesPrefixes);
    }

    protected Map<String, CallMethod> getCallMethods() {
        return this.callMethods;
    }

    protected void destroy() {
        for (int i = 0; i < this.destroyMethods.length; ++i) {
            try {
                this.postInitOrDestroy(this.resource, this.destroyMethods[i], this.destroyMethodParams[i]);
                continue;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        for (RestContext r : this.childResources.values()) {
            r.destroy();
            if (!(r.resource instanceof Servlet)) continue;
            ((Servlet)r.resource).destroy();
        }
    }

    protected boolean hasChildResources() {
        return !this.childResources.isEmpty();
    }

    protected RestContext getChildResource(String path) {
        return this.childResources.get(path);
    }

    protected String getContextPath() {
        if (this.contextPath != null) {
            return this.contextPath;
        }
        if (this.parentContext != null) {
            return this.parentContext.getContextPath();
        }
        return null;
    }

    private static <T> T resolve(Object outer, Class<T> c, Object o, Object ... cArgs) throws RestServletException {
        try {
            return (T)ClassUtils.newInstanceFromOuter((Object)outer, c, (Object)o, (Object[])cArgs);
        }
        catch (Exception e) {
            throw new RestServletException("Exception occurred while constructing class ''{0}''", c).initCause(e);
        }
    }

    private static class Builder {
        boolean allowHeaderParams;
        boolean allowBodyParam;
        boolean renderResponseStackTraces;
        boolean useStackTraceHashes;
        VarResolver varResolver;
        ConfigFile configFile;
        ObjectMap properties;
        Class<?>[] beanFilters;
        Class<?>[] pojoSwaps;
        Map<Class<?>, RestParam> paramResolvers = new HashMap();
        SerializerGroup serializers;
        ParserGroup parsers;
        UrlEncodingSerializer urlEncodingSerializer;
        UrlEncodingParser urlEncodingParser;
        EncoderGroup encoders;
        String clientVersionHeader = "";
        String defaultCharset;
        String paramFormat;
        String htmlHeader;
        String htmlNav;
        String htmlAside;
        String htmlStyle;
        String htmlStylesheet;
        String htmlScript;
        String htmlFooter;
        String htmlNoResultsMessage;
        String[] htmlLinks;
        boolean htmlNoWrap;
        HtmlDocTemplate htmlTemplate;
        List<MediaType> supportedContentTypes;
        List<MediaType> supportedAcceptTypes;
        Map<String, String> defaultRequestHeaders = new TreeMap<String, String>(String.CASE_INSENSITIVE_ORDER);
        Map<String, Object> defaultResponseHeaders;
        BeanContext beanContext;
        List<RestConverter> converters = new ArrayList<RestConverter>();
        List<RestGuard> guards = new ArrayList<RestGuard>();
        List<ResponseHandler> responseHandlers = new ArrayList<ResponseHandler>();
        MimetypesFileTypeMap mimetypesFileTypeMap;
        StreamResource favIcon;
        Map<String, String> staticFilesMap;
        String[] staticFilesPrefixes;
        MessageBundle messageBundle;
        Set<String> allowMethodParams = new LinkedHashSet<String>();
        RestLogger logger;
        String fullPath;
        Map<String, Widget> htmlWidgets;
        Object resourceResolver;
        String contextPath;

        /*
         * WARNING - void declaration
         */
        private Builder(Object resource, RestConfig sc) throws Exception {
            Pair p;
            PropertyStore ps = sc.createPropertyStore();
            LinkedHashMap restResourceAnnotationsChildFirst = ReflectionUtils.findAnnotationsMap(RestResource.class, resource.getClass());
            this.allowHeaderParams = RestContext.getBoolean(sc.allowHeaderParams, "juneau.allowHeaderParams", true);
            this.allowBodyParam = RestContext.getBoolean(sc.allowBodyParam, "juneau.allowBodyParam", true);
            this.renderResponseStackTraces = RestContext.getBoolean(sc.renderResponseStackTraces, "juneau.renderResponseStackTraces", false);
            this.useStackTraceHashes = RestContext.getBoolean(sc.useStackTraceHashes, "juneau.useStackTraceHashes", true);
            this.defaultCharset = RestContext.getString(sc.defaultCharset, "juneau.defaultCharset", "utf-8");
            this.paramFormat = RestContext.getString(sc.paramFormat, "juneau.paramFormat", "UON");
            this.resourceResolver = sc.resourceResolver;
            String amp = RestContext.getString(sc.allowMethodParam, "juneau.allowMethodParam", "HEAD,OPTIONS");
            amp = "true".equals(amp) ? "*" : amp.toUpperCase();
            this.allowMethodParams.addAll(Arrays.asList(StringUtils.split((String)amp)));
            this.varResolver = sc.varResolverBuilder.vars(new Class[]{FileVar.class, LocalizationVar.class, RequestVar.class, SerializedRequestAttrVar.class, ServletInitParamVar.class, UrlVar.class, UrlEncodeVar.class, WidgetVar.class}).build();
            this.configFile = sc.configFile.getResolving(this.varResolver);
            this.properties = sc.properties;
            Collections.reverse(sc.beanFilters);
            Collections.reverse(sc.pojoSwaps);
            this.beanFilters = (Class[])ArrayUtils.toObjectArray(sc.beanFilters, Class.class);
            this.pojoSwaps = (Class[])ArrayUtils.toObjectArray(sc.pojoSwaps, Class.class);
            for (Class<?> clazz : sc.paramResolvers) {
                RestParam restParam = (RestParam)ClassUtils.newInstanceFromOuter((Object)resource, RestParam.class, clazz, (Object[])new Object[0]);
                this.paramResolvers.put(restParam.forClass(), restParam);
            }
            this.clientVersionHeader = sc.clientVersionHeader;
            for (Map.Entry entry : restResourceAnnotationsChildFirst.entrySet()) {
                Class clazz = (Class)entry.getKey();
                RestResource r = (RestResource)entry.getValue();
                if (r.messages().isEmpty()) continue;
                if (this.messageBundle == null) {
                    this.messageBundle = new MessageBundle(clazz, r.messages());
                    continue;
                }
                this.messageBundle.addSearchPath(clazz, r.messages());
            }
            if (this.messageBundle == null) {
                this.messageBundle = new MessageBundle(resource.getClass(), "");
            }
            ps.addBeanFilters((Class[])this.beanFilters).addPojoSwaps((Class[])this.pojoSwaps).setProperties((Map)this.properties);
            this.serializers = sc.serializers.beanFilters((Class[])this.beanFilters).pojoSwaps((Class[])this.pojoSwaps).properties(this.properties).listener(sc.serializerListener).build();
            this.parsers = sc.parsers.beanFilters((Class[])this.beanFilters).pojoSwaps((Class[])this.pojoSwaps).properties(this.properties).listener(sc.parserListener).build();
            this.urlEncodingSerializer = new UrlEncodingSerializer(ps);
            this.urlEncodingParser = new UrlEncodingParser(ps);
            this.encoders = sc.encoders.build();
            this.supportedContentTypes = sc.supportedContentTypes != null ? sc.supportedContentTypes : this.serializers.getSupportedMediaTypes();
            this.supportedAcceptTypes = sc.supportedAcceptTypes != null ? sc.supportedAcceptTypes : this.parsers.getSupportedMediaTypes();
            this.defaultRequestHeaders.putAll(sc.defaultRequestHeaders);
            this.defaultResponseHeaders = Collections.unmodifiableMap(new LinkedHashMap<String, Object>(sc.defaultResponseHeaders));
            this.beanContext = ps.getBeanContext();
            this.contextPath = sc.contextPath;
            for (Object object : sc.converters) {
                this.converters.add((RestConverter)RestContext.resolve(resource, RestConverter.class, object, new Object[0]));
            }
            for (Object object : sc.guards) {
                this.guards.add((RestGuard)RestContext.resolve(resource, RestGuard.class, object, new Object[0]));
            }
            for (Object object : sc.responseHandlers) {
                this.responseHandlers.add((ResponseHandler)RestContext.resolve(resource, ResponseHandler.class, object, new Object[0]));
            }
            this.mimetypesFileTypeMap = sc.mimeTypes;
            VarResolver vr = sc.getVarResolverBuilder().build();
            if (sc.favIcon != null) {
                void var8_27;
                Object object = sc.favIcon;
                Object var8_24 = null;
                if (object instanceof Pair) {
                    p = (Pair)object;
                    InputStream inputStream = ReflectionUtils.getResource((Class)((Class)p.first()), (String)vr.resolve((String)p.second()));
                } else {
                    InputStream inputStream = IOUtils.toInputStream((Object)object);
                }
                if (var8_27 != null) {
                    this.favIcon = new StreamResource(MediaType.forString((String)"image/x-icon"), var8_27);
                }
            }
            this.staticFilesMap = new LinkedHashMap<String, String>();
            if (sc.staticFiles != null) {
                for (Object object : sc.staticFiles) {
                    if (object instanceof Pair) {
                        p = (Pair)object;
                        this.staticFilesMap.putAll((Map)JsonParser.DEFAULT.parse((Object)vr.resolve((String)p.second()), LinkedHashMap.class));
                        continue;
                    }
                    throw new RuntimeException("TODO");
                }
            }
            this.staticFilesPrefixes = this.staticFilesMap.keySet().toArray(new String[0]);
            this.logger = sc.logger == null ? new RestLogger.NoOp() : (RestLogger)RestContext.resolve(resource, RestLogger.class, sc.logger, new Object[0]);
            this.fullPath = (sc.parentContext == null ? "" : sc.parentContext.fullPath + '/') + sc.path;
            this.htmlWidgets = new LinkedHashMap<String, Widget>();
            for (Class<? extends Widget> clazz : sc.htmlWidgets) {
                Widget w = (Widget)RestContext.resolve(resource, Widget.class, clazz, new Object[0]);
                this.htmlWidgets.put(w.getName(), w);
            }
            this.htmlHeader = sc.htmlHeader;
            this.htmlLinks = sc.htmlLinks;
            this.htmlNav = sc.htmlNav;
            this.htmlAside = sc.htmlAside;
            this.htmlStyle = sc.htmlStyle;
            this.htmlStylesheet = sc.htmlStylesheet;
            this.htmlScript = sc.htmlScript;
            this.htmlFooter = sc.htmlFooter;
            this.htmlNoWrap = sc.htmlNoWrap;
            this.htmlNoResultsMessage = sc.htmlNoResultsMessage;
            this.htmlTemplate = (HtmlDocTemplate)RestContext.resolve(resource, HtmlDocTemplate.class, sc.htmlTemplate, new Object[0]);
        }
    }
}

