/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.Type;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectList;
import org.apache.juneau.PartType;
import org.apache.juneau.internal.ArrayUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonSerializer;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.urlencoding.UrlEncodingParser;
import org.apache.juneau.utils.SearchArgs;
import org.apache.juneau.xml.XmlUtils;

public final class RequestQuery
extends LinkedHashMap<String, String[]> {
    private static final long serialVersionUID = 1L;
    private UrlEncodingParser parser;
    private BeanSession beanSession;

    RequestQuery setParser(UrlEncodingParser parser) {
        this.parser = parser;
        return this;
    }

    RequestQuery setBeanSession(BeanSession beanSession) {
        this.beanSession = beanSession;
        return this;
    }

    RequestQuery copy() {
        RequestQuery rq = new RequestQuery();
        rq.putAll(this);
        return rq;
    }

    public RequestQuery addDefault(Map<String, String> defaultEntries) {
        if (defaultEntries != null) {
            for (Map.Entry<String, String> e : defaultEntries.entrySet()) {
                String key = e.getKey();
                String value = e.getValue();
                String[] v = (String[])this.get(key);
                if (v != null && v.length != 0 && !StringUtils.isEmpty((String)v[0])) continue;
                this.put(key, new String[]{value});
            }
        }
        return this;
    }

    @Override
    public void put(String name, Object value) {
        this.put(name, new String[]{StringUtils.toString((Object)value)});
    }

    public String getString(String name) {
        String[] v = (String[])this.get(name);
        if (v == null || v.length == 0) {
            return null;
        }
        if (v.length == 1 && v[0] == null) {
            return "";
        }
        return v[0];
    }

    public String getString(String name, String def) {
        String s = this.getString(name);
        return StringUtils.isEmpty((String)s) ? def : s;
    }

    public int getInt(String name) {
        return this.getInt(name, 0);
    }

    public int getInt(String name, int def) {
        String s = this.getString(name);
        return StringUtils.isEmpty((String)s) ? def : Integer.parseInt(s);
    }

    public boolean getBoolean(String name) {
        return this.getBoolean(name, false);
    }

    public boolean getBoolean(String name, boolean def) {
        String s = this.getString(name);
        return StringUtils.isEmpty((String)s) ? def : Boolean.parseBoolean(s);
    }

    public <T> T get(String name, Class<T> type) throws ParseException {
        return this.get(name, (Type)this.beanSession.getClassMeta(type), new Type[0]);
    }

    public <T> T get(String name, T def, Class<T> type) throws ParseException {
        return this.get(name, def, (Type)this.beanSession.getClassMeta(type), new Type[0]);
    }

    public <T> T get(String name, Type type, Type ... args) throws ParseException {
        return this.parse(name, this.beanSession.getClassMeta(type, args));
    }

    public <T> T get(String name, Object def, Type type, Type ... args) throws ParseException {
        return (T)this.parse(name, def, this.beanSession.getClassMeta(type, args));
    }

    public <T> T getAll(String name, Class<T> c) throws ParseException {
        return this.getAll(name, (Type)this.beanSession.getClassMeta(c), new Type[0]);
    }

    public <T> T getAll(String name, Type type, Type ... args) throws ParseException {
        return this.parseAll(name, this.beanSession.getClassMeta(type, args));
    }

    public boolean containsAnyKeys(String ... params) {
        for (String p : params) {
            if (!this.containsKey(p)) continue;
            return true;
        }
        return false;
    }

    public SearchArgs getSearchArgs() {
        if (this.hasAny("s", "v", "o", "p", "l", "i")) {
            return new SearchArgs.Builder().search(this.getString("s")).view(this.getString("v")).sort(this.getString("o")).position(this.getInt("p")).limit(this.getInt("l")).ignoreCase(this.getBoolean("i")).build();
        }
        return null;
    }

    public boolean hasAny(String ... paramNames) {
        for (String p : paramNames) {
            if (!this.containsKey(p)) continue;
            return true;
        }
        return false;
    }

    private <T> T parse(String name, T def, ClassMeta<T> cm) throws ParseException {
        String val = this.getString(name);
        if (val == null) {
            return def;
        }
        return this.parseValue(val, cm);
    }

    private <T> T parse(String name, ClassMeta<T> cm) throws ParseException {
        String val = this.getString(name);
        if (cm.isPrimitive() && (val == null || val.isEmpty())) {
            return (T)cm.getPrimitiveDefault();
        }
        return this.parseValue(val, cm);
    }

    private <T> T parseAll(String name, ClassMeta<T> cm) throws ParseException {
        String[] p = (String[])this.get(name);
        if (p == null) {
            return null;
        }
        if (cm.isArray()) {
            ArrayList<T> c = new ArrayList<T>();
            for (int i = 0; i < p.length; ++i) {
                c.add(this.parseValue(p[i], cm.getElementType()));
            }
            return (T)ArrayUtils.toArray(c, (Class)cm.getElementType().getInnerClass());
        }
        if (cm.isCollection()) {
            try {
                Collection c = (Collection)(cm.canCreateNewInstance() ? cm.newInstance() : new ObjectList());
                for (int i = 0; i < p.length; ++i) {
                    c.add(this.parseValue(p[i], cm.getElementType()));
                }
                return (T)c;
            }
            catch (ParseException e) {
                throw e;
            }
            catch (Exception e) {
                throw new ParseException(e);
            }
        }
        throw new ParseException("Invalid call to getQueryParameters(String, ClassMeta).  Class type must be a Collection or array.", new Object[0]);
    }

    private <T> T parseValue(String val, ClassMeta<T> c) throws ParseException {
        return (T)this.parser.parse(PartType.QUERY, val, c);
    }

    public String toString(boolean sorted) {
        AbstractMap m = sorted ? new TreeMap() : new LinkedHashMap();
        for (Map.Entry e : this.entrySet()) {
            String[] v = (String[])e.getValue();
            m.put(e.getKey(), v.length == 1 ? v[0] : v);
        }
        return JsonSerializer.DEFAULT_LAX.toString(m);
    }

    public String toQueryString() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry e : this.entrySet()) {
            for (int i = 0; i < ((String[])e.getValue()).length; ++i) {
                if (sb.length() > 0) {
                    sb.append("&");
                }
                sb.append(XmlUtils.urlEncode(e.getKey())).append('=').append(XmlUtils.urlEncode((Object)((String[])e.getValue())[i]));
            }
        }
        return sb.toString();
    }

    @Override
    public String toString() {
        return this.toString(false);
    }
}

