/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.lang.reflect.Method;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.VersionRange;
import org.apache.juneau.rest.RestMatcher;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.annotation.RestMethod;

public class ClientVersionMatcher
extends RestMatcher {
    private final String clientVersionHeader;
    private final VersionRange range;

    protected ClientVersionMatcher(String clientVersionHeader, Method javaMethod) {
        this.clientVersionHeader = StringUtils.isEmpty((String)clientVersionHeader) ? "X-Client-Version" : clientVersionHeader;
        RestMethod m = javaMethod.getAnnotation(RestMethod.class);
        this.range = new VersionRange(m.clientVersion());
    }

    @Override
    public boolean matches(RestRequest req) {
        return this.range.matches(req.getHeader(this.clientVersionHeader));
    }

    @Override
    public boolean mustMatch() {
        return true;
    }
}

