/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.utils;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.juneau.internal.FileUtils;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ObjectUtils;

public class ResourceFinder {
    private static final ResourceBundle.Control RB_CONTROL = ResourceBundle.Control.getControl(ResourceBundle.Control.FORMAT_DEFAULT);
    private static final List<Locale> ROOT_LOCALE = Arrays.asList(Locale.ROOT);
    private final ConcurrentHashMap<ResourceKey, Resource> cache = new ConcurrentHashMap();
    private final ConcurrentHashMap<URL, Resource> cacheByUrl = new ConcurrentHashMap();
    private final Class<?> c;

    public ResourceFinder(Class<?> forClass) {
        this.c = forClass;
    }

    public InputStream getResourceAsStream(String name) throws IOException {
        return this.getResourceAsStream(name, null);
    }

    public InputStream getResourceAsStream(String name, Locale locale) throws IOException {
        return this.getResource(name, locale).asInputStream();
    }

    public String getResourceAsString(String name) throws IOException {
        return this.getResourceAsString(name, null);
    }

    public String getResourceAsString(String name, Locale locale) throws IOException {
        return this.getResource(name, locale).asString();
    }

    private Resource getResource(String name, Locale locale) throws IOException {
        ResourceKey key = new ResourceKey(name, locale);
        Resource r = this.cache.get(key);
        if (r != null) {
            return r;
        }
        r = this.findResource(this.c, key);
        this.cache.putIfAbsent(key, r);
        r = this.cache.get(key);
        return r;
    }

    private Resource findResource(Class<?> c2, ResourceKey key) throws IOException {
        while (c2 != null) {
            if (key.locale == null) {
                URL url = c2.getResource(key.name);
                if (url != null) {
                    Resource r = this.cacheByUrl.get(url);
                    if (r == null) {
                        r = new Resource(IOUtils.readBytes(c2.getResourceAsStream(key.name), 1024));
                        this.cacheByUrl.putIfAbsent(url, r);
                        r = this.cacheByUrl.get(url);
                    }
                    return r;
                }
            } else {
                for (String n : ResourceFinder.getCandidateFileNames(key.name, key.locale)) {
                    URL url = c2.getResource(n);
                    if (url == null) continue;
                    Resource r = this.cacheByUrl.get(url);
                    if (r == null) {
                        r = new Resource(IOUtils.readBytes(c2.getResourceAsStream(n), 1024));
                        this.cacheByUrl.putIfAbsent(url, r);
                        r = this.cacheByUrl.get(url);
                    }
                    return r;
                }
            }
            c2 = c2.getSuperclass();
        }
        if (key.name.indexOf("..") == -1) {
            for (String n2 : ResourceFinder.getCandidateFileNames(key.name, key.locale)) {
                File f = new File(n2);
                if (!f.exists() || !f.canRead() || f.isAbsolute()) continue;
                URL url = f.toURI().toURL();
                Resource r = this.cacheByUrl.get(url);
                if (r == null) {
                    r = new Resource(IOUtils.readBytes(new FileInputStream(f), 1024));
                    this.cacheByUrl.putIfAbsent(url, r);
                    r = this.cacheByUrl.get(url);
                }
                return r;
            }
        }
        return new Resource(null);
    }

    private static Iterable<String> getCandidateFileNames(final String fileName, final Locale l) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    final Iterator<Locale> locales;
                    String baseName;
                    String ext;
                    {
                        this.locales = ResourceFinder.getCandidateLocales(l).iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.locales.hasNext();
                    }

                    @Override
                    public String next() {
                        Locale l2 = this.locales.next();
                        if (l2.toString().isEmpty()) {
                            return fileName;
                        }
                        if (this.baseName == null) {
                            this.baseName = FileUtils.getBaseName(fileName);
                        }
                        if (this.ext == null) {
                            this.ext = FileUtils.getExtension(fileName);
                        }
                        return this.baseName + "_" + l2.toString() + (this.ext.isEmpty() ? "" : '.' + this.ext);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    private static List<Locale> getCandidateLocales(Locale locale) {
        if (locale == null) {
            return ROOT_LOCALE;
        }
        return RB_CONTROL.getCandidateLocales("", locale);
    }

    private static class Resource {
        private byte[] bytes;
        private String string;

        private Resource(byte[] bytes) {
            this.bytes = bytes;
        }

        private String asString() {
            if (this.bytes == null) {
                return null;
            }
            try {
                if (this.string == null) {
                    this.string = new String(this.bytes, "UTF-8");
                }
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
            return this.string;
        }

        private InputStream asInputStream() {
            if (this.bytes == null) {
                return null;
            }
            return new ByteArrayInputStream(this.bytes);
        }
    }

    private static class ResourceKey {
        private final String name;
        private final Locale locale;

        ResourceKey(String name, Locale locale) {
            this.name = name;
            this.locale = locale;
        }

        public int hashCode() {
            return this.name.hashCode() + (this.locale == null ? 0 : this.locale.hashCode());
        }

        public boolean equals(Object o) {
            if (o == null) {
                return false;
            }
            ResourceKey ok = (ResourceKey)o;
            return ObjectUtils.equals(this.name, ok.name) && ObjectUtils.equals(this.locale, ok.locale);
        }
    }
}

