/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.urlencoding;

import java.io.StringWriter;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.PartType;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.serializer.PartSerializer;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.uon.UonSerializer;
import org.apache.juneau.uon.UonSerializerSession;
import org.apache.juneau.uon.UonUtils;
import org.apache.juneau.urlencoding.UrlEncodingSerializerBuilder;
import org.apache.juneau.urlencoding.UrlEncodingSerializerContext;
import org.apache.juneau.urlencoding.UrlEncodingSerializerSession;

public class UrlEncodingSerializer
extends UonSerializer
implements PartSerializer {
    public static final UrlEncodingSerializer DEFAULT = new UrlEncodingSerializer(PropertyStore.create());
    public static final UrlEncodingSerializer DEFAULT_PLAINTEXT = new PlainText(PropertyStore.create());
    public static final UrlEncodingSerializer DEFAULT_EXPANDED = new Expanded(PropertyStore.create());
    public static final UrlEncodingSerializer DEFAULT_READABLE = new Readable(PropertyStore.create());
    private final UrlEncodingSerializerContext ctx = this.createContext(UrlEncodingSerializerContext.class);

    public UrlEncodingSerializer(PropertyStore propertyStore) {
        this(propertyStore, "application/x-www-form-urlencoded", new String[0]);
    }

    public UrlEncodingSerializer(PropertyStore propertyStore, String produces, String ... accept) {
        super(propertyStore.copy().append("UonSerializer.encodeChars", true), produces, accept);
    }

    @Override
    public UrlEncodingSerializerBuilder builder() {
        return new UrlEncodingSerializerBuilder(this.propertyStore);
    }

    private String serializePart(Object o, Boolean urlEncode, Boolean plainTextParams) {
        try {
            ClassMeta<Object> cm = this.getBeanContext().getClassMetaForObject(o);
            if (cm != null) {
                if (cm.isNumber() || cm.isBoolean()) {
                    return o.toString();
                }
                if (cm.isCharSequence()) {
                    boolean ptt;
                    String s = o.toString();
                    boolean bl = ptt = plainTextParams != null ? plainTextParams.booleanValue() : this.ctx.plainTextParams();
                    if (ptt || s.isEmpty() || !UonUtils.needsQuotes(s)) {
                        return urlEncode != false ? StringUtils.urlEncode(s) : s;
                    }
                }
            }
            StringWriter w = new StringWriter();
            UonSerializerSession s = new UonSerializerSession(this.ctx, urlEncode, this.createDefaultSessionArgs());
            s.serialize(w, o);
            return w.toString();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public WriterSerializerSession createSession(SerializerSessionArgs args) {
        return new UrlEncodingSerializerSession(this.ctx, null, args);
    }

    @Override
    public String serialize(PartType type, Object value) {
        switch (type) {
            case HEADER: {
                return this.serializePart(value, false, true);
            }
            case FORM_DATA: {
                return this.serializePart(value, false, null);
            }
            case PATH: {
                return this.serializePart(value, false, null);
            }
            case QUERY: {
                return this.serializePart(value, false, null);
            }
        }
        return this.toString(value);
    }

    public static class PlainText
    extends UrlEncodingSerializer {
        public PlainText(PropertyStore propertyStore) {
            super(propertyStore.copy().append("UonSerializer.paramFormat", "PLAINTEXT"));
        }
    }

    public static class Readable
    extends UrlEncodingSerializer {
        public Readable(PropertyStore propertyStore) {
            super(propertyStore.copy().append("Serializer.useWhitespace", true));
        }
    }

    public static class Expanded
    extends UrlEncodingSerializer {
        public Expanded(PropertyStore propertyStore) {
            super(propertyStore.copy().append("UrlEncoding.expandedParams", true));
        }
    }
}

