/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.io.Reader;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectList;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.AsciiSet;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.ParserPipe;
import org.apache.juneau.parser.ParserReader;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.parser.ReaderParserSession;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.uon.UonParserContext;
import org.apache.juneau.uon.UonReader;

public class UonParserSession
extends ReaderParserSession {
    private static final AsciiSet escapedChars = new AsciiSet("~'\u0001\u0002");
    private static final char AMP = '\u0001';
    private static final char EQ = '\u0002';
    private final boolean decodeChars;
    private static final AsciiSet endCharsParam = new AsciiSet("\u0001");
    private static final AsciiSet endCharsNormal = new AsciiSet(",)\u0001");

    protected UonParserSession(UonParserContext ctx, ParserSessionArgs args) {
        super(ctx, args);
        ObjectMap p = this.getProperties();
        this.decodeChars = p.isEmpty() ? ctx.decodeChars : p.getBoolean("UonParser.decodeChars", ctx.decodeChars);
    }

    protected UonParserSession(UonParserContext ctx, ParserSessionArgs args, boolean decodeChars) {
        super(ctx, args);
        this.decodeChars = decodeChars;
    }

    @Override
    protected <T> T doParse(ParserPipe pipe, ClassMeta<T> type) throws Exception {
        UonReader r = this.getUonReader(pipe, this.decodeChars);
        T o = this.parseAnything(type, r, this.getOuter(), true, null);
        this.validateEnd(r);
        return o;
    }

    @Override
    protected <K, V> Map<K, V> doParseIntoMap(ParserPipe pipe, Map<K, V> m, Type keyType, Type valueType) throws Exception {
        UonReader r = this.getUonReader(pipe, this.decodeChars);
        m = this.parseIntoMap(r, m, this.getClassMeta(keyType, new Type[0]), this.getClassMeta(valueType, new Type[0]), null);
        this.validateEnd(r);
        return m;
    }

    @Override
    protected <E> Collection<E> doParseIntoCollection(ParserPipe pipe, Collection<E> c, Type elementType) throws Exception {
        UonReader r = this.getUonReader(pipe, this.decodeChars);
        c = this.parseIntoCollection(r, c, this.getClassMeta(elementType, new Type[0]), false, null);
        this.validateEnd(r);
        return c;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T parseAnything(ClassMeta<T> eType, UonReader r, Object outer, boolean isUrlParamValue, BeanPropertyMeta pMeta) throws Exception {
        PojoSwap<Object, Object> swap;
        if (eType == null) {
            eType = this.object();
        }
        ClassMeta<Object> sType = (swap = eType.getPojoSwap(this)) == null ? eType : swap.getSwapClassMeta(this);
        Object o = null;
        int c = r.peekSkipWs();
        if (c == -1 || c == 1) {
            if (sType.isCollectionOrArray()) {
                o = sType.newInstance();
            } else if (sType.isString() || sType.isObject()) {
                o = "";
            } else if (sType.isPrimitive()) {
                o = sType.getPrimitiveDefault();
            }
        } else if (sType.isVoid()) {
            String string = this.parseString(r, isUrlParamValue);
            if (string != null) {
                throw new ParseException(this.loc(r), "Expected ''null'' for void value, but was ''{0}''.", string);
            }
        } else if (sType.isObject()) {
            if (c == 40) {
                ObjectMap objectMap = new ObjectMap(this);
                this.parseIntoMap(r, objectMap, this.string(), this.object(), pMeta);
                o = this.cast(objectMap, pMeta, eType);
            } else if (c == 64) {
                ObjectList objectList = new ObjectList(this);
                o = this.parseIntoCollection(r, objectList, sType, isUrlParamValue, pMeta);
            } else {
                String string = this.parseString(r, isUrlParamValue);
                if (c != 39) {
                    if ("true".equals(string) || "false".equals(string)) {
                        o = Boolean.valueOf(string);
                    } else if (!"null".equals(string)) {
                        o = StringUtils.isNumeric(string) ? StringUtils.parseNumber(string, Number.class) : string;
                    }
                } else {
                    o = string;
                }
            }
        } else if (sType.isBoolean()) {
            o = this.parseBoolean(r);
        } else if (sType.isCharSequence()) {
            o = this.parseString(r, isUrlParamValue);
        } else if (sType.isChar()) {
            String string = this.parseString(r, isUrlParamValue);
            o = string == null ? null : Character.valueOf(string.charAt(0));
        } else if (sType.isNumber()) {
            o = this.parseNumber(r, sType.getInnerClass());
        } else if (sType.isMap()) {
            Map<String, Object> map = sType.canCreateNewInstance(outer) ? (Map)sType.newInstance(outer) : new ObjectMap(this);
            o = this.parseIntoMap(r, map, sType.getKeyType(), sType.getValueType(), pMeta);
        } else if (sType.isCollection()) {
            if (c == 40) {
                ObjectMap objectMap = new ObjectMap(this);
                this.parseIntoMap(r, objectMap, this.string(), this.object(), pMeta);
                if (objectMap.containsKey(this.getBeanTypePropertyName(sType))) {
                    o = this.cast(objectMap, pMeta, eType);
                } else {
                    Collection<Object> l = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance(outer) : new ObjectList(this);
                    l.add(objectMap.cast(sType.getElementType()));
                    o = l;
                }
            } else {
                Collection<Object> collection = sType.canCreateNewInstance(outer) ? (Collection)sType.newInstance(outer) : new ObjectList(this);
                o = this.parseIntoCollection(r, collection, sType, isUrlParamValue, pMeta);
            }
        } else if (sType.canCreateNewBean(outer)) {
            BeanMap<Object> beanMap2 = this.newBeanMap(outer, sType.getInnerClass());
            beanMap2 = this.parseIntoBeanMap(r, beanMap2);
            o = beanMap2 == null ? null : beanMap2.getBean();
        } else if (sType.canCreateNewInstanceFromString(outer)) {
            String string = this.parseString(r, isUrlParamValue);
            if (string != null) {
                o = sType.newInstanceFromString(outer, string);
            }
        } else if (sType.canCreateNewInstanceFromNumber(outer)) {
            o = sType.newInstanceFromNumber(this, outer, this.parseNumber(r, sType.getNewInstanceFromNumberClass()));
        } else if (sType.isArray() || sType.isArgs()) {
            if (c == 40) {
                ObjectMap objectMap = new ObjectMap(this);
                this.parseIntoMap(r, objectMap, this.string(), this.object(), pMeta);
                if (objectMap.containsKey(this.getBeanTypePropertyName(sType))) {
                    o = this.cast(objectMap, pMeta, eType);
                } else {
                    ArrayList l = new ArrayList(1);
                    l.add(objectMap.cast(sType.getElementType()));
                    o = this.toArray(sType, l);
                }
            } else {
                ArrayList arrayList = (ArrayList)this.parseIntoCollection(r, new ArrayList(), sType, isUrlParamValue, pMeta);
                o = this.toArray(sType, arrayList);
            }
        } else if (c == 40) {
            ObjectMap objectMap = new ObjectMap(this);
            this.parseIntoMap(r, objectMap, this.string(), this.object(), pMeta);
            if (!objectMap.containsKey(this.getBeanTypePropertyName(sType))) throw new ParseException(this.loc(r), "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", sType.getInnerClass().getName(), sType.getNotABeanReason());
            o = this.cast(objectMap, pMeta, eType);
        } else {
            if (c != 110) throw new ParseException(this.loc(r), "Class ''{0}'' could not be instantiated.  Reason: ''{1}''", sType.getInnerClass().getName(), sType.getNotABeanReason());
            r.read();
            this.parseNull(r);
        }
        if (o == null && sType.isPrimitive()) {
            o = sType.getPrimitiveDefault();
        }
        if (swap != null && o != null) {
            o = swap.unswap(this, o, eType);
        }
        if (outer == null) return (T)o;
        UonParserSession.setParent(eType, o, outer);
        return (T)o;
    }

    private <K, V> Map<K, V> parseIntoMap(UonReader r, Map<K, V> m, ClassMeta<K> keyType, ClassMeta<V> valueType, BeanPropertyMeta pMeta) throws Exception {
        int c;
        if (keyType == null) {
            keyType = this.string();
        }
        if ((c = r.read()) == -1 || c == 1) {
            return null;
        }
        if (c == 110) {
            return (Map)this.parseNull(r);
        }
        if (c != 40) {
            throw new ParseException(this.loc(r), "Expected '(' at beginning of object.", new Object[0]);
        }
        boolean S1 = true;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        boolean isInEscape = false;
        int state = 1;
        Object currAttr = null;
        while (c != -1 && c != 1) {
            c = r.read();
            if (!isInEscape) {
                if (state == 1) {
                    if (c == 41) {
                        return m;
                    }
                    if (Character.isWhitespace(c)) {
                        UonParserSession.skipSpace(r);
                    } else {
                        r.unread();
                        Object attr = this.parseAttr(r, this.decodeChars);
                        currAttr = attr == null ? null : (Object)this.convertAttrToType(m, this.trim(attr.toString()), keyType);
                        state = 2;
                        c = 0;
                    }
                } else if (state == 2) {
                    if (c == 2 || c == 61) {
                        state = 3;
                    } else if (c == -1 || c == 44 || c == 41 || c == 1) {
                        if (currAttr == null) {
                            r.unread();
                            return null;
                        }
                        m.put(currAttr, null);
                        if (c == 41 || c == -1 || c == 1) {
                            return m;
                        }
                        state = 1;
                    }
                } else if (state == 3) {
                    V value;
                    if (c == -1 || c == 44 || c == 41 || c == 1) {
                        value = this.convertAttrToType(m, "", valueType);
                        m.put(currAttr, value);
                        if (c == -1 || c == 41 || c == 1) {
                            return m;
                        }
                        state = 1;
                    } else {
                        value = this.parseAnything(valueType, r.unread(), m, false, pMeta);
                        UonParserSession.setName(valueType, value, currAttr);
                        m.put(currAttr, value);
                        state = 4;
                        c = 0;
                    }
                } else if (state == 4) {
                    if (c == 44) {
                        state = 1;
                    } else if (c == 41 || c == -1 || c == 1) {
                        return m;
                    }
                }
            }
            isInEscape = UonParserSession.isInEscape(c, r, isInEscape);
        }
        if (state == 1) {
            throw new ParseException(this.loc(r), "Could not find attribute name on object.", new Object[0]);
        }
        if (state == 2) {
            throw new ParseException(this.loc(r), "Could not find '=' following attribute name on object.", new Object[0]);
        }
        if (state == 3) {
            throw new ParseException(this.loc(r), "Dangling '=' found in object entry", new Object[0]);
        }
        if (state == 4) {
            throw new ParseException(this.loc(r), "Could not find ')' marking end of object.", new Object[0]);
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <E> Collection<E> parseIntoCollection(UonReader r, Collection<E> l, ClassMeta<E> type, boolean isUrlParamValue, BeanPropertyMeta pMeta) throws Exception {
        boolean isInParens;
        int c = r.readSkipWs();
        if (c == -1 || c == 1) {
            return null;
        }
        if (c == 110) {
            return (Collection)this.parseNull(r);
        }
        int argIndex = 0;
        boolean bl = isInParens = c == 64;
        if (!isInParens) {
            if (!isUrlParamValue) throw new ParseException(this.loc(r), "Could not find '(' marking beginning of collection.", new Object[0]);
            r.unread();
        } else {
            r.read();
        }
        if (isInParens) {
            boolean S1 = true;
            int S2 = 2;
            int S3 = 3;
            int state = 1;
            while (c != -1 && c != 1) {
                c = r.read();
                if (state == 1 || state == 2) {
                    if (c == 41) {
                        if (state != 2) return l;
                        l.add(this.parseAnything(type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), r.unread(), l, false, pMeta));
                        r.read();
                        return l;
                    }
                    if (Character.isWhitespace(c)) {
                        UonParserSession.skipSpace(r);
                        continue;
                    }
                    l.add(this.parseAnything(type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), r.unread(), l, false, pMeta));
                    state = 3;
                    continue;
                }
                if (state != 3) continue;
                if (c == 44) {
                    state = 2;
                    continue;
                }
                if (c != 41) continue;
                return l;
            }
            if (state == 1 || state == 2) {
                throw new ParseException(this.loc(r), "Could not find start of entry in array.", new Object[0]);
            }
            if (state != 3) return null;
            throw new ParseException(this.loc(r), "Could not find end of entry in array.", new Object[0]);
        }
        boolean S1 = true;
        int S2 = 2;
        int state = 1;
        while (c != -1 && c != 1) {
            c = r.read();
            if (state == 1) {
                if (Character.isWhitespace(c)) {
                    UonParserSession.skipSpace(r);
                    continue;
                }
                l.add(this.parseAnything(type.isArgs() ? type.getArg(argIndex++) : type.getElementType(), r.unread(), l, false, pMeta));
                state = 2;
                continue;
            }
            if (state != 2) continue;
            if (c == 44) {
                state = 1;
                continue;
            }
            if (Character.isWhitespace(c)) {
                UonParserSession.skipSpace(r);
                continue;
            }
            if (c != 1 && c != -1) continue;
            r.unread();
            return l;
        }
        return null;
    }

    private <T> BeanMap<T> parseIntoBeanMap(UonReader r, BeanMap<T> m) throws Exception {
        int c = r.readSkipWs();
        if (c == -1 || c == 1) {
            return null;
        }
        if (c == 110) {
            return (BeanMap)this.parseNull(r);
        }
        if (c != 40) {
            throw new ParseException(this.loc(r), "Expected '(' at beginning of object.", new Object[0]);
        }
        boolean S1 = true;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        boolean isInEscape = false;
        int state = 1;
        String currAttr = "";
        int currAttrLine = -1;
        int currAttrCol = -1;
        while (c != -1 && c != 1) {
            c = r.read();
            if (!isInEscape) {
                if (state == 1) {
                    if (c == 41 || c == -1 || c == 1) {
                        return m;
                    }
                    if (Character.isWhitespace(c)) {
                        UonParserSession.skipSpace(r);
                    } else {
                        r.unread();
                        currAttrLine = r.getLine();
                        currAttrCol = r.getColumn();
                        currAttr = this.parseAttrName(r, this.decodeChars);
                        if (currAttr == null) {
                            return null;
                        }
                        state = 2;
                    }
                } else if (state == 2) {
                    if (c == 2 || c == 61) {
                        state = 3;
                    } else if (c == -1 || c == 44 || c == 41 || c == 1) {
                        m.put(currAttr, (Object)null);
                        if (c == 41 || c == -1 || c == 1) {
                            return m;
                        }
                        state = 1;
                    }
                } else if (state == 3) {
                    BeanPropertyMeta pMeta;
                    if (c == -1 || c == 44 || c == 41 || c == 1) {
                        if (!currAttr.equals(this.getBeanTypePropertyName(m.getClassMeta()))) {
                            pMeta = m.getPropertyMeta(currAttr);
                            if (pMeta == null) {
                                this.onUnknownProperty(r.getPipe(), currAttr, m, currAttrLine, currAttrCol);
                            } else {
                                Object value = this.convertToType((Object)"", pMeta.getClassMeta());
                                pMeta.set(m, currAttr, value);
                            }
                        }
                        if (c == -1 || c == 41 || c == 1) {
                            return m;
                        }
                        state = 1;
                    } else {
                        if (!currAttr.equals(this.getBeanTypePropertyName(m.getClassMeta()))) {
                            pMeta = m.getPropertyMeta(currAttr);
                            if (pMeta == null) {
                                this.onUnknownProperty(r.getPipe(), currAttr, m, currAttrLine, currAttrCol);
                                this.parseAnything(this.object(), r.unread(), m.getBean(false), false, null);
                            } else {
                                this.setCurrentProperty(pMeta);
                                ClassMeta<?> cm = pMeta.getClassMeta();
                                Object value = this.parseAnything(cm, r.unread(), m.getBean(false), false, pMeta);
                                UonParserSession.setName(cm, value, currAttr);
                                pMeta.set(m, currAttr, value);
                                this.setCurrentProperty(null);
                            }
                        }
                        state = 4;
                    }
                } else if (state == 4) {
                    if (c == 44) {
                        state = 1;
                    } else if (c == 41 || c == -1 || c == 1) {
                        return m;
                    }
                }
            }
            isInEscape = UonParserSession.isInEscape(c, r, isInEscape);
        }
        if (state == 1) {
            throw new ParseException(this.loc(r), "Could not find attribute name on object.", new Object[0]);
        }
        if (state == 2) {
            throw new ParseException(this.loc(r), "Could not find '=' following attribute name on object.", new Object[0]);
        }
        if (state == 3) {
            throw new ParseException(this.loc(r), "Could not find value following '=' on object.", new Object[0]);
        }
        if (state == 4) {
            throw new ParseException(this.loc(r), "Could not find ')' marking end of object.", new Object[0]);
        }
        return null;
    }

    private Object parseNull(UonReader r) throws Exception {
        String s = this.parseString(r, false);
        if ("ull".equals(s)) {
            return null;
        }
        throw new ParseException(this.loc(r), "Unexpected character sequence: ''{0}''", s);
    }

    protected final Object parseAttr(UonReader r, boolean encoded) throws Exception {
        String attr = this.parseAttrName(r, encoded);
        return attr;
    }

    protected final String parseAttrName(UonReader r, boolean encoded) throws Exception {
        int c = r.peekSkipWs();
        if (c == 39) {
            return this.parsePString(r);
        }
        r.mark();
        boolean isInEscape = false;
        if (encoded) {
            while (c != -1) {
                c = r.read();
                if (!isInEscape) {
                    if (c == 1 || c == 2 || c == -1 || Character.isWhitespace(c)) {
                        String s;
                        if (c != -1) {
                            r.unread();
                        }
                        return "null".equals(s = r.getMarked()) ? null : s;
                    }
                } else if (c == 1) {
                    r.replace('&');
                } else if (c == 2) {
                    r.replace('=');
                }
                isInEscape = UonParserSession.isInEscape(c, r, isInEscape);
            }
        } else {
            while (c != -1) {
                c = r.read();
                if (!isInEscape && (c == 61 || c == -1 || Character.isWhitespace(c))) {
                    String s;
                    if (c != -1) {
                        r.unread();
                    }
                    return "null".equals(s = r.getMarked()) ? null : this.trim(s);
                }
                isInEscape = UonParserSession.isInEscape(c, r, isInEscape);
            }
        }
        throw new ParseException(this.loc(r), "Unexpected condition.", new Object[0]);
    }

    private static final boolean isInEscape(int c, ParserReader r, boolean prevIsInEscape) throws Exception {
        if (c == 126 && !prevIsInEscape && escapedChars.contains(c = r.peek())) {
            r.delete();
            return true;
        }
        return false;
    }

    protected final String parseString(UonReader r, boolean isUrlParamValue) throws Exception {
        AsciiSet endChars;
        int c = r.peekSkipWs();
        if (c == 39) {
            return this.parsePString(r);
        }
        r.mark();
        boolean isInEscape = false;
        String s = null;
        AsciiSet asciiSet = endChars = isUrlParamValue ? endCharsParam : endCharsNormal;
        while (c != -1) {
            c = r.read();
            if (!isInEscape && endChars.contains(c)) {
                r.unread();
                c = -1;
            }
            if (c == -1) {
                s = r.getMarked();
            } else if (c == 2) {
                r.replace('=');
            } else if (Character.isWhitespace(c) && !isUrlParamValue) {
                s = r.getMarked(0, -1);
                UonParserSession.skipSpace(r);
                c = -1;
            }
            isInEscape = UonParserSession.isInEscape(c, r, isInEscape);
        }
        if (isUrlParamValue) {
            s = StringUtils.trim(s);
        }
        return "null".equals(s) ? null : this.trim(s);
    }

    private String parsePString(UonReader r) throws Exception {
        r.read();
        r.mark();
        int c = 0;
        boolean isInEscape = false;
        while (c != -1) {
            c = r.read();
            if (!isInEscape && c == 39) {
                return this.trim(r.getMarked(0, -1));
            }
            if (c == 2) {
                r.replace('=');
            }
            isInEscape = UonParserSession.isInEscape(c, r, isInEscape);
        }
        throw new ParseException(this.loc(r), "Unmatched parenthesis", new Object[0]);
    }

    private Boolean parseBoolean(UonReader r) throws Exception {
        String s = this.parseString(r, false);
        if (s == null || s.equals("null")) {
            return null;
        }
        if (s.equals("true")) {
            return true;
        }
        if (s.equals("false")) {
            return false;
        }
        throw new ParseException(this.loc(r), "Unrecognized syntax for boolean.  ''{0}''.", s);
    }

    private Number parseNumber(UonReader r, Class<? extends Number> c) throws Exception {
        String s = this.parseString(r, false);
        if (s == null) {
            return null;
        }
        return StringUtils.parseNumber(s, c);
    }

    private void validateEnd(UonReader r) throws Exception {
        int c;
        do {
            if ((c = r.read()) != -1) continue;
            return;
        } while (Character.isWhitespace(c));
        throw new ParseException(this.loc(r), "Remainder after parse: ''{0}''.", Character.valueOf((char)c));
    }

    private static void skipSpace(ParserReader r) throws Exception {
        int c = 0;
        while ((c = r.read()) != -1) {
            if (c > 2 && Character.isWhitespace(c)) continue;
            r.unread();
            return;
        }
    }

    protected final ObjectMap loc(UonReader r) {
        return this.getLastLocation().append("line", r.getLine()).append("column", r.getColumn());
    }

    public final UonReader getUonReader(ParserPipe pipe, boolean decodeChars) throws Exception {
        Reader r = pipe.getReader();
        if (r instanceof UonReader) {
            return (UonReader)r;
        }
        return new UonReader(pipe, decodeChars);
    }
}

