/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.soap;

import java.util.Map;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.soap.SoapXmlSerializerContext;
import org.apache.juneau.utils.AMap;
import org.apache.juneau.xml.XmlSerializerSession;
import org.apache.juneau.xml.XmlWriter;

public class SoapXmlSerializerSession
extends XmlSerializerSession {
    public SoapXmlSerializerSession(SoapXmlSerializerContext ctx, SerializerSessionArgs args) {
        super(ctx, args);
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws Exception {
        XmlWriter w = this.getXmlWriter(out);
        w.append("<?xml").attr("version", "1.0").attr("encoding", "UTF-8").appendln("?>");
        w.oTag("soap", "Envelope").attr("xmlns", "soap", (Object)this.getStringProperty("SoapXmlSerializer.SOAPAction", "http://www.w3.org/2003/05/soap-envelope")).appendln(">");
        w.sTag(1, "soap", "Body").nl(1);
        this.indent += 2;
        w.flush();
        super.doSerialize(out, o);
        w.ie(1).eTag("soap", "Body").nl(1);
        w.eTag("soap", "Envelope").nl(0);
    }

    @Override
    public Map<String, String> getResponseHeaders() {
        return new AMap<String, String>().append("SOAPAction", this.getStringProperty("SoapXmlSerializer.SOAPAction", "http://www.w3.org/2003/05/soap-envelope"));
    }
}

