/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.response;

import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletOutputStream;
import org.apache.juneau.rest.ResponseHandler;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.utils.ZipFileList;

public class ZipFileListResponseHandler
implements ResponseHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean handle(RestRequest req, RestResponse res, Object output) throws IOException, RestException {
        if (output.getClass() == ZipFileList.class) {
            ZipFileList m = (ZipFileList)output;
            res.setContentType("application/zip");
            res.setHeader("Content-Disposition", "attachment;filename=" + m.fileName);
            ServletOutputStream os = res.getOutputStream();
            try {
                ZipOutputStream zos = new ZipOutputStream((OutputStream)os);
                try {
                    for (ZipFileList.ZipFileEntry e : m) {
                        e.write(zos);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                finally {
                    zos.flush();
                    zos.close();
                }
            }
            finally {
                os.flush();
            }
            return true;
        }
        return false;
    }
}

