/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import org.apache.http.Header;
import org.apache.http.entity.BasicHttpEntity;
import org.apache.http.message.BasicHeader;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.rest.client.RestCallException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.serializer.SerializerSession;
import org.apache.juneau.utils.IOPipe;

public final class RestRequestEntity
extends BasicHttpEntity {
    final Object output;
    final Serializer serializer;
    byte[] outputBytes;

    public RestRequestEntity(Object input, Serializer serializer) {
        this.output = input;
        this.serializer = serializer;
        if (serializer != null && serializer.getResponseContentType() != null) {
            this.setContentType((Header)new BasicHeader("Content-Type", serializer.getResponseContentType().toString()));
        }
    }

    public void writeTo(OutputStream os) throws IOException {
        if (this.output instanceof InputStream) {
            IOPipe.create(this.output, os).closeOut().run();
        } else if (this.output instanceof Reader) {
            IOPipe.create(this.output, new OutputStreamWriter(os, IOUtils.UTF8)).closeOut().run();
        } else {
            try {
                if (this.serializer == null) {
                    os.close();
                } else {
                    SerializerSession session = this.serializer.createSession();
                    if (session.isWriterSerializer()) {
                        OutputStreamWriter w = new OutputStreamWriter(os, IOUtils.UTF8);
                        session.serialize(w, this.output);
                        ((Writer)w).flush();
                        ((Writer)w).close();
                    } else {
                        session.serialize(os, this.output);
                        os.flush();
                        os.close();
                    }
                }
            }
            catch (SerializeException e) {
                throw new RestCallException(e);
            }
        }
    }

    public boolean isRepeatable() {
        return true;
    }

    public InputStream getContent() {
        if (this.outputBytes == null) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            try {
                this.writeTo(baos);
                this.outputBytes = baos.toByteArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return new ByteArrayInputStream(this.outputBytes);
    }
}

