/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.juneau.rest.CallMethod;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServletException;

class CallRouter {
    private final CallMethod[] callMethods;

    private CallRouter(CallMethod[] callMethods) {
        this.callMethods = callMethods;
    }

    int invoke(String pathInfo, RestRequest req, RestResponse res) throws RestException {
        if (this.callMethods.length == 1) {
            return this.callMethods[0].invoke(pathInfo, req, res);
        }
        int maxRc = 0;
        for (CallMethod m : this.callMethods) {
            int rc = m.invoke(pathInfo, req, res);
            if (rc == 200) {
                return 200;
            }
            maxRc = Math.max(maxRc, rc);
        }
        return maxRc;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CallRouter: [\n");
        for (CallMethod sm : this.callMethods) {
            sb.append("\t" + sm + "\n");
        }
        sb.append("]");
        return sb.toString();
    }

    static class Builder {
        private List<CallMethod> childMethods = new ArrayList<CallMethod>();
        private Set<String> collisions = new HashSet<String>();
        private String httpMethodName;

        Builder(String httpMethodName) {
            this.httpMethodName = httpMethodName;
        }

        String getHttpMethodName() {
            return this.httpMethodName;
        }

        Builder add(CallMethod m) throws RestServletException {
            if (!m.hasGuardsOrMatchers()) {
                String p = m.getHttpMethod() + ":" + m.getPathPattern();
                if (this.collisions.contains(p)) {
                    throw new RestServletException("Duplicate Java methods assigned to the same method/pattern:  ''{0}''", p);
                }
                this.collisions.add(p);
            }
            this.childMethods.add(m);
            return this;
        }

        CallRouter build() {
            Collections.sort(this.childMethods);
            return new CallRouter(this.childMethods.toArray(new CallMethod[this.childMethods.size()]));
        }
    }
}

