/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.ini;

public class ConfigUtils {
    static final String getSectionName(String key) {
        int i = key.indexOf(47);
        if (i == -1) {
            return "default";
        }
        return key.substring(0, i);
    }

    static final String getSectionKey(String key) {
        int i = key.indexOf(47);
        if (i == -1) {
            return key;
        }
        return key.substring(i + 1);
    }

    static final String getFullKey(String section, String key) {
        if (section.equals("default")) {
            return key;
        }
        return section + '/' + key;
    }

    static final boolean isComment(String line) {
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (Character.isWhitespace(c)) continue;
            return c == '#';
        }
        return false;
    }

    static final boolean isAssignment(String line) {
        int S1 = 1;
        int S2 = 2;
        int S3 = 3;
        int state = S1;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (state == S1) {
                if (Character.isWhitespace(c)) continue;
                state = S2;
                continue;
            }
            if (state == S2) {
                if (c == '=') {
                    return true;
                }
                if (!Character.isWhitespace(c)) continue;
                state = S3;
                continue;
            }
            if (state != S3 || c != '=') continue;
            return true;
        }
        return false;
    }

    static final boolean isSection(String line) {
        int S1 = 1;
        int S2 = 2;
        int state = S1;
        for (int i = 0; i < line.length(); ++i) {
            char c = line.charAt(i);
            if (state == S1) {
                if (Character.isWhitespace(c)) continue;
                if (c == '[') {
                    state = S2;
                    continue;
                }
                return false;
            }
            if (state != S2 || c != ']') continue;
            return true;
        }
        return false;
    }
}

