/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.dto.jsonschema;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import org.apache.juneau.dto.jsonschema.JsonType;
import org.apache.juneau.dto.jsonschema.Schema;
import org.apache.juneau.dto.jsonschema.SchemaMap;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.json.JsonParser;

class Sample {
    Sample() {
    }

    public static void main(String[] args) {
        SchemaMap schemaMap = new SchemaMap(){

            @Override
            public Schema load(URI uri) {
                Reader r = null;
                try {
                    Schema s;
                    r = new InputStreamReader(uri.toURL().openStream(), IOUtils.UTF8);
                    Schema schema = s = JsonParser.DEFAULT.parse((Object)r, Schema.class);
                    return schema;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
                finally {
                    if (r != null) {
                        try {
                            r.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        };
        Schema purchaseOrderSchema = schemaMap.get("http://www.apache.org/purchase-order/PurchaseOrder#");
        JsonType streetType = purchaseOrderSchema.getProperty("address", true).getProperty("street").getTypeAsJsonType();
        System.err.println("streetType=" + (Object)((Object)streetType));
        JsonType productIdType = ((Schema)purchaseOrderSchema.getProperty("product").getItemsAsSchemaArray().get(0)).resolve().getProperty("productId").getTypeAsJsonType();
        System.err.println("productIdType=" + (Object)((Object)productIdType));
    }
}

