/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau;

import org.apache.juneau.ClassMeta;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.json.JsonSerializer;

public final class InvalidDataConversionException
extends FormattedRuntimeException {
    private static final long serialVersionUID = 1L;

    public InvalidDataConversionException(Object value, Class<?> toType, Exception cause) {
        super(cause, "Invalid data conversion from type ''{0}'' to type ''{1}''.  Value={2}.", ClassUtils.getReadableClassNameForObject(value), ClassUtils.getReadableClassName(toType), InvalidDataConversionException.getValue(value));
    }

    public InvalidDataConversionException(Object value, ClassMeta<?> toType, Exception cause) {
        super(cause, "Invalid data conversion from type ''{0}'' to type ''{1}''.  Value={2}.", ClassUtils.getReadableClassNameForObject(value), toType.toString(), InvalidDataConversionException.getValue(value));
    }

    private static String getValue(Object o) {
        if (o instanceof Class) {
            return "'" + ClassUtils.getReadableClassName((Class)o) + "'";
        }
        return JsonSerializer.DEFAULT_LAX == null ? "'" + o.toString() + "'" : JsonSerializer.DEFAULT_LAX.toString(o);
    }
}

