/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.svl.vars;

import java.util.regex.Pattern;
import org.apache.juneau.internal.ThrowableUtils;
import org.apache.juneau.svl.MultipartVar;
import org.apache.juneau.svl.VarResolverSession;

public class SwitchVar
extends MultipartVar {
    public static final String NAME = "SW";

    public SwitchVar() {
        super(NAME);
    }

    @Override
    public String resolve(VarResolverSession session, String[] args) {
        if (args.length < 3) {
            ThrowableUtils.illegalArg((String)"Invalid number of arguments passed to $SW var.  Must have 3 or more arguments.", (Object[])new Object[0]);
        }
        String stringArg = args[0];
        for (int i = 1; i < args.length; ++i) {
            String pattern = args[i++];
            if (args.length == i) {
                return pattern;
            }
            Pattern p = Pattern.compile(pattern.replace("*", ".*").replace("?", "."));
            if (!p.matcher(stringArg).matches()) continue;
            return args[i];
        }
        return "";
    }
}

