/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriRelativity;
import org.apache.juneau.UriResolution;
import org.apache.juneau.Visibility;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfSerializer;
import org.apache.juneau.serializer.SerializerBuilder;
import org.apache.juneau.serializer.SerializerListener;
import org.apache.juneau.xml.Namespace;

public class RdfSerializerBuilder
extends SerializerBuilder {
    public RdfSerializerBuilder() {
    }

    public RdfSerializerBuilder(PropertyStore propertyStore) {
        super(propertyStore);
    }

    public RdfSerializer build() {
        return new RdfSerializer(this.propertyStore, "text/xml+rdf", new String[0]);
    }

    public RdfSerializerBuilder language(String value) {
        return this.property("Rdf.language", value);
    }

    public RdfSerializerBuilder xml() {
        return this.language("RDF/XML");
    }

    public RdfSerializerBuilder xmlabbrev() {
        return this.language("RDF/XML-ABBREV");
    }

    public RdfSerializerBuilder ntriple() {
        return this.language("N-TRIPLE");
    }

    public RdfSerializerBuilder n3() {
        return this.language("N3");
    }

    public RdfSerializerBuilder turtle() {
        return this.language("TURTLE");
    }

    public RdfSerializerBuilder juneauNs(Namespace value) {
        return this.property("Rdf.juneauNs", value);
    }

    public RdfSerializerBuilder juneauBpNs(Namespace value) {
        return this.property("Rdf.juneauBpNs", value);
    }

    public RdfSerializerBuilder useXmlNamespaces(boolean value) {
        return this.property("Rdf.useXmlNamespaces", value);
    }

    public RdfSerializerBuilder addLiteralTypes(boolean value) {
        return this.property("RdfSerializer.addLiteralTypes", value);
    }

    public RdfSerializerBuilder addRootProperty(boolean value) {
        return this.property("RdfSerializer.addRootProperty", value);
    }

    public RdfSerializerBuilder autoDetectNamespaces(boolean value) {
        return this.property("RdfSerializer.autoDetectNamespaces", value);
    }

    public RdfSerializerBuilder namespaces(Namespace ... values) {
        return this.property("RdfSerializer.namespaces.list", values);
    }

    public RdfSerializerBuilder collectionFormat(RdfCollectionFormat value) {
        return this.property("Rdf.collectionFormat", (Object)value);
    }

    public RdfSerializerBuilder looseCollections(boolean value) {
        return this.property("Rdf.looseCollections", value);
    }

    public RdfSerializerBuilder maxDepth(int value) {
        super.maxDepth(value);
        return this;
    }

    public RdfSerializerBuilder initialDepth(int value) {
        super.initialDepth(value);
        return this;
    }

    public RdfSerializerBuilder detectRecursions(boolean value) {
        super.detectRecursions(value);
        return this;
    }

    public RdfSerializerBuilder ignoreRecursions(boolean value) {
        super.ignoreRecursions(value);
        return this;
    }

    public RdfSerializerBuilder useWhitespace(boolean value) {
        super.useWhitespace(value);
        return this;
    }

    public RdfSerializerBuilder ws() {
        super.ws();
        return this;
    }

    public RdfSerializerBuilder addBeanTypeProperties(boolean value) {
        super.addBeanTypeProperties(value);
        return this;
    }

    public RdfSerializerBuilder quoteChar(char value) {
        super.quoteChar(value);
        return this;
    }

    public RdfSerializerBuilder sq() {
        super.sq();
        return this;
    }

    public RdfSerializerBuilder trimNullProperties(boolean value) {
        super.trimNullProperties(value);
        return this;
    }

    public RdfSerializerBuilder trimEmptyCollections(boolean value) {
        super.trimEmptyCollections(value);
        return this;
    }

    public RdfSerializerBuilder trimEmptyMaps(boolean value) {
        super.trimEmptyMaps(value);
        return this;
    }

    public RdfSerializerBuilder trimStrings(boolean value) {
        super.trimStrings(value);
        return this;
    }

    public RdfSerializerBuilder uriContext(UriContext value) {
        super.uriContext(value);
        return this;
    }

    public RdfSerializerBuilder uriResolution(UriResolution value) {
        super.uriResolution(value);
        return this;
    }

    public RdfSerializerBuilder uriRelativity(UriRelativity value) {
        super.uriRelativity(value);
        return this;
    }

    public RdfSerializerBuilder sortCollections(boolean value) {
        super.sortCollections(value);
        return this;
    }

    public RdfSerializerBuilder sortMaps(boolean value) {
        super.sortMaps(value);
        return this;
    }

    public RdfSerializerBuilder abridged(boolean value) {
        super.abridged(value);
        return this;
    }

    public RdfSerializerBuilder listener(Class<? extends SerializerListener> value) {
        super.listener(value);
        return this;
    }

    public RdfSerializerBuilder beansRequireDefaultConstructor(boolean value) {
        super.beansRequireDefaultConstructor(value);
        return this;
    }

    public RdfSerializerBuilder beansRequireSerializable(boolean value) {
        super.beansRequireSerializable(value);
        return this;
    }

    public RdfSerializerBuilder beansRequireSettersForGetters(boolean value) {
        super.beansRequireSettersForGetters(value);
        return this;
    }

    public RdfSerializerBuilder beansRequireSomeProperties(boolean value) {
        super.beansRequireSomeProperties(value);
        return this;
    }

    public RdfSerializerBuilder beanMapPutReturnsOldValue(boolean value) {
        super.beanMapPutReturnsOldValue(value);
        return this;
    }

    public RdfSerializerBuilder beanConstructorVisibility(Visibility value) {
        super.beanConstructorVisibility(value);
        return this;
    }

    public RdfSerializerBuilder beanClassVisibility(Visibility value) {
        super.beanClassVisibility(value);
        return this;
    }

    public RdfSerializerBuilder beanFieldVisibility(Visibility value) {
        super.beanFieldVisibility(value);
        return this;
    }

    public RdfSerializerBuilder methodVisibility(Visibility value) {
        super.methodVisibility(value);
        return this;
    }

    public RdfSerializerBuilder useJavaBeanIntrospector(boolean value) {
        super.useJavaBeanIntrospector(value);
        return this;
    }

    public RdfSerializerBuilder useInterfaceProxies(boolean value) {
        super.useInterfaceProxies(value);
        return this;
    }

    public RdfSerializerBuilder ignoreUnknownBeanProperties(boolean value) {
        super.ignoreUnknownBeanProperties(value);
        return this;
    }

    public RdfSerializerBuilder ignoreUnknownNullBeanProperties(boolean value) {
        super.ignoreUnknownNullBeanProperties(value);
        return this;
    }

    public RdfSerializerBuilder ignorePropertiesWithoutSetters(boolean value) {
        super.ignorePropertiesWithoutSetters(value);
        return this;
    }

    public RdfSerializerBuilder ignoreInvocationExceptionsOnGetters(boolean value) {
        super.ignoreInvocationExceptionsOnGetters(value);
        return this;
    }

    public RdfSerializerBuilder ignoreInvocationExceptionsOnSetters(boolean value) {
        super.ignoreInvocationExceptionsOnSetters(value);
        return this;
    }

    public RdfSerializerBuilder sortProperties(boolean value) {
        super.sortProperties(value);
        return this;
    }

    public RdfSerializerBuilder notBeanPackages(String ... values) {
        super.notBeanPackages(values);
        return this;
    }

    public RdfSerializerBuilder notBeanPackages(Collection<String> values) {
        super.notBeanPackages(values);
        return this;
    }

    public RdfSerializerBuilder setNotBeanPackages(String ... values) {
        super.setNotBeanPackages(values);
        return this;
    }

    public RdfSerializerBuilder setNotBeanPackages(Collection<String> values) {
        super.setNotBeanPackages(values);
        return this;
    }

    public RdfSerializerBuilder removeNotBeanPackages(String ... values) {
        super.removeNotBeanPackages(values);
        return this;
    }

    public RdfSerializerBuilder removeNotBeanPackages(Collection<String> values) {
        super.removeNotBeanPackages(values);
        return this;
    }

    public RdfSerializerBuilder notBeanClasses(Class<?> ... values) {
        super.notBeanClasses((Class[])values);
        return this;
    }

    public RdfSerializerBuilder notBeanClasses(Collection<Class<?>> values) {
        super.notBeanClasses(values);
        return this;
    }

    public RdfSerializerBuilder setNotBeanClasses(Class<?> ... values) {
        super.setNotBeanClasses((Class[])values);
        return this;
    }

    public RdfSerializerBuilder setNotBeanClasses(Collection<Class<?>> values) {
        super.setNotBeanClasses(values);
        return this;
    }

    public RdfSerializerBuilder removeNotBeanClasses(Class<?> ... values) {
        super.removeNotBeanClasses((Class[])values);
        return this;
    }

    public RdfSerializerBuilder removeNotBeanClasses(Collection<Class<?>> values) {
        super.removeNotBeanClasses(values);
        return this;
    }

    public RdfSerializerBuilder beanFilters(Class<?> ... values) {
        super.beanFilters((Class[])values);
        return this;
    }

    public RdfSerializerBuilder beanFilters(Collection<Class<?>> values) {
        super.beanFilters(values);
        return this;
    }

    public RdfSerializerBuilder setBeanFilters(Class<?> ... values) {
        super.setBeanFilters((Class[])values);
        return this;
    }

    public RdfSerializerBuilder setBeanFilters(Collection<Class<?>> values) {
        super.setBeanFilters(values);
        return this;
    }

    public RdfSerializerBuilder removeBeanFilters(Class<?> ... values) {
        super.removeBeanFilters((Class[])values);
        return this;
    }

    public RdfSerializerBuilder removeBeanFilters(Collection<Class<?>> values) {
        super.removeBeanFilters(values);
        return this;
    }

    public RdfSerializerBuilder pojoSwaps(Class<?> ... values) {
        super.pojoSwaps((Class[])values);
        return this;
    }

    public RdfSerializerBuilder pojoSwaps(Collection<Class<?>> values) {
        super.pojoSwaps(values);
        return this;
    }

    public RdfSerializerBuilder setPojoSwaps(Class<?> ... values) {
        super.setPojoSwaps((Class[])values);
        return this;
    }

    public RdfSerializerBuilder setPojoSwaps(Collection<Class<?>> values) {
        super.setPojoSwaps(values);
        return this;
    }

    public RdfSerializerBuilder removePojoSwaps(Class<?> ... values) {
        super.removePojoSwaps((Class[])values);
        return this;
    }

    public RdfSerializerBuilder removePojoSwaps(Collection<Class<?>> values) {
        super.removePojoSwaps(values);
        return this;
    }

    public RdfSerializerBuilder implClasses(Map<Class<?>, Class<?>> values) {
        super.implClasses(values);
        return this;
    }

    public <T> RdfSerializerBuilder implClass(Class<T> interfaceClass, Class<? extends T> implClass) {
        super.implClass(interfaceClass, implClass);
        return this;
    }

    public RdfSerializerBuilder includeProperties(Map<String, String> values) {
        super.includeProperties(values);
        return this;
    }

    public RdfSerializerBuilder includeProperties(String beanClassName, String properties) {
        super.includeProperties(beanClassName, properties);
        return this;
    }

    public RdfSerializerBuilder includeProperties(Class<?> beanClass, String properties) {
        super.includeProperties(beanClass, properties);
        return this;
    }

    public RdfSerializerBuilder excludeProperties(Map<String, String> values) {
        super.excludeProperties(values);
        return this;
    }

    public RdfSerializerBuilder excludeProperties(String beanClassName, String properties) {
        super.excludeProperties(beanClassName, properties);
        return this;
    }

    public RdfSerializerBuilder excludeProperties(Class<?> beanClass, String properties) {
        super.excludeProperties(beanClass, properties);
        return this;
    }

    public RdfSerializerBuilder beanDictionary(Class<?> ... values) {
        super.beanDictionary((Class[])values);
        return this;
    }

    public RdfSerializerBuilder beanDictionary(Collection<Class<?>> values) {
        super.beanDictionary(values);
        return this;
    }

    public RdfSerializerBuilder setBeanDictionary(Class<?> ... values) {
        super.setBeanDictionary((Class[])values);
        return this;
    }

    public RdfSerializerBuilder setBeanDictionary(Collection<Class<?>> values) {
        super.setBeanDictionary(values);
        return this;
    }

    public RdfSerializerBuilder removeFromBeanDictionary(Class<?> ... values) {
        super.removeFromBeanDictionary((Class[])values);
        return this;
    }

    public RdfSerializerBuilder removeFromBeanDictionary(Collection<Class<?>> values) {
        super.removeFromBeanDictionary(values);
        return this;
    }

    public RdfSerializerBuilder beanTypePropertyName(String value) {
        super.beanTypePropertyName(value);
        return this;
    }

    public RdfSerializerBuilder defaultParser(Class<?> value) {
        super.defaultParser(value);
        return this;
    }

    public RdfSerializerBuilder locale(Locale value) {
        super.locale(value);
        return this;
    }

    public RdfSerializerBuilder timeZone(TimeZone value) {
        super.timeZone(value);
        return this;
    }

    public RdfSerializerBuilder mediaType(MediaType value) {
        super.mediaType(value);
        return this;
    }

    public RdfSerializerBuilder debug() {
        super.debug();
        return this;
    }

    public RdfSerializerBuilder property(String name, Object value) {
        super.property(name, value);
        return this;
    }

    public RdfSerializerBuilder properties(Map<String, Object> properties) {
        super.properties(properties);
        return this;
    }

    public RdfSerializerBuilder addToProperty(String name, Object value) {
        super.addToProperty(name, value);
        return this;
    }

    public RdfSerializerBuilder putToProperty(String name, Object key, Object value) {
        super.putToProperty(name, key, value);
        return this;
    }

    public RdfSerializerBuilder putToProperty(String name, Object value) {
        super.putToProperty(name, value);
        return this;
    }

    public RdfSerializerBuilder removeFromProperty(String name, Object value) {
        super.removeFromProperty(name, value);
        return this;
    }

    public RdfSerializerBuilder classLoader(ClassLoader classLoader) {
        super.classLoader(classLoader);
        return this;
    }

    public RdfSerializerBuilder apply(PropertyStore copyFrom) {
        super.apply(copyFrom);
        return this;
    }
}

