/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import org.apache.juneau.PropertyStore;
import org.apache.juneau.jena.RdfSerializerBuilder;
import org.apache.juneau.jena.RdfSerializerContext;
import org.apache.juneau.jena.RdfSerializerSession;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializer;
import org.apache.juneau.serializer.WriterSerializerSession;

public class RdfSerializer
extends WriterSerializer {
    public static final RdfSerializer DEFAULT_XML = new Xml(PropertyStore.create());
    public static final RdfSerializer DEFAULT_XMLABBREV = new XmlAbbrev(PropertyStore.create());
    public static final RdfSerializer DEFAULT_TURTLE = new Turtle(PropertyStore.create());
    public static final RdfSerializer DEFAULT_NTRIPLE = new NTriple(PropertyStore.create());
    public static final RdfSerializer DEFAULT_N3 = new N3(PropertyStore.create());
    private final RdfSerializerContext ctx = (RdfSerializerContext)this.createContext(RdfSerializerContext.class);

    public RdfSerializer(PropertyStore propertyStore, String produces, String ... accept) {
        super(propertyStore, produces, accept);
    }

    public RdfSerializerBuilder builder() {
        return new RdfSerializerBuilder(this.propertyStore);
    }

    public WriterSerializerSession createSession(SerializerSessionArgs args) {
        return new RdfSerializerSession(this.ctx, args);
    }

    public static class N3
    extends RdfSerializer {
        public N3(PropertyStore propertyStore) {
            super(propertyStore.copy().append("Rdf.language", (Object)"N3"), "text/n3", new String[0]);
        }
    }

    public static class Turtle
    extends RdfSerializer {
        public Turtle(PropertyStore propertyStore) {
            super(propertyStore.copy().append("Rdf.language", (Object)"TURTLE"), "text/turtle", new String[0]);
        }
    }

    public static class NTriple
    extends RdfSerializer {
        public NTriple(PropertyStore propertyStore) {
            super(propertyStore.copy().append("Rdf.language", (Object)"N-TRIPLE"), "text/n-triple", new String[0]);
        }
    }

    public static class XmlAbbrev
    extends RdfSerializer {
        public XmlAbbrev(PropertyStore propertyStore) {
            super(propertyStore.copy().append("Rdf.language", (Object)"RDF/XML-ABBREV"), "text/xml+rdf", "text/xml+rdf+abbrev");
        }
    }

    public static class Xml
    extends RdfSerializer {
        public Xml(PropertyStore propertyStore) {
            super(propertyStore.copy().append("Rdf.language", (Object)"RDF/XML"), "text/xml+rdf", new String[0]);
        }
    }
}

