/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import org.apache.juneau.PropertyStore;
import org.apache.juneau.jena.RdfParserBuilder;
import org.apache.juneau.jena.RdfParserContext;
import org.apache.juneau.jena.RdfParserSession;
import org.apache.juneau.parser.ParserSessionArgs;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.parser.ReaderParserSession;

public class RdfParser
extends ReaderParser {
    public static final RdfParser DEFAULT_XML = new Xml(PropertyStore.create());
    public static final RdfParser DEFAULT_TURTLE = new Turtle(PropertyStore.create());
    public static final RdfParser DEFAULT_NTRIPLE = new NTriple(PropertyStore.create());
    public static final RdfParser DEFAULT_N3 = new N3(PropertyStore.create());
    private final RdfParserContext ctx = (RdfParserContext)this.createContext(RdfParserContext.class);

    public RdfParser(PropertyStore propertyStore, String ... consumes) {
        super(propertyStore, consumes);
    }

    public RdfParserBuilder builder() {
        return new RdfParserBuilder(this.propertyStore);
    }

    public ReaderParserSession createSession(ParserSessionArgs args) {
        return new RdfParserSession(this.ctx, args);
    }

    public static class N3
    extends RdfParser {
        public N3(PropertyStore propertyStore) {
            super(propertyStore.copy().append("Rdf.language", (Object)"N3"), "text/n3");
        }
    }

    public static class Turtle
    extends RdfParser {
        public Turtle(PropertyStore propertyStore) {
            super(propertyStore.copy().append("Rdf.language", (Object)"TURTLE"), "text/turtle");
        }
    }

    public static class NTriple
    extends RdfParser {
        public NTriple(PropertyStore propertyStore) {
            super(propertyStore.copy().append("Rdf.language", (Object)"N-TRIPLE"), "text/n-triple");
        }
    }

    public static class Xml
    extends RdfParser {
        public Xml(PropertyStore propertyStore) {
            super(propertyStore.copy().append("Rdf.language", (Object)"RDF/XML"), "text/xml+rdf");
        }
    }
}

