/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.List;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ClassMetaExtended;
import org.apache.juneau.internal.ReflectionUtils;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfUtils;
import org.apache.juneau.jena.annotation.Rdf;
import org.apache.juneau.jena.annotation.RdfSchema;
import org.apache.juneau.xml.Namespace;

public class RdfClassMeta
extends ClassMetaExtended {
    private final Rdf rdf;
    private final RdfCollectionFormat collectionFormat;
    private final Namespace namespace;

    public RdfClassMeta(ClassMeta<?> cm) {
        super(cm);
        Class c = this.getInnerClass();
        this.rdf = (Rdf)ReflectionUtils.getAnnotation(Rdf.class, (Class)c);
        this.collectionFormat = this.rdf != null ? this.rdf.collectionFormat() : RdfCollectionFormat.DEFAULT;
        List rdfs = ReflectionUtils.findAnnotations(Rdf.class, (Class)c);
        List schemas = ReflectionUtils.findAnnotations(RdfSchema.class, (Class)c);
        this.namespace = RdfUtils.findNamespace(rdfs, schemas);
    }

    protected Rdf getAnnotation() {
        return this.rdf;
    }

    protected RdfCollectionFormat getCollectionFormat() {
        return this.collectionFormat;
    }

    protected Namespace getNamespace() {
        return this.namespace;
    }
}

