/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import com.hp.hpl.jena.rdf.model.Container;
import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Property;
import com.hp.hpl.jena.rdf.model.RDFList;
import com.hp.hpl.jena.rdf.model.RDFNode;
import com.hp.hpl.jena.rdf.model.RDFWriter;
import com.hp.hpl.jena.rdf.model.Resource;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.Delegate;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.jena.RdfBeanMeta;
import org.apache.juneau.jena.RdfBeanPropertyMeta;
import org.apache.juneau.jena.RdfClassMeta;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfCommonContext;
import org.apache.juneau.jena.RdfSerializerContext;
import org.apache.juneau.serializer.SerializerContext;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.xml.Namespace;
import org.apache.juneau.xml.NamespaceFactory;
import org.apache.juneau.xml.XmlBeanPropertyMeta;
import org.apache.juneau.xml.XmlUtils;

public final class RdfSerializerSession
extends WriterSerializerSession {
    private final String rdfLanguage;
    private final Namespace juneauNs;
    private final Namespace juneauBpNs;
    private final boolean addLiteralTypes;
    private final boolean addRootProperty;
    private final boolean useXmlNamespaces;
    private final boolean looseCollections;
    private final boolean autoDetectNamespaces;
    private final boolean addBeanTypeProperties;
    private final Property pRoot;
    private final Property pValue;
    private final Model model;
    private final RDFWriter writer;
    private final RdfCollectionFormat collectionFormat;
    private final Namespace[] namespaces;

    protected RdfSerializerSession(RdfSerializerContext ctx, SerializerSessionArgs args) {
        super((SerializerContext)ctx, args);
        ObjectMap jenaSettings = new ObjectMap();
        jenaSettings.put((Object)"rdfXml.tab", (Object)(this.isUseWhitespace() ? 2 : 0));
        jenaSettings.put((Object)"rdfXml.attributeQuoteChar", (Object)Character.toString(this.getQuoteChar()));
        jenaSettings.putAll(ctx.jenaSettings);
        ObjectMap p = this.getProperties();
        if (p.isEmpty()) {
            this.rdfLanguage = ctx.rdfLanguage;
            this.juneauNs = ctx.juneauNs;
            this.juneauBpNs = ctx.juneauBpNs;
            this.addLiteralTypes = ctx.addLiteralTypes;
            this.addRootProperty = ctx.addRootProperty;
            this.collectionFormat = ctx.collectionFormat;
            this.looseCollections = ctx.looseCollections;
            this.useXmlNamespaces = ctx.useXmlNamespaces;
            this.autoDetectNamespaces = ctx.autoDetectNamespaces;
            this.namespaces = ctx.namespaces;
            this.addBeanTypeProperties = ctx.addBeanTypeProperties;
        } else {
            this.rdfLanguage = p.getString("Rdf.language", ctx.rdfLanguage);
            this.juneauNs = p.containsKey((Object)"Rdf.juneauNs") ? NamespaceFactory.parseNamespace((Object)p.get((Object)"Rdf.juneauNs")) : ctx.juneauNs;
            this.juneauBpNs = p.containsKey((Object)"Rdf.juneauBpNs") ? NamespaceFactory.parseNamespace((Object)p.get((Object)"Rdf.juneauBpNs")) : ctx.juneauBpNs;
            this.addLiteralTypes = p.getBoolean("RdfSerializer.addLiteralTypes", Boolean.valueOf(ctx.addLiteralTypes));
            this.addRootProperty = p.getBoolean("RdfSerializer.addRootProperty", Boolean.valueOf(ctx.addRootProperty));
            for (Map.Entry e : p.entrySet()) {
                String key = (String)e.getKey();
                if (!key.startsWith("Rdf.jena.")) continue;
                jenaSettings.put((Object)key.substring(9), e.getValue());
            }
            this.collectionFormat = RdfCollectionFormat.valueOf(p.getString("Rdf.collectionFormat", "DEFAULT"));
            this.looseCollections = p.getBoolean("Rdf.looseCollections", Boolean.valueOf(ctx.looseCollections));
            this.useXmlNamespaces = p.getBoolean("Rdf.useXmlNamespaces", Boolean.valueOf(ctx.useXmlNamespaces));
            this.autoDetectNamespaces = p.getBoolean("RdfSerializer.autoDetectNamespaces", Boolean.valueOf(ctx.autoDetectNamespaces));
            this.namespaces = (Namespace[])p.getWithDefault("RdfSerializer.namespaces.list", (Object)ctx.namespaces, Namespace[].class);
            this.addBeanTypeProperties = p.getBoolean("RdfSerializer.addBeanTypeProperties", Boolean.valueOf(ctx.addBeanTypeProperties));
        }
        this.model = ModelFactory.createDefaultModel();
        this.addModelPrefix(this.juneauNs);
        this.addModelPrefix(this.juneauBpNs);
        for (Namespace ns : this.namespaces) {
            this.addModelPrefix(ns);
        }
        this.pRoot = this.model.createProperty(this.juneauNs.getUri(), "root");
        this.pValue = this.model.createProperty(this.juneauNs.getUri(), "value");
        this.writer = this.model.getWriter(this.rdfLanguage);
        String propPrefix = RdfCommonContext.LANG_PROP_MAP.get(this.rdfLanguage);
        if (propPrefix == null) {
            throw new FormattedRuntimeException("Unknown RDF language encountered: ''{0}''", new Object[]{this.rdfLanguage});
        }
        for (Map.Entry e : jenaSettings.entrySet()) {
            if (!((String)e.getKey()).startsWith(propPrefix)) continue;
            this.writer.setProperty(((String)e.getKey()).substring(propPrefix.length()), e.getValue());
        }
    }

    private void addModelPrefix(Namespace ns) {
        this.model.setNsPrefix(ns.getName(), ns.getUri());
    }

    public final boolean isAddBeanTypeProperties() {
        return this.addBeanTypeProperties;
    }

    private String encodeTextInvalidChars(Object o) {
        if (o == null) {
            return null;
        }
        String s = this.toString(o);
        return XmlUtils.escapeText((Object)s);
    }

    private String encodeElementName(Object o) {
        return XmlUtils.encodeElementName((Object)this.toString(o));
    }

    protected void doSerialize(SerializerPipe out, Object o) throws Exception {
        Resource r = null;
        ClassMeta cm = this.getClassMetaForObject(o);
        if (this.looseCollections && cm != null && cm.isCollectionOrArray()) {
            Collection c = this.sort(cm.isCollection() ? (Collection)o : RdfSerializerSession.toList((Class)cm.getInnerClass(), (Object)o));
            for (Object o2 : c) {
                this.serializeAnything(o2, false, this.object(), "root", null, null);
            }
        } else {
            RDFNode n = this.serializeAnything(o, false, this.getExpectedRootType(o), "root", null, null);
            if (n.isLiteral()) {
                r = this.model.createResource();
                r.addProperty(this.pValue, n);
            } else {
                r = n.asResource();
            }
            if (this.addRootProperty) {
                r.addProperty(this.pRoot, "true");
            }
        }
        this.writer.write(this.model, out.getWriter(), "http://unknown/");
    }

    private RDFNode serializeAnything(Object o, boolean isURI, ClassMeta<?> eType, String attrName, BeanPropertyMeta bpm, Resource parentResource) throws Exception {
        Model m = this.model;
        ClassMeta aType = null;
        ClassMeta wType = null;
        ClassMeta sType = this.object();
        aType = this.push(attrName, o, eType);
        if (eType == null) {
            eType = this.object();
        }
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        if (o != null) {
            if (aType.isDelegate()) {
                wType = aType;
                aType = ((Delegate)o).getClassMeta();
            }
            sType = aType;
            PojoSwap swap = aType.getPojoSwap((BeanSession)this);
            if (swap != null) {
                o = swap.swap((BeanSession)this, o);
                sType = swap.getSwapClassMeta((BeanSession)this);
                if (sType.isObject()) {
                    sType = this.getClassMetaForObject(o);
                }
            }
        } else {
            sType = eType.getSerializedClassMeta((BeanSession)this);
        }
        String typeName = this.getBeanTypeName(eType, aType, bpm);
        Object n = null;
        if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
            if (bpm != null) {
                if (!this.isTrimNulls()) {
                    n = m.createResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
                }
            } else {
                n = m.createResource("http://www.w3.org/1999/02/22-rdf-syntax-ns#nil");
            }
        } else if (sType.isUri() || isURI) {
            String uri = this.getUri(o, null);
            n = StringUtils.isAbsoluteUri((String)uri) ? m.createResource(uri) : m.createLiteral(this.encodeTextInvalidChars(uri));
        } else if (sType.isCharSequence() || sType.isChar()) {
            n = m.createLiteral(this.encodeTextInvalidChars(o));
        } else if (sType.isNumber() || sType.isBoolean()) {
            n = !this.addLiteralTypes ? m.createLiteral(o.toString()) : m.createTypedLiteral(o);
        } else if (sType.isMap() || wType != null && wType.isMap()) {
            if (o instanceof BeanMap) {
                BeanMap bm = (BeanMap)o;
                Object uri = null;
                RdfBeanMeta rbm = (RdfBeanMeta)bm.getMeta().getExtendedMeta(RdfBeanMeta.class);
                if (rbm.hasBeanUri()) {
                    uri = rbm.getBeanUriProperty().get(bm, null);
                }
                String uri2 = this.getUri(uri, null);
                n = m.createResource(uri2);
                this.serializeBeanMap((BeanMap<?>)bm, (Resource)n, typeName);
            } else {
                Map m2 = (Map)o;
                n = m.createResource();
                this.serializeMap(m2, (Resource)n, (ClassMeta<?>)sType);
            }
        } else if (sType.isBean()) {
            BeanMap bm = this.toBeanMap(o);
            Object uri = null;
            RdfBeanMeta rbm = (RdfBeanMeta)bm.getMeta().getExtendedMeta(RdfBeanMeta.class);
            if (rbm.hasBeanUri()) {
                uri = rbm.getBeanUriProperty().get(bm, null);
            }
            String uri2 = this.getUri(uri, null);
            n = m.createResource(uri2);
            this.serializeBeanMap((BeanMap<?>)bm, (Resource)n, typeName);
        } else if (sType.isCollectionOrArray() || wType != null && wType.isCollection()) {
            Collection c = this.sort(sType.isCollection() ? (Collection)o : RdfSerializerSession.toList((Class)sType.getInnerClass(), (Object)o));
            RdfCollectionFormat f = this.collectionFormat;
            RdfClassMeta rcm = (RdfClassMeta)sType.getExtendedMeta(RdfClassMeta.class);
            if (rcm.getCollectionFormat() != RdfCollectionFormat.DEFAULT) {
                f = rcm.getCollectionFormat();
            }
            if (bpm != null && ((RdfBeanPropertyMeta)bpm.getExtendedMeta(RdfBeanPropertyMeta.class)).getCollectionFormat() != RdfCollectionFormat.DEFAULT) {
                f = ((RdfBeanPropertyMeta)bpm.getExtendedMeta(RdfBeanPropertyMeta.class)).getCollectionFormat();
            }
            switch (f) {
                case BAG: {
                    n = this.serializeToContainer(c, eType, (Container)m.createBag());
                    break;
                }
                case LIST: {
                    n = this.serializeToList(c, eType);
                    break;
                }
                case MULTI_VALUED: {
                    this.serializeToMultiProperties(c, eType, bpm, attrName, parentResource);
                    break;
                }
                default: {
                    n = this.serializeToContainer(c, eType, (Container)m.createSeq());
                    break;
                }
            }
        } else {
            n = sType.isReader() || sType.isInputStream() ? m.createLiteral(this.encodeTextInvalidChars(IOUtils.read((Object)o))) : m.createLiteral(this.encodeTextInvalidChars(this.toString(o)));
        }
        this.pop();
        return n;
    }

    private String getUri(Object uri, Object uri2) {
        String s = null;
        if (uri != null) {
            s = uri.toString();
        }
        if ((s == null || s.isEmpty()) && uri2 != null) {
            s = uri2.toString();
        }
        if (s == null) {
            return null;
        }
        return this.getUriResolver().resolve((Object)s);
    }

    private void serializeMap(Map m, Resource r, ClassMeta<?> type) throws Exception {
        m = this.sort(m);
        ClassMeta keyType = type.getKeyType();
        ClassMeta valueType = type.getValueType();
        ArrayList l = new ArrayList(m.entrySet());
        Collections.reverse(l);
        for (Map.Entry me : l) {
            Object value = me.getValue();
            Object key = this.generalize(me.getKey(), keyType);
            Namespace ns = this.juneauBpNs;
            Property p = this.model.createProperty(ns.getUri(), this.encodeElementName(this.toString(key)));
            RDFNode n = this.serializeAnything(value, false, valueType, key == null ? null : this.toString(key), null, r);
            if (n == null) continue;
            r.addProperty(p, n);
        }
    }

    private void serializeBeanMap(BeanMap<?> m, Resource r, String typeName) throws Exception {
        List l = m.getValues(this.isTrimNulls(), new BeanPropertyValue[]{typeName != null ? RdfSerializerSession.createBeanTypeNameProperty(m, (String)typeName) : null});
        Collections.reverse(l);
        for (BeanPropertyValue bpv : l) {
            BeanPropertyMeta pMeta = bpv.getMeta();
            ClassMeta cMeta = pMeta.getClassMeta();
            if (((RdfBeanPropertyMeta)pMeta.getExtendedMeta(RdfBeanPropertyMeta.class)).isBeanUri()) continue;
            String key = bpv.getName();
            Object value = bpv.getValue();
            Throwable t = bpv.getThrown();
            if (t != null) {
                this.onBeanGetterException(pMeta, t);
            }
            if (this.canIgnoreValue(cMeta, key, value)) continue;
            BeanPropertyMeta bpm = bpv.getMeta();
            Namespace ns = ((RdfBeanPropertyMeta)bpm.getExtendedMeta(RdfBeanPropertyMeta.class)).getNamespace();
            if (ns == null && this.useXmlNamespaces) {
                ns = ((XmlBeanPropertyMeta)bpm.getExtendedMeta(XmlBeanPropertyMeta.class)).getNamespace();
            }
            if (ns == null) {
                ns = this.juneauBpNs;
            } else if (this.autoDetectNamespaces) {
                this.addModelPrefix(ns);
            }
            Property p = this.model.createProperty(ns.getUri(), this.encodeElementName(key));
            RDFNode n = this.serializeAnything(value, pMeta.isUri(), cMeta, key, pMeta, r);
            if (n == null) continue;
            r.addProperty(p, n);
        }
    }

    private Container serializeToContainer(Collection c, ClassMeta<?> type, Container list) throws Exception {
        ClassMeta elementType = type.getElementType();
        for (Object e : c) {
            RDFNode n = this.serializeAnything(e, false, elementType, null, null, null);
            list = list.add(n);
        }
        return list;
    }

    private RDFList serializeToList(Collection c, ClassMeta<?> type) throws Exception {
        ClassMeta elementType = type.getElementType();
        ArrayList<RDFNode> l = new ArrayList<RDFNode>(c.size());
        for (Object e : c) {
            l.add(this.serializeAnything(e, false, elementType, null, null, null));
        }
        return this.model.createList(l.iterator());
    }

    private void serializeToMultiProperties(Collection c, ClassMeta<?> sType, BeanPropertyMeta bpm, String attrName, Resource parentResource) throws Exception {
        ClassMeta elementType = sType.getElementType();
        for (Object e : c) {
            Namespace ns = null;
            if (bpm != null && (ns = ((RdfBeanPropertyMeta)bpm.getExtendedMeta(RdfBeanPropertyMeta.class)).getNamespace()) == null && this.useXmlNamespaces) {
                ns = ((XmlBeanPropertyMeta)bpm.getExtendedMeta(XmlBeanPropertyMeta.class)).getNamespace();
            }
            if (ns == null) {
                ns = this.juneauBpNs;
            } else if (this.autoDetectNamespaces) {
                this.addModelPrefix(ns);
            }
            RDFNode n2 = this.serializeAnything(e, false, elementType, null, null, null);
            Property p = this.model.createProperty(ns.getUri(), this.encodeElementName(attrName));
            parentResource.addProperty(p, n2);
        }
    }
}

