/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.HashMap;
import java.util.Map;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfCommonContext;
import org.apache.juneau.parser.ParserContext;
import org.apache.juneau.xml.Namespace;

public final class RdfParserContext
extends ParserContext
implements RdfCommonContext {
    public static final String RDF_trimWhitespace = "RdfParser.trimWhitespace";
    final boolean trimWhitespace;
    final boolean looseCollections;
    final String rdfLanguage;
    final Namespace juneauNs;
    final Namespace juneauBpNs;
    final RdfCollectionFormat collectionFormat;
    final Map<String, Object> jenaSettings = new HashMap<String, Object>();

    public RdfParserContext(PropertyStore ps) {
        super(ps);
        this.trimWhitespace = (Boolean)ps.getProperty(RDF_trimWhitespace, Boolean.TYPE, (Object)false);
        this.looseCollections = (Boolean)ps.getProperty("Rdf.looseCollections", Boolean.TYPE, (Object)false);
        this.rdfLanguage = (String)ps.getProperty("Rdf.language", String.class, (Object)"RDF/XML-ABBREV");
        this.juneauNs = (Namespace)ps.getProperty("Rdf.juneauNs", Namespace.class, (Object)new Namespace("j", "http://www.apache.org/juneau/"));
        this.juneauBpNs = (Namespace)ps.getProperty("Rdf.juneauBpNs", Namespace.class, (Object)new Namespace("j", "http://www.apache.org/juneaubp/"));
        this.collectionFormat = (RdfCollectionFormat)((Object)ps.getProperty("Rdf.collectionFormat", RdfCollectionFormat.class, (Object)RdfCollectionFormat.DEFAULT));
    }

    public ObjectMap asMap() {
        return super.asMap().append("RdfParserContext", (Object)new ObjectMap().append("trimWhitespace", (Object)this.trimWhitespace).append("looseCollections", (Object)this.looseCollections).append("rdfLanguage", (Object)this.rdfLanguage).append("juneauNs", (Object)this.juneauNs).append("juneauBpNs", (Object)this.juneauBpNs).append("collectionFormat", (Object)this.collectionFormat));
    }
}

