/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.jena;

import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.Visibility;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.jena.RdfCollectionFormat;
import org.apache.juneau.jena.RdfParser;
import org.apache.juneau.parser.ParserBuilder;
import org.apache.juneau.parser.ParserListener;
import org.apache.juneau.xml.Namespace;

public class RdfParserBuilder
extends ParserBuilder {
    public RdfParserBuilder() {
    }

    public RdfParserBuilder(PropertyStore propertyStore) {
        super(propertyStore);
    }

    public RdfParser build() {
        return new RdfParser(this.propertyStore, "text/xml+rdf");
    }

    public RdfParserBuilder trimWhitespace(boolean value) {
        return this.property("RdfParser.trimWhitespace", value);
    }

    public RdfParserBuilder language(String value) {
        return this.property("Rdf.language", value);
    }

    public RdfParserBuilder xml() {
        return this.language("RDF/XML");
    }

    public RdfParserBuilder xmlabbrev() {
        return this.language("RDF/XML-ABBREV");
    }

    public RdfParserBuilder ntriple() {
        return this.language("N-TRIPLE");
    }

    public RdfParserBuilder n3() {
        return this.language("N3");
    }

    public RdfParserBuilder turtle() {
        return this.language("TURTLE");
    }

    public RdfParserBuilder juneauNs(Namespace value) {
        return this.property("Rdf.juneauNs", value);
    }

    public RdfParserBuilder juneauBpNs(Namespace value) {
        return this.property("Rdf.juneauBpNs", value);
    }

    public RdfParserBuilder useXmlNamespaces(boolean value) {
        return this.property("Rdf.useXmlNamespaces", value);
    }

    public RdfParserBuilder collectionFormat(RdfCollectionFormat value) {
        return this.property("Rdf.collectionFormat", (Object)value);
    }

    public RdfParserBuilder looseCollections(boolean value) {
        return this.property("Rdf.looseCollections", value);
    }

    public RdfParserBuilder trimStrings(boolean value) {
        super.trimStrings(value);
        return this;
    }

    public RdfParserBuilder strict(boolean value) {
        super.strict(value);
        return this;
    }

    public RdfParserBuilder strict() {
        super.strict();
        return this;
    }

    public RdfParserBuilder inputStreamCharset(String value) {
        super.inputStreamCharset(value);
        return this;
    }

    public RdfParserBuilder fileCharset(String value) {
        super.fileCharset(value);
        return this;
    }

    public RdfParserBuilder listener(Class<? extends ParserListener> value) {
        super.listener(value);
        return this;
    }

    public RdfParserBuilder beansRequireDefaultConstructor(boolean value) {
        super.beansRequireDefaultConstructor(value);
        return this;
    }

    public RdfParserBuilder beansRequireSerializable(boolean value) {
        super.beansRequireSerializable(value);
        return this;
    }

    public RdfParserBuilder beansRequireSettersForGetters(boolean value) {
        super.beansRequireSettersForGetters(value);
        return this;
    }

    public RdfParserBuilder beansRequireSomeProperties(boolean value) {
        super.beansRequireSomeProperties(value);
        return this;
    }

    public RdfParserBuilder beanMapPutReturnsOldValue(boolean value) {
        super.beanMapPutReturnsOldValue(value);
        return this;
    }

    public RdfParserBuilder beanConstructorVisibility(Visibility value) {
        super.beanConstructorVisibility(value);
        return this;
    }

    public RdfParserBuilder beanClassVisibility(Visibility value) {
        super.beanClassVisibility(value);
        return this;
    }

    public RdfParserBuilder beanFieldVisibility(Visibility value) {
        super.beanFieldVisibility(value);
        return this;
    }

    public RdfParserBuilder methodVisibility(Visibility value) {
        super.methodVisibility(value);
        return this;
    }

    public RdfParserBuilder useJavaBeanIntrospector(boolean value) {
        super.useJavaBeanIntrospector(value);
        return this;
    }

    public RdfParserBuilder useInterfaceProxies(boolean value) {
        super.useInterfaceProxies(value);
        return this;
    }

    public RdfParserBuilder ignoreUnknownBeanProperties(boolean value) {
        super.ignoreUnknownBeanProperties(value);
        return this;
    }

    public RdfParserBuilder ignoreUnknownNullBeanProperties(boolean value) {
        super.ignoreUnknownNullBeanProperties(value);
        return this;
    }

    public RdfParserBuilder ignorePropertiesWithoutSetters(boolean value) {
        super.ignorePropertiesWithoutSetters(value);
        return this;
    }

    public RdfParserBuilder ignoreInvocationExceptionsOnGetters(boolean value) {
        super.ignoreInvocationExceptionsOnGetters(value);
        return this;
    }

    public RdfParserBuilder ignoreInvocationExceptionsOnSetters(boolean value) {
        super.ignoreInvocationExceptionsOnSetters(value);
        return this;
    }

    public RdfParserBuilder sortProperties(boolean value) {
        super.sortProperties(value);
        return this;
    }

    public RdfParserBuilder notBeanPackages(String ... values) {
        super.notBeanPackages(values);
        return this;
    }

    public RdfParserBuilder notBeanPackages(Collection<String> values) {
        super.notBeanPackages(values);
        return this;
    }

    public RdfParserBuilder setNotBeanPackages(String ... values) {
        super.setNotBeanPackages(values);
        return this;
    }

    public RdfParserBuilder setNotBeanPackages(Collection<String> values) {
        super.setNotBeanPackages(values);
        return this;
    }

    public RdfParserBuilder removeNotBeanPackages(String ... values) {
        super.removeNotBeanPackages(values);
        return this;
    }

    public RdfParserBuilder removeNotBeanPackages(Collection<String> values) {
        super.removeNotBeanPackages(values);
        return this;
    }

    public RdfParserBuilder notBeanClasses(Class<?> ... values) {
        super.notBeanClasses((Class[])values);
        return this;
    }

    public RdfParserBuilder notBeanClasses(Collection<Class<?>> values) {
        super.notBeanClasses(values);
        return this;
    }

    public RdfParserBuilder setNotBeanClasses(Class<?> ... values) {
        super.setNotBeanClasses((Class[])values);
        return this;
    }

    public RdfParserBuilder setNotBeanClasses(Collection<Class<?>> values) {
        super.setNotBeanClasses(values);
        return this;
    }

    public RdfParserBuilder removeNotBeanClasses(Class<?> ... values) {
        super.removeNotBeanClasses((Class[])values);
        return this;
    }

    public RdfParserBuilder removeNotBeanClasses(Collection<Class<?>> values) {
        super.removeNotBeanClasses(values);
        return this;
    }

    public RdfParserBuilder beanFilters(Class<?> ... values) {
        super.beanFilters((Class[])values);
        return this;
    }

    public RdfParserBuilder beanFilters(Collection<Class<?>> values) {
        super.beanFilters(values);
        return this;
    }

    public RdfParserBuilder setBeanFilters(Class<?> ... values) {
        super.setBeanFilters((Class[])values);
        return this;
    }

    public RdfParserBuilder setBeanFilters(Collection<Class<?>> values) {
        super.setBeanFilters(values);
        return this;
    }

    public RdfParserBuilder removeBeanFilters(Class<?> ... values) {
        super.removeBeanFilters((Class[])values);
        return this;
    }

    public RdfParserBuilder removeBeanFilters(Collection<Class<?>> values) {
        super.removeBeanFilters(values);
        return this;
    }

    public RdfParserBuilder pojoSwaps(Class<?> ... values) {
        super.pojoSwaps((Class[])values);
        return this;
    }

    public RdfParserBuilder pojoSwaps(Collection<Class<?>> values) {
        super.pojoSwaps(values);
        return this;
    }

    public RdfParserBuilder setPojoSwaps(Class<?> ... values) {
        super.setPojoSwaps((Class[])values);
        return this;
    }

    public RdfParserBuilder setPojoSwaps(Collection<Class<?>> values) {
        super.setPojoSwaps(values);
        return this;
    }

    public RdfParserBuilder removePojoSwaps(Class<?> ... values) {
        super.removePojoSwaps((Class[])values);
        return this;
    }

    public RdfParserBuilder removePojoSwaps(Collection<Class<?>> values) {
        super.removePojoSwaps(values);
        return this;
    }

    public RdfParserBuilder implClasses(Map<Class<?>, Class<?>> values) {
        super.implClasses(values);
        return this;
    }

    public <T> RdfParserBuilder implClass(Class<T> interfaceClass, Class<? extends T> implClass) {
        super.implClass(interfaceClass, implClass);
        return this;
    }

    public RdfParserBuilder beanDictionary(Class<?> ... values) {
        super.beanDictionary((Class[])values);
        return this;
    }

    public RdfParserBuilder beanDictionary(Collection<Class<?>> values) {
        super.beanDictionary(values);
        return this;
    }

    public RdfParserBuilder setBeanDictionary(Class<?> ... values) {
        super.setBeanDictionary((Class[])values);
        return this;
    }

    public RdfParserBuilder setBeanDictionary(Collection<Class<?>> values) {
        super.setBeanDictionary(values);
        return this;
    }

    public RdfParserBuilder removeFromBeanDictionary(Class<?> ... values) {
        super.removeFromBeanDictionary((Class[])values);
        return this;
    }

    public RdfParserBuilder removeFromBeanDictionary(Collection<Class<?>> values) {
        super.removeFromBeanDictionary(values);
        return this;
    }

    public RdfParserBuilder beanTypePropertyName(String value) {
        super.beanTypePropertyName(value);
        return this;
    }

    public RdfParserBuilder defaultParser(Class<?> value) {
        super.defaultParser(value);
        return this;
    }

    public RdfParserBuilder locale(Locale value) {
        super.locale(value);
        return this;
    }

    public RdfParserBuilder timeZone(TimeZone value) {
        super.timeZone(value);
        return this;
    }

    public RdfParserBuilder mediaType(MediaType value) {
        super.mediaType(value);
        return this;
    }

    public RdfParserBuilder debug() {
        super.debug();
        return this;
    }

    public RdfParserBuilder property(String name, Object value) {
        super.property(name, value);
        return this;
    }

    public RdfParserBuilder properties(Map<String, Object> properties) {
        super.properties(properties);
        return this;
    }

    public RdfParserBuilder addToProperty(String name, Object value) {
        super.addToProperty(name, value);
        return this;
    }

    public RdfParserBuilder putToProperty(String name, Object key, Object value) {
        super.putToProperty(name, key, value);
        return this;
    }

    public RdfParserBuilder putToProperty(String name, Object value) {
        super.putToProperty(name, value);
        return this;
    }

    public RdfParserBuilder removeFromProperty(String name, Object value) {
        super.removeFromProperty(name, value);
        return this;
    }

    public RdfParserBuilder classLoader(ClassLoader classLoader) {
        super.classLoader(classLoader);
        return this;
    }

    public RdfParserBuilder apply(PropertyStore copyFrom) {
        super.apply(copyFrom);
        return this;
    }
}

