/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice.resources;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Formatter;
import java.util.logging.LogRecord;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.juneau.internal.StringUtils;

public class LogEntryFormatter
extends Formatter {
    private ConcurrentHashMap<String, AtomicInteger> hashes;
    private DateFormat df;
    private String format;
    private Pattern rePattern;
    private Map<String, Integer> fieldIndexes;

    public LogEntryFormatter(String format, String dateFormat, boolean useStackTraceHashes) {
        this.df = new SimpleDateFormat(dateFormat);
        if (useStackTraceHashes) {
            this.hashes = new ConcurrentHashMap();
        }
        this.fieldIndexes = new HashMap<String, Integer>();
        this.format = format = format.replaceAll("\\{date\\}", "%1\\$s").replaceAll("\\{class\\}", "%2\\$s").replaceAll("\\{method\\}", "%3\\$s").replaceAll("\\{logger\\}", "%4\\$s").replaceAll("\\{level\\}", "%5\\$s").replaceAll("\\{msg\\}", "%6\\$s").replaceAll("\\{threadid\\}", "%7\\$s").replaceAll("\\{exception\\}", "%8\\$s");
        int index = 1;
        StringBuilder re = new StringBuilder();
        int S1 = 1;
        int S2 = 2;
        int S3 = 3;
        int S4 = 4;
        int state = 1;
        int i1 = 0;
        for (int i = 0; i < format.length(); ++i) {
            char c = format.charAt(i);
            if (state == S1) {
                if (c == '%') {
                    state = S2;
                    continue;
                }
                if (!Character.isLetterOrDigit(c) && !Character.isWhitespace(c)) {
                    re.append('\\');
                }
                re.append(c);
                continue;
            }
            if (state == S2) {
                if (Character.isDigit(c)) {
                    i1 = i;
                    state = S3;
                    continue;
                }
                re.append("\\%").append(c);
                state = S1;
                continue;
            }
            if (state == S3) {
                if (c == '$') {
                    state = S4;
                    continue;
                }
                re.append("\\%").append(format.substring(i1, i));
                state = S1;
                continue;
            }
            if (state != S4) continue;
            if (c == 's') {
                int group = Integer.parseInt(format.substring(i1, i - 1));
                switch (group) {
                    case 1: {
                        this.fieldIndexes.put("date", index++);
                        re.append("(" + dateFormat.replaceAll("[mHhsSdMy]", "\\\\d").replaceAll("\\.", "\\\\.") + ")");
                        break;
                    }
                    case 2: {
                        this.fieldIndexes.put("class", index++);
                        re.append("([\\p{javaJavaIdentifierPart}\\.]+)");
                        break;
                    }
                    case 3: {
                        this.fieldIndexes.put("method", index++);
                        re.append("([\\p{javaJavaIdentifierPart}\\.]+)");
                        break;
                    }
                    case 4: {
                        this.fieldIndexes.put("logger", index++);
                        re.append("([\\w\\d\\.\\_]+)");
                        break;
                    }
                    case 5: {
                        this.fieldIndexes.put("level", index++);
                        re.append("(SEVERE|WARNING|INFO|CONFIG|FINE|FINER|FINEST)");
                        break;
                    }
                    case 6: {
                        this.fieldIndexes.put("msg", index++);
                        re.append("(.*)");
                        break;
                    }
                    case 7: {
                        this.fieldIndexes.put("threadid", index++);
                        re.append("(\\\\d+)");
                        break;
                    }
                    case 8: {
                        this.fieldIndexes.put("exception", index++);
                        re.append("(.*)");
                        break;
                    }
                }
            } else {
                re.append("\\%").append(format.substring(i1, i));
            }
            state = S1;
        }
        String sre = re.toString();
        if (sre.endsWith("\\%n")) {
            sre = sre.substring(0, sre.length() - 3);
        }
        sre = sre.replaceAll("\\\\%n", "\\\\n");
        this.rePattern = Pattern.compile(sre);
        this.fieldIndexes = Collections.unmodifiableMap(this.fieldIndexes);
    }

    public Pattern getLogEntryPattern() {
        return this.rePattern;
    }

    public DateFormat getDateFormat() {
        return this.df;
    }

    public String getField(String fieldName, Matcher m) {
        Integer i = this.fieldIndexes.get(fieldName);
        return i == null ? null : m.group(i);
    }

    @Override
    public String format(LogRecord r) {
        String msg = this.formatMessage(r);
        Throwable t = r.getThrown();
        String hash = null;
        int c = 0;
        if (this.hashes != null && t != null) {
            hash = LogEntryFormatter.hashCode(t);
            this.hashes.putIfAbsent(hash, new AtomicInteger(0));
            c = this.hashes.get(hash).incrementAndGet();
            if (c == 1) {
                msg = '[' + hash + '.' + c + "] " + msg;
            } else {
                msg = '[' + hash + '.' + c + "] " + msg + ", " + t.getLocalizedMessage();
                t = null;
            }
        }
        String s = String.format(this.format, this.df.format(new Date(r.getMillis())), r.getSourceClassName(), r.getSourceMethodName(), r.getLoggerName(), r.getLevel(), msg, r.getThreadID(), r.getThrown() == null ? "" : r.getThrown().getMessage());
        if (t != null) {
            s = s + String.format("%n%s", StringUtils.getStackTrace((Throwable)r.getThrown()));
        }
        return s;
    }

    private static String hashCode(Throwable t) {
        int i = 0;
        while (t != null) {
            for (StackTraceElement e : t.getStackTrace()) {
                i ^= e.hashCode();
            }
            t = t.getCause();
        }
        return Integer.toHexString(i);
    }
}

