/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.Servlet;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ini.ConfigFile;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.microservice.Microservice;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.utils.ManifestFile;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.xml.XmlConfiguration;

public class RestMicroservice
extends Microservice {
    private Server server;
    private Object jettyXml;
    private static volatile RestMicroservice INSTANCE;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RestMicroservice getInstance() {
        Class<RestMicroservice> clazz = RestMicroservice.class;
        synchronized (RestMicroservice.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    public static void main(String[] args) throws Exception {
        new RestMicroservice(args).start().join();
    }

    public RestMicroservice(String ... args) throws Exception {
        super(args);
        RestMicroservice.setInstance(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setInstance(RestMicroservice rm) {
        Class<RestMicroservice> clazz = RestMicroservice.class;
        synchronized (RestMicroservice.class) {
            INSTANCE = rm;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    @Override
    public RestMicroservice start() throws Exception {
        super.start();
        this.createServer();
        this.startServer();
        return this;
    }

    @Override
    public RestMicroservice join() throws Exception {
        this.server.join();
        return this;
    }

    @Override
    public RestMicroservice stop() {
        Thread t = new Thread(){

            @Override
            public void run() {
                Logger logger = RestMicroservice.this.getLogger();
                try {
                    if (RestMicroservice.this.server.isStopping() || RestMicroservice.this.server.isStopped()) {
                        return;
                    }
                    RestMicroservice.this.onStopServer();
                    logger.warning("Stopping server.");
                    RestMicroservice.this.server.stop();
                    logger.warning("Server stopped.");
                    RestMicroservice.this.onPostStopServer();
                }
                catch (Exception e) {
                    logger.log(Level.SEVERE, e.getLocalizedMessage(), e);
                }
            }
        };
        t.start();
        try {
            t.join();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        super.stop();
        return this;
    }

    public int getPort() {
        for (Connector c : this.getServer().getConnectors()) {
            if (!(c instanceof ServerConnector)) continue;
            return ((ServerConnector)c).getPort();
        }
        throw new RuntimeException("Could not locate ServerConnector in Jetty server.");
    }

    public String getContextPath() {
        for (Handler h : this.getServer().getHandlers()) {
            if (h instanceof HandlerCollection) {
                for (Handler h2 : ((HandlerCollection)h).getChildHandlers()) {
                    if (!(h2 instanceof ServletContextHandler)) continue;
                    return ((ServletContextHandler)h2).getContextPath();
                }
            }
            if (!(h instanceof ServletContextHandler)) continue;
            return ((ServletContextHandler)h).getContextPath();
        }
        throw new RuntimeException("Could not locate ServletContextHandler in Jetty server.");
    }

    public String getProtocol() {
        for (Connector c : this.getServer().getConnectors()) {
            if (!(c instanceof ServerConnector)) continue;
            for (ConnectionFactory cf : ((ServerConnector)c).getConnectionFactories()) {
                if (!(cf instanceof SslConnectionFactory)) continue;
                return "https";
            }
        }
        return "http";
    }

    public String getHostName() {
        String hostname = "localhost";
        try {
            hostname = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        return hostname;
    }

    public URI getURI() {
        String cp = this.getContextPath();
        try {
            return new URI(this.getProtocol(), null, this.getHostName(), this.getPort(), "/".equals(cp) ? null : cp, null, null);
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected Server createServer() throws Exception {
        this.onCreateServer();
        ConfigFile cf = this.getConfig();
        ManifestFile mf = this.getManifest();
        VarResolver vr = this.getVarResolver();
        int[] ports = (int[])cf.getObjectWithDefault("Jetty/port", mf.getWithDefault("Jetty-Port", (Object)new int[]{8000}, int[].class), int[].class);
        int availablePort = RestMicroservice.findOpenPort(ports);
        System.setProperty("availablePort", String.valueOf(availablePort));
        if (this.jettyXml == null) {
            this.jettyXml = cf.getString("Jetty/config", mf.getString("Jetty-Config", null));
        }
        if (this.jettyXml == null) {
            throw new FormattedRuntimeException("Jetty.xml file location was not specified in the configuration file (Jetty/config) or manifest file (Jetty-Config).", new Object[0]);
        }
        String xmlConfig = null;
        if (this.jettyXml instanceof String) {
            this.jettyXml = new File(this.jettyXml.toString());
        }
        if (this.jettyXml instanceof File) {
            File f = (File)this.jettyXml;
            if (!f.exists()) throw new FormattedRuntimeException("Jetty.xml file ''{0}'' was specified but not found on the file system.", new Object[]{this.jettyXml});
            xmlConfig = IOUtils.read((File)((File)this.jettyXml));
        } else {
            xmlConfig = IOUtils.read((Object)this.jettyXml);
        }
        if (cf.getBoolean("Jetty/resolveVars", false)) {
            xmlConfig = vr.resolve(xmlConfig);
        }
        this.getLogger().info(xmlConfig);
        XmlConfiguration config = new XmlConfiguration((InputStream)new ByteArrayInputStream(xmlConfig.getBytes()));
        this.server = (Server)config.configure();
        return this.server;
    }

    public RestMicroservice addServlet(Servlet servlet, String pathSpec) {
        for (Handler h : this.getServer().getHandlers()) {
            if (!(h instanceof ServletContextHandler)) continue;
            ServletHolder sh = new ServletHolder(servlet);
            ((ServletContextHandler)h).addServlet(sh, pathSpec);
            return this;
        }
        throw new RuntimeException("Servlet context handler not found in jetty server.");
    }

    public RestMicroservice addServletAttribute(String name, Object value) {
        this.getServer().setAttribute(name, value);
        return this;
    }

    public Server getServer() {
        if (this.server == null) {
            throw new RuntimeException("Server not found.  createServer() must be called first.");
        }
        return this.server;
    }

    private static int findOpenPort(int[] ports) {
        for (int port : ports) {
            try {
                if (port == 0) {
                    port = new Random().nextInt(Short.MAX_VALUE - ports[0] + 1) + ports[0];
                }
                ServerSocket ss = new ServerSocket(port);
                ss.close();
                return port;
            }
            catch (IOException iOException) {
            }
        }
        return 0;
    }

    protected int startServer() throws Exception {
        this.onStartServer();
        this.server.start();
        this.getLogger().warning("Server started on port " + this.getPort());
        this.onPostStartServer();
        return this.getPort();
    }

    @Override
    protected void onConfigSave(ConfigFile cf) {
        try {
            String saveConfigAction = cf.getString("saveConfigAction", "NOTHING");
            if (saveConfigAction.equals("RESTART_SERVER")) {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            RestMicroservice.this.stop();
                            RestMicroservice.this.start();
                        }
                        catch (Exception e) {
                            RestMicroservice.this.getLogger().log(Level.SEVERE, e.getLocalizedMessage(), e);
                        }
                    }
                }.start();
            } else if (saveConfigAction.equals("RESTART_SERVICE")) {
                this.stop();
                System.exit(3);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public RestMicroservice setJettyXml(Object jettyXml) {
        if (!(jettyXml instanceof String || jettyXml instanceof File || jettyXml instanceof InputStream || jettyXml instanceof Reader)) {
            throw new FormattedRuntimeException("Invalid object type passed to setJettyXml()", new Object[]{jettyXml == null ? null : jettyXml.getClass().getName()});
        }
        this.jettyXml = jettyXml;
        return this;
    }

    protected void onCreateServer() {
    }

    protected void onStartServer() {
    }

    protected void onPostStartServer() {
    }

    protected void onStopServer() {
    }

    protected void onPostStopServer() {
    }

    @Override
    public RestMicroservice setConfig(String cfPath, boolean create) throws IOException {
        super.setConfig(cfPath, create);
        return this;
    }

    @Override
    public RestMicroservice setManifestContents(String ... contents) throws IOException {
        super.setManifestContents(contents);
        return this;
    }
}

