/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.microservice;

import java.io.ByteArrayInputStream;
import java.io.Console;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Set;
import java.util.jar.Manifest;
import java.util.logging.ConsoleHandler;
import java.util.logging.FileHandler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.ini.ConfigFile;
import org.apache.juneau.ini.ConfigFileBuilder;
import org.apache.juneau.ini.ConfigFileListener;
import org.apache.juneau.ini.ConfigFileVar;
import org.apache.juneau.internal.FileUtils;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.microservice.resources.LogEntryFormatter;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.VarResolverBuilder;
import org.apache.juneau.svl.vars.ArgsVar;
import org.apache.juneau.svl.vars.IfVar;
import org.apache.juneau.svl.vars.ManifestFileVar;
import org.apache.juneau.svl.vars.SwitchVar;
import org.apache.juneau.utils.Args;
import org.apache.juneau.utils.ManifestFile;

public abstract class Microservice {
    private static volatile Microservice INSTANCE;
    private Logger logger;
    private Args args;
    private ConfigFile cf;
    private ManifestFile mf;
    private VarResolver vr;
    private String cfPath;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Microservice getInstance() {
        Class<Microservice> clazz = Microservice.class;
        synchronized (Microservice.class) {
            // ** MonitorExit[var0] (shouldn't be in output)
            return INSTANCE;
        }
    }

    protected Microservice(String ... args) throws Exception {
        Microservice.setInstance(this);
        this.args = new Args(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setInstance(Microservice m) {
        Class<Microservice> clazz = Microservice.class;
        synchronized (Microservice.class) {
            INSTANCE = m;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public Microservice setConfig(String cfPath, boolean create) throws IOException {
        File f = new File(cfPath);
        if (!f.exists()) {
            if (!create) {
                throw new FileNotFoundException("Could not locate config file at '" + f.getAbsolutePath() + "'");
            }
            if (!f.createNewFile()) {
                throw new FileNotFoundException("Could not create config file at '" + f.getAbsolutePath() + "'");
            }
        }
        this.cfPath = cfPath;
        return this;
    }

    public void setConfig(ConfigFile cf) {
        this.cf = cf;
    }

    public void setManifest(Manifest mf) {
        this.mf = new ManifestFile(mf);
    }

    public Microservice setManifestContents(String ... contents) throws IOException {
        String s = StringUtils.join((Object[])contents, (String)"\n") + "\n";
        this.mf = new ManifestFile(new Manifest(new ByteArrayInputStream(s.getBytes("UTF-8"))));
        return this;
    }

    public void setManifest(File f) throws IOException {
        this.mf = new ManifestFile(f);
    }

    public void setManifest(Class<?> c) throws IOException {
        this.mf = new ManifestFile(c);
    }

    protected VarResolverBuilder createVarResolver() {
        VarResolverBuilder b = new VarResolverBuilder().defaultVars().vars(new Class[]{ConfigFileVar.class, ManifestFileVar.class, ArgsVar.class, SwitchVar.class, IfVar.class}).contextObject("manifest", (Object)this.mf).contextObject("args", (Object)this.args);
        if (this.cf != null) {
            b.contextObject("config", (Object)this.cf);
        }
        return b;
    }

    public Args getArgs() {
        return this.args;
    }

    public ConfigFile getConfig() {
        return this.cf;
    }

    public ManifestFile getManifest() {
        return this.mf;
    }

    public VarResolver getVarResolver() {
        return this.vr;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public Microservice start() throws Exception {
        Set spKeys;
        if (this.mf == null) {
            Manifest m = new Manifest();
            File f = new File("META-INF/MANIFEST.MF");
            if (f.exists()) {
                try {
                    m.read(new FileInputStream(f));
                }
                catch (IOException e) {
                    System.err.println("Problem detected in MANIFEST.MF.  Contents below:\n" + IOUtils.read((File)f));
                    throw e;
                }
            }
            URLClassLoader cl = (URLClassLoader)this.getClass().getClassLoader();
            URL url = cl.findResource("META-INF/MANIFEST.MF");
            if (url != null) {
                try {
                    m.read(url.openStream());
                }
                catch (IOException e) {
                    System.err.println("Problem detected in MANIFEST.MF.  Contents below:\n" + IOUtils.read((InputStream)url.openStream()));
                    throw e;
                }
            }
            this.mf = new ManifestFile(m);
        }
        ConfigFileBuilder cfb = new ConfigFileBuilder();
        if (this.cfPath != null) {
            this.cf = cfb.build(this.cfPath).getResolving(this.createVarResolver().build());
        }
        if (this.cf == null) {
            if (this.args.hasArg(0)) {
                this.cfPath = this.args.getArg(0);
            } else if (this.mf.containsKey((Object)"Main-ConfigFile")) {
                this.cfPath = this.mf.getString("Main-ConfigFile");
            } else {
                String cmd = System.getProperty("sun.java.command", "not_found").split("\\s+")[0];
                if (cmd.endsWith(".jar")) {
                    this.cfPath = cmd.replace(".jar", ".cfg");
                }
            }
            if (this.cfPath == null) {
                System.err.println("Running class [" + this.getClass().getSimpleName() + "] without a config file.");
                this.cf = cfb.build();
            } else {
                System.out.println("Running class [" + this.getClass().getSimpleName() + "] using config file [" + this.cfPath + "]");
                this.cf = cfb.build(this.cfPath).getResolving(this.createVarResolver().build());
            }
        }
        this.vr = this.createVarResolver().build();
        if (this.cfPath != null) {
            System.setProperty("juneau.configFile", this.cfPath);
        }
        if ((spKeys = this.cf.getSectionKeys("SystemProperties")) != null) {
            for (String key : spKeys) {
                System.setProperty(key, this.cf.get("SystemProperties", key));
            }
        }
        try {
            this.initLogging();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.cf.addListener(new ConfigFileListener(){

            public void onSave(ConfigFile cf) {
                Microservice.this.onConfigSave(cf);
            }

            public void onChange(ConfigFile cf, Set<String> changes) {
                Microservice.this.onConfigChange(cf, changes);
            }
        });
        new Thread(){

            @Override
            public void run() {
                Console c = System.console();
                if (c == null) {
                    System.out.println("No available console.");
                } else {
                    String l;
                    while ((l = c.readLine("\nEnter 'exit' to exit.\n", new Object[0])) != null && !l.equals("exit")) {
                    }
                    Microservice.this.stop();
                }
            }
        }.start();
        Runtime.getRuntime().addShutdownHook(new Thread(){

            @Override
            public void run() {
                Microservice.this.stop();
            }
        });
        this.onStart();
        return this;
    }

    protected void initLogging() throws Exception {
        ObjectMap loggerLevels;
        ConfigFile cf = this.getConfig();
        this.logger = Logger.getLogger("");
        String logFile = cf.getString("Logging/logFile");
        if (!StringUtils.isEmpty((String)logFile)) {
            LogManager.getLogManager().reset();
            String logDir = cf.getString("Logging/logDir", ".");
            FileUtils.mkdirs((File)new File(logDir), (boolean)false);
            boolean append = cf.getBoolean("Logging/append");
            int limit = cf.getInt("Logging/limit", 0x100000);
            int count = cf.getInt("Logging/count", 1);
            FileHandler fh = new FileHandler(logDir + '/' + logFile, limit, count, append);
            boolean useStackTraceHashes = cf.getBoolean("Logging/useStackTraceHashes");
            String format = cf.getString("Logging/format", "[{date} {level}] {msg}%n");
            String dateFormat = cf.getString("Logging/dateFormat", "yyyy.MM.dd hh:mm:ss");
            fh.setFormatter(new LogEntryFormatter(format, dateFormat, useStackTraceHashes));
            fh.setLevel((Level)cf.getObjectWithDefault("Logging/fileLevel", (Object)Level.INFO, Level.class));
            this.logger.addHandler(fh);
            ConsoleHandler ch = new ConsoleHandler();
            ch.setLevel((Level)cf.getObjectWithDefault("Logging/consoleLevel", (Object)Level.WARNING, Level.class));
            ch.setFormatter(new LogEntryFormatter(format, dateFormat, false));
            this.logger.addHandler(ch);
        }
        if ((loggerLevels = (ObjectMap)cf.getObject("Logging/levels", ObjectMap.class)) != null) {
            for (String l : loggerLevels.keySet()) {
                Logger.getLogger(l).setLevel((Level)loggerLevels.get(l, Level.class));
            }
        }
    }

    public Microservice join() throws Exception {
        return this;
    }

    public Microservice stop() {
        this.onStop();
        return this;
    }

    public void kill() {
        System.exit(2);
    }

    protected void onStart() {
    }

    protected void onStop() {
    }

    protected void onConfigSave(ConfigFile cf) {
    }

    protected void onConfigChange(ConfigFile cf, Set<String> changes) {
    }
}

