/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.svl;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.svl.Var;
import org.apache.juneau.svl.VarResolver;
import org.apache.juneau.svl.vars.EnvVariablesVar;
import org.apache.juneau.svl.vars.IfVar;
import org.apache.juneau.svl.vars.SwitchVar;
import org.apache.juneau.svl.vars.SystemPropertiesVar;

public class VarResolverBuilder {
    private final List<Class<? extends Var>> vars = new ArrayList<Class<? extends Var>>();
    private final Map<String, Object> contextObjects = new HashMap<String, Object>();

    public VarResolver build() {
        return new VarResolver(this.vars.toArray(new Class[this.vars.size()]), this.contextObjects);
    }

    public VarResolverBuilder vars(Class<?> ... vars) {
        for (Class<?> v : vars) {
            ClassUtils.newInstance(Var.class, v, (Object[])new Object[0]);
            this.vars.add(v);
        }
        return this;
    }

    public VarResolverBuilder defaultVars() {
        return this.vars(SystemPropertiesVar.class, EnvVariablesVar.class, SwitchVar.class, IfVar.class);
    }

    public VarResolverBuilder contextObject(String name, Object object) {
        this.contextObjects.put(name, object);
        return this;
    }

    public VarResolverBuilder contextObjects(Map<String, Object> map) {
        this.contextObjects.putAll(map);
        return this;
    }
}

