/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.IOException;
import java.util.logging.Level;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.BeanContext;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.rest.RestConfig;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestException;
import org.apache.juneau.utils.MessageBundle;

public abstract class RestServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private RestConfig config;
    private RestContext context;
    private volatile boolean isInitialized = false;
    private Exception initException;

    public final synchronized void init(ServletConfig servletConfig) throws ServletException {
        try {
            RestConfig rsc = new RestConfig(servletConfig, ((Object)((Object)this)).getClass(), null);
            rsc.init((Object)this);
            RestContext context = this.createContext(rsc);
            super.init(servletConfig);
            context.postInit();
            context.postInitChildFirst();
        }
        catch (RestException e) {
            this.initException = e;
            this.log(Level.SEVERE, (Throwable)((Object)e), "Servlet init error on class ''{0}''", ((Object)((Object)this)).getClass().getName());
        }
        catch (ServletException e) {
            this.initException = e;
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", ((Object)((Object)this)).getClass().getName());
            throw e;
        }
        catch (Exception e) {
            this.initException = e;
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", ((Object)((Object)this)).getClass().getName());
            throw new ServletException((Throwable)e);
        }
        catch (Throwable e) {
            this.initException = new Exception(e);
            this.log(Level.SEVERE, e, "Servlet init error on class ''{0}''", ((Object)((Object)this)).getClass().getName());
            throw new ServletException(e);
        }
        finally {
            this.isInitialized = true;
        }
    }

    void innerInit(ServletConfig servletConfig) throws ServletException {
        super.init(servletConfig);
    }

    void setContext(RestContext context) {
        this.config = context.config;
        this.context = context;
    }

    public synchronized void init(RestContext context) throws Exception {
    }

    private synchronized RestContext createContext(RestConfig config) throws Exception {
        if (!this.isInitialized) {
            this.config = config;
            this.context = new RestContext((Object)this, this.getServletContext(), config);
            this.isInitialized = true;
        }
        return this.context;
    }

    public void service(HttpServletRequest r1, HttpServletResponse r2) throws ServletException, IOException {
        try {
            if (this.initException != null) {
                if (this.initException instanceof RestException) {
                    throw (RestException)((Object)this.initException);
                }
                throw new RestException(500, this.initException);
            }
            if (this.context == null) {
                throw new RestException(500, "Servlet {0} not initialized.  init(RestConfig) was not called.  This can occur if you've overridden this method but didn't call super.init(RestConfig).", ((Object)((Object)this)).getClass().getName());
            }
            if (!this.isInitialized) {
                throw new RestException(500, "Servlet {0} has not been initialized", ((Object)((Object)this)).getClass().getName());
            }
            this.context.getCallHandler().service(r1, r2);
        }
        catch (RestException e) {
            r2.sendError(500, e.getLocalizedMessage());
        }
        catch (Throwable e) {
            r2.sendError(500, e.getLocalizedMessage());
        }
    }

    protected RestContext getContext() {
        return this.context;
    }

    protected void log(Level level, String msg, Object ... args) {
        if (this.context != null) {
            this.context.getLogger().log(level, msg, args);
        }
    }

    protected void log(Level level, Throwable cause, String msg, Object ... args) {
        if (this.context != null) {
            this.context.getLogger().log(level, cause, msg, args);
        } else {
            System.err.println(StringUtils.format((String)msg, (Object[])args));
            if (cause != null) {
                cause.printStackTrace();
            }
        }
    }

    public RestConfig getServletConfig() {
        return this.config;
    }

    public void destroy() {
        if (this.context != null) {
            this.context.destroy();
        }
        super.destroy();
    }

    public MessageBundle getMessages() {
        return this.context.getMessages();
    }

    public ObjectMap getProperties() {
        return this.getContext().getProperties();
    }

    public BeanContext getBeanContext() {
        return this.getContext().getBeanContext();
    }
}

