/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.UriContext;
import org.apache.juneau.UriResolver;
import org.apache.juneau.dto.swagger.Swagger;
import org.apache.juneau.http.Accept;
import org.apache.juneau.http.AcceptCharset;
import org.apache.juneau.http.AcceptEncoding;
import org.apache.juneau.http.AcceptLanguage;
import org.apache.juneau.http.Authorization;
import org.apache.juneau.http.CacheControl;
import org.apache.juneau.http.Connection;
import org.apache.juneau.http.ContentLength;
import org.apache.juneau.http.ContentType;
import org.apache.juneau.http.Date;
import org.apache.juneau.http.Expect;
import org.apache.juneau.http.From;
import org.apache.juneau.http.Host;
import org.apache.juneau.http.HttpMethod;
import org.apache.juneau.http.IfMatch;
import org.apache.juneau.http.IfModifiedSince;
import org.apache.juneau.http.IfNoneMatch;
import org.apache.juneau.http.IfRange;
import org.apache.juneau.http.IfUnmodifiedSince;
import org.apache.juneau.http.MaxForwards;
import org.apache.juneau.http.Pragma;
import org.apache.juneau.http.ProxyAuthorization;
import org.apache.juneau.http.Range;
import org.apache.juneau.http.Referer;
import org.apache.juneau.http.TE;
import org.apache.juneau.http.Upgrade;
import org.apache.juneau.http.UserAgent;
import org.apache.juneau.http.Via;
import org.apache.juneau.http.Warning;
import org.apache.juneau.ini.ConfigFile;
import org.apache.juneau.internal.JuneauLogger;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.rest.RequestBody;
import org.apache.juneau.rest.RequestFormData;
import org.apache.juneau.rest.RequestHeaders;
import org.apache.juneau.rest.RequestPathMatch;
import org.apache.juneau.rest.RequestQuery;
import org.apache.juneau.rest.RestContext;
import org.apache.juneau.rest.RestParam;
import org.apache.juneau.rest.RestParamType;
import org.apache.juneau.rest.RestRequest;
import org.apache.juneau.rest.RestResponse;
import org.apache.juneau.rest.RestServletException;
import org.apache.juneau.rest.annotation.FormData;
import org.apache.juneau.rest.annotation.HasFormData;
import org.apache.juneau.rest.annotation.HasQuery;
import org.apache.juneau.rest.annotation.Header;
import org.apache.juneau.rest.annotation.Query;
import org.apache.juneau.utils.MessageBundle;

class RestParamDefaults {
    static final Map<Class<?>, RestParam> STANDARD_RESOLVERS;

    RestParamDefaults() {
    }

    private static boolean isCollection(Type t) {
        return BeanContext.DEFAULT.getClassMeta(t, new Type[0]).isCollectionOrArray();
    }

    static {
        Class[] r;
        HashMap m = new HashMap();
        for (Class c : r = new Class[]{HttpServletRequestObject.class, RestRequestObject.class, HttpServletResponseObject.class, RestResponseObject.class, AcceptHeader.class, AcceptCharsetHeader.class, AcceptEncodingHeader.class, AcceptLanguageHeader.class, AuthorizationHeader.class, CacheControlHeader.class, ConnectionHeader.class, ContentLengthHeader.class, ContentTypeHeader.class, DateHeader.class, ExpectHeader.class, FromHeader.class, HostHeader.class, IfMatchHeader.class, IfModifiedSinceHeader.class, IfNoneMatchHeader.class, IfRangeHeader.class, IfUnmodifiedSinceHeader.class, MaxForwardsHeader.class, PragmaHeader.class, ProxyAuthorizationHeader.class, RangeHeader.class, RefererHeader.class, TEHeader.class, UserAgentHeader.class, UpgradeHeader.class, ViaHeader.class, WarningHeader.class, TimeZoneHeader.class, ResourceBundleObject.class, MessageBundleObject.class, InputStreamObject.class, ServletInputStreamObject.class, ReaderObject.class, OutputStreamObject.class, ServletOutputStreamObject.class, WriterObject.class, RequestHeadersObject.class, RequestQueryObject.class, RequestFormDataObject.class, HttpMethodObject.class, LoggerObject.class, JuneauLoggerObject.class, RestContextObject.class, ParserObject.class, LocaleObject.class, SwaggerObject.class, RequestPathMatchObject.class, RequestBodyObject.class, ConfigFileObject.class, UriContextObject.class, UriResolverObject.class}) {
            try {
                RestParam mpr = (RestParam)c.newInstance();
                m.put(mpr.forClass(), mpr);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        STANDARD_RESOLVERS = Collections.unmodifiableMap(m);
    }

    static final class UriResolverObject
    extends RestParam {
        protected UriResolverObject() {
            super(RestParamType.OTHER, null, (Type)((Object)UriResolver.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getUriResolver();
        }
    }

    static final class UriContextObject
    extends RestParam {
        protected UriContextObject() {
            super(RestParamType.OTHER, null, (Type)((Object)UriContext.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getUriContext();
        }
    }

    static final class ConfigFileObject
    extends RestParam {
        protected ConfigFileObject() {
            super(RestParamType.OTHER, null, (Type)((Object)ConfigFile.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getConfigFile();
        }
    }

    static final class RequestBodyObject
    extends RestParam {
        protected RequestBodyObject() {
            super(RestParamType.BODY, null, (Type)((Object)RequestBody.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getBody();
        }
    }

    static final class RequestPathMatchObject
    extends RestParam {
        protected RequestPathMatchObject() {
            super(RestParamType.OTHER, null, (Type)((Object)RequestPathMatch.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getPathMatch();
        }
    }

    static final class SwaggerObject
    extends RestParam {
        protected SwaggerObject() {
            super(RestParamType.OTHER, null, (Type)((Object)Swagger.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getSwagger();
        }
    }

    static final class LocaleObject
    extends RestParam {
        protected LocaleObject() {
            super(RestParamType.OTHER, null, (Type)((Object)Locale.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getLocale();
        }
    }

    static final class ParserObject
    extends RestParam {
        protected ParserObject() {
            super(RestParamType.OTHER, null, (Type)((Object)Parser.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getBody().getParser();
        }
    }

    static final class RestContextObject
    extends RestParam {
        protected RestContextObject() {
            super(RestParamType.OTHER, null, (Type)((Object)RestContext.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getContext();
        }
    }

    static final class JuneauLoggerObject
    extends RestParam {
        protected JuneauLoggerObject() {
            super(RestParamType.OTHER, null, (Type)((Object)JuneauLogger.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getContext().getLogger().getLogger();
        }
    }

    static final class LoggerObject
    extends RestParam {
        protected LoggerObject() {
            super(RestParamType.OTHER, null, (Type)((Object)Logger.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getContext().getLogger().getLogger();
        }
    }

    static final class HttpMethodObject
    extends RestParam {
        protected HttpMethodObject() {
            super(RestParamType.OTHER, null, (Type)((Object)HttpMethod.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getHttpMethod();
        }
    }

    static final class RequestFormDataObject
    extends RestParam {
        protected RequestFormDataObject() {
            super(RestParamType.OTHER, null, (Type)((Object)RequestFormData.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getFormData();
        }
    }

    static final class RequestQueryObject
    extends RestParam {
        protected RequestQueryObject() {
            super(RestParamType.OTHER, null, (Type)((Object)RequestQuery.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getQuery();
        }
    }

    static final class RequestHeadersObject
    extends RestParam {
        protected RequestHeadersObject() {
            super(RestParamType.OTHER, null, (Type)((Object)RequestHeaders.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getHeaders();
        }
    }

    static final class WriterObject
    extends RestParam {
        protected WriterObject() {
            super(RestParamType.OTHER, null, (Type)((Object)Writer.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return res.getWriter();
        }
    }

    static final class ServletOutputStreamObject
    extends RestParam {
        protected ServletOutputStreamObject() {
            super(RestParamType.OTHER, null, (Type)((Object)ServletOutputStream.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return res.getOutputStream();
        }
    }

    static final class OutputStreamObject
    extends RestParam {
        protected OutputStreamObject() {
            super(RestParamType.OTHER, null, (Type)((Object)OutputStream.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return res.getOutputStream();
        }
    }

    static final class ReaderObject
    extends RestParam {
        protected ReaderObject() {
            super(RestParamType.OTHER, null, (Type)((Object)Reader.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getReader();
        }
    }

    static final class ServletInputStreamObject
    extends RestParam {
        protected ServletInputStreamObject() {
            super(RestParamType.OTHER, null, (Type)((Object)ServletInputStream.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getInputStream();
        }
    }

    static final class InputStreamObject
    extends RestParam {
        protected InputStreamObject() {
            super(RestParamType.OTHER, null, (Type)((Object)InputStream.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getInputStream();
        }
    }

    static final class MessageBundleObject
    extends RestParam {
        protected MessageBundleObject() {
            super(RestParamType.OTHER, null, (Type)((Object)MessageBundle.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getResourceBundle();
        }
    }

    static final class ResourceBundleObject
    extends RestParam {
        protected ResourceBundleObject() {
            super(RestParamType.OTHER, null, (Type)((Object)ResourceBundle.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getResourceBundle();
        }
    }

    static final class PropsObject
    extends RestParam {
        protected PropsObject(Method method, Type type) throws ServletException {
            super(RestParamType.OTHER, null, null);
            if (type != ObjectMap.class) {
                throw new RestServletException("Use of @Properties annotation on parameter that is not an ObjectMap on method ''{0}''", method);
            }
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getProperties();
        }
    }

    static final class PathRemainderObject
    extends RestParam {
        protected PathRemainderObject(Method method, Type type) throws ServletException {
            super(RestParamType.OTHER, null, null);
            if (type != String.class) {
                throw new RestServletException("Use of @PathRemainder annotation on parameter that is not a String on method ''{0}''", method);
            }
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getPathMatch().getRemainder();
        }
    }

    static final class HasQueryObject
    extends RestParam {
        protected HasQueryObject(Method method, HasQuery a, Type type) throws ServletException {
            super(RestParamType.QUERY, StringUtils.firstNonEmpty((String[])new String[]{a.name(), a.value()}), type);
            if (type != Boolean.class && type != Boolean.TYPE) {
                throw new RestServletException("Use of @HasQuery annotation on parameter that is not a boolean on method ''{0}''", method);
            }
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            BeanSession bs = req.getBeanSession();
            return bs.convertToType((Object)req.getQuery().containsKey(this.name), bs.getClassMeta(this.type, new Type[0]));
        }
    }

    static final class HasFormDataObject
    extends RestParam {
        protected HasFormDataObject(Method method, HasFormData a, Type type) throws ServletException {
            super(RestParamType.FORMDATA, StringUtils.firstNonEmpty((String[])new String[]{a.name(), a.value()}), type);
            if (type != Boolean.class && type != Boolean.TYPE) {
                throw new RestServletException("Use of @HasForm annotation on parameter that is not a boolean on method ''{0}''", method);
            }
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            BeanSession bs = req.getBeanSession();
            return bs.convertToType((Object)req.getFormData().containsKey(this.name), bs.getClassMeta(this.type, new Type[0]));
        }
    }

    static final class QueryObject
    extends RestParam {
        private final boolean multiPart;
        private final boolean plainParams;

        protected QueryObject(Method method, Query a, Type type, boolean methodPlainParams) throws ServletException {
            super(RestParamType.QUERY, StringUtils.firstNonEmpty((String[])new String[]{a.name(), a.value()}), type);
            if (a.multipart() && !RestParamDefaults.isCollection(type)) {
                throw new RestServletException("Use of multipart flag on @Query parameter that's not an array or Collection on method ''{0}''", method);
            }
            this.multiPart = a.multipart();
            this.plainParams = a.format().equals("INHERIT") ? methodPlainParams : a.format().equals("PLAIN");
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            BeanSession bs = req.getBeanSession();
            if (this.multiPart) {
                return req.getQuery().getAll(this.name, this.type, new Type[0]);
            }
            if (this.plainParams) {
                return bs.convertToType((Object)req.getQuery().getString(this.name), bs.getClassMeta(this.type, new Type[0]));
            }
            return req.getQuery().get(this.name, this.type, new Type[0]);
        }
    }

    static final class FormDataObject
    extends RestParam {
        private final boolean multiPart;
        private final boolean plainParams;

        protected FormDataObject(Method method, FormData a, Type type, boolean methodPlainParams) throws ServletException {
            super(RestParamType.FORMDATA, StringUtils.firstNonEmpty((String[])new String[]{a.name(), a.value()}), type);
            if (a.multipart() && !RestParamDefaults.isCollection(type)) {
                throw new RestServletException("Use of multipart flag on @FormData parameter that's not an array or Collection on method ''{0}''", method);
            }
            this.multiPart = a.multipart();
            this.plainParams = a.format().equals("INHERIT") ? methodPlainParams : a.format().equals("PLAIN");
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            BeanSession bs = req.getBeanSession();
            if (this.multiPart) {
                return req.getFormData().getAll(this.name, this.type, new Type[0]);
            }
            if (this.plainParams) {
                return bs.convertToType((Object)req.getFormData().getString(this.name), bs.getClassMeta(this.type, new Type[0]));
            }
            return req.getFormData().get(this.name, this.type, new Type[0]);
        }
    }

    static final class MethodObject
    extends RestParam {
        protected MethodObject(Method method, Type type) throws ServletException {
            super(RestParamType.OTHER, null, null);
            if (type != String.class) {
                throw new RestServletException("Use of @Method annotation on parameter that is not a String on method ''{0}''", method);
            }
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getMethod();
        }
    }

    static final class HeaderObject
    extends RestParam {
        protected HeaderObject(Header a, Type type) {
            super(RestParamType.HEADER, StringUtils.firstNonEmpty((String[])new String[]{a.name(), a.value()}), type);
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getHeaders().get(this.name, this.type, new Type[0]);
        }
    }

    static final class BodyObject
    extends RestParam {
        protected BodyObject(Type type) {
            super(RestParamType.BODY, null, type);
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getBody().asType(this.type, new Type[0]);
        }
    }

    static final class PathParameterObject
    extends RestParam {
        protected PathParameterObject(String name, Type type) {
            super(RestParamType.PATH, name, type);
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) throws Exception {
            return req.getPathMatch().get(this.name, this.type, new Type[0]);
        }
    }

    static final class TimeZoneHeader
    extends RestParam {
        protected TimeZoneHeader() {
            super(RestParamType.HEADER, "Time-Zone", (Type)((Object)TimeZone.class));
        }

        @Override
        public TimeZone resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getTimeZone();
        }
    }

    static final class WarningHeader
    extends RestParam {
        protected WarningHeader() {
            super(RestParamType.HEADER, "Warning", (Type)((Object)Warning.class));
        }

        public Warning resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getWarning();
        }
    }

    static final class ViaHeader
    extends RestParam {
        protected ViaHeader() {
            super(RestParamType.HEADER, "Via", (Type)((Object)Via.class));
        }

        public Via resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getVia();
        }
    }

    static final class UpgradeHeader
    extends RestParam {
        protected UpgradeHeader() {
            super(RestParamType.HEADER, "Upgrade", (Type)((Object)Upgrade.class));
        }

        public Upgrade resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getUpgrade();
        }
    }

    static final class UserAgentHeader
    extends RestParam {
        protected UserAgentHeader() {
            super(RestParamType.HEADER, "User-Agent", (Type)((Object)UserAgent.class));
        }

        public UserAgent resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getUserAgent();
        }
    }

    static final class TEHeader
    extends RestParam {
        protected TEHeader() {
            super(RestParamType.HEADER, "TE", (Type)((Object)TE.class));
        }

        public TE resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getTE();
        }
    }

    static final class RefererHeader
    extends RestParam {
        protected RefererHeader() {
            super(RestParamType.HEADER, "Referer", (Type)((Object)Referer.class));
        }

        public Referer resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getReferer();
        }
    }

    static final class RangeHeader
    extends RestParam {
        protected RangeHeader() {
            super(RestParamType.HEADER, "Range", (Type)((Object)Range.class));
        }

        public Range resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getRange();
        }
    }

    static final class ProxyAuthorizationHeader
    extends RestParam {
        protected ProxyAuthorizationHeader() {
            super(RestParamType.HEADER, "Proxy-Authorization", (Type)((Object)ProxyAuthorization.class));
        }

        public ProxyAuthorization resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getProxyAuthorization();
        }
    }

    static final class PragmaHeader
    extends RestParam {
        protected PragmaHeader() {
            super(RestParamType.HEADER, "Pragma", (Type)((Object)Pragma.class));
        }

        public Pragma resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getPragma();
        }
    }

    static final class MaxForwardsHeader
    extends RestParam {
        protected MaxForwardsHeader() {
            super(RestParamType.HEADER, "Max-Forwards", (Type)((Object)MaxForwards.class));
        }

        public MaxForwards resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getMaxForwards();
        }
    }

    static final class IfUnmodifiedSinceHeader
    extends RestParam {
        protected IfUnmodifiedSinceHeader() {
            super(RestParamType.HEADER, "If-Unmodified-Since", (Type)((Object)IfUnmodifiedSince.class));
        }

        public IfUnmodifiedSince resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getIfUnmodifiedSince();
        }
    }

    static final class IfRangeHeader
    extends RestParam {
        protected IfRangeHeader() {
            super(RestParamType.HEADER, "If-Range", (Type)((Object)IfRange.class));
        }

        public IfRange resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getIfRange();
        }
    }

    static final class IfNoneMatchHeader
    extends RestParam {
        protected IfNoneMatchHeader() {
            super(RestParamType.HEADER, "If-None-Match", (Type)((Object)IfNoneMatch.class));
        }

        public IfNoneMatch resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getIfNoneMatch();
        }
    }

    static final class IfModifiedSinceHeader
    extends RestParam {
        protected IfModifiedSinceHeader() {
            super(RestParamType.HEADER, "If-Modified-Since", (Type)((Object)IfModifiedSince.class));
        }

        public IfModifiedSince resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getIfModifiedSince();
        }
    }

    static final class IfMatchHeader
    extends RestParam {
        protected IfMatchHeader() {
            super(RestParamType.HEADER, "If-Match", (Type)((Object)IfMatch.class));
        }

        public IfMatch resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getIfMatch();
        }
    }

    static final class HostHeader
    extends RestParam {
        protected HostHeader() {
            super(RestParamType.HEADER, "Host", (Type)((Object)Host.class));
        }

        public Host resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getHost();
        }
    }

    static final class FromHeader
    extends RestParam {
        protected FromHeader() {
            super(RestParamType.HEADER, "From", (Type)((Object)From.class));
        }

        public From resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getFrom();
        }
    }

    static final class ExpectHeader
    extends RestParam {
        protected ExpectHeader() {
            super(RestParamType.HEADER, "Expect", (Type)((Object)Expect.class));
        }

        public Expect resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getExpect();
        }
    }

    static final class DateHeader
    extends RestParam {
        protected DateHeader() {
            super(RestParamType.HEADER, "Date", (Type)((Object)Date.class));
        }

        public Date resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getDate();
        }
    }

    static final class ContentTypeHeader
    extends RestParam {
        protected ContentTypeHeader() {
            super(RestParamType.HEADER, "Content-Type", (Type)((Object)ContentType.class));
        }

        public ContentType resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getContentType();
        }
    }

    static final class ContentLengthHeader
    extends RestParam {
        protected ContentLengthHeader() {
            super(RestParamType.HEADER, "Content-Length", (Type)((Object)ContentLength.class));
        }

        public ContentLength resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getContentLength();
        }
    }

    static final class ConnectionHeader
    extends RestParam {
        protected ConnectionHeader() {
            super(RestParamType.HEADER, "Connection", (Type)((Object)Connection.class));
        }

        public Connection resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getConnection();
        }
    }

    static final class CacheControlHeader
    extends RestParam {
        protected CacheControlHeader() {
            super(RestParamType.HEADER, "Cache-Control", (Type)((Object)CacheControl.class));
        }

        public CacheControl resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getCacheControl();
        }
    }

    static final class AuthorizationHeader
    extends RestParam {
        protected AuthorizationHeader() {
            super(RestParamType.HEADER, "Authorization", (Type)((Object)Authorization.class));
        }

        public Authorization resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getAuthorization();
        }
    }

    static final class AcceptLanguageHeader
    extends RestParam {
        protected AcceptLanguageHeader() {
            super(RestParamType.HEADER, "Accept-Language", (Type)((Object)AcceptLanguage.class));
        }

        public AcceptLanguage resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getAcceptLanguage();
        }
    }

    static final class AcceptEncodingHeader
    extends RestParam {
        protected AcceptEncodingHeader() {
            super(RestParamType.HEADER, "Accept-Encoding", (Type)((Object)AcceptEncoding.class));
        }

        public AcceptEncoding resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getAcceptEncoding();
        }
    }

    static final class AcceptCharsetHeader
    extends RestParam {
        protected AcceptCharsetHeader() {
            super(RestParamType.HEADER, "Accept-Charset", (Type)((Object)AcceptCharset.class));
        }

        public AcceptCharset resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getAcceptCharset();
        }
    }

    static final class AcceptHeader
    extends RestParam {
        protected AcceptHeader() {
            super(RestParamType.HEADER, "Accept-Header", (Type)((Object)Accept.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) {
            return req.getHeaders().getAccept();
        }
    }

    static final class RestResponseObject
    extends RestParam {
        protected RestResponseObject() {
            super(RestParamType.OTHER, null, (Type)((Object)RestResponse.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) {
            return res;
        }
    }

    static final class RestRequestObject
    extends RestParam {
        protected RestRequestObject() {
            super(RestParamType.OTHER, null, (Type)((Object)RestRequest.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) {
            return req;
        }
    }

    static final class HttpServletResponseObject
    extends RestParam {
        protected HttpServletResponseObject() {
            super(RestParamType.OTHER, null, (Type)((Object)HttpServletResponse.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) {
            return res;
        }
    }

    static final class HttpServletRequestObject
    extends RestParam {
        protected HttpServletRequestObject() {
            super(RestParamType.OTHER, null, (Type)((Object)HttpServletRequest.class));
        }

        @Override
        public Object resolve(RestRequest req, RestResponse res) {
            return req;
        }
    }
}

