/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.juneau.Writable;
import org.apache.juneau.http.MediaType;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.svl.VarResolverSession;

public class ReaderResource
implements Writable {
    private final MediaType mediaType;
    private final String[] contents;
    private final VarResolverSession varSession;
    private final Map<String, String> headers;

    protected ReaderResource(MediaType mediaType, Object ... contents) throws IOException {
        this(mediaType, null, null, contents);
    }

    public ReaderResource(MediaType mediaType, Map<String, String> headers, VarResolverSession varSession, Object ... contents) throws IOException {
        this.mediaType = mediaType;
        this.varSession = varSession;
        LinkedHashMap<String, String> m = new LinkedHashMap<String, String>();
        if (headers != null) {
            for (Map.Entry<String, String> e : headers.entrySet()) {
                m.put(e.getKey(), StringUtils.toString((Object)e.getValue()));
            }
        }
        this.headers = Collections.unmodifiableMap(m);
        this.contents = new String[contents.length];
        for (int i = 0; i < contents.length; ++i) {
            Object c = contents[i];
            if (c == null) {
                this.contents[i] = "";
                continue;
            }
            if (c instanceof InputStream) {
                this.contents[i] = IOUtils.read((InputStream)((InputStream)c));
                continue;
            }
            if (c instanceof File) {
                this.contents[i] = IOUtils.read((File)((File)c));
                continue;
            }
            if (c instanceof Reader) {
                this.contents[i] = IOUtils.read((Reader)((Reader)c));
                continue;
            }
            if (c instanceof CharSequence) {
                this.contents[i] = ((CharSequence)c).toString();
                continue;
            }
            throw new IOException("Invalid class type passed to ReaderResource: " + c.getClass().getName());
        }
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void writeTo(Writer w) throws IOException {
        for (String s : this.contents) {
            if (this.varSession != null) {
                this.varSession.resolveTo(s, w);
                continue;
            }
            w.write(s);
        }
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public String toString() {
        if (this.contents.length == 1 && this.varSession == null) {
            return this.contents[0];
        }
        StringWriter sw = new StringWriter();
        for (String s : this.contents) {
            if (this.varSession != null) {
                return this.varSession.resolve(s);
            }
            sw.write(s);
        }
        return sw.toString();
    }

    public String toCommentStrippedString() {
        String s = this.toString();
        String subType = this.mediaType.getSubType();
        if ("html".equals(subType) || "xhtml".equals(subType) || "xml".equals(subType)) {
            s = s.replaceAll("(?s)<!--(.*?)-->\\s*", "");
        } else if ("json".equals(subType) || "javascript".equals(subType) || "css".equals(subType)) {
            s = s.replaceAll("(?s)\\/\\*(.*?)\\*\\/\\s*", "");
        }
        return s;
    }

    public static class Builder {
        ArrayList<Object> contents = new ArrayList();
        MediaType mediaType;
        VarResolverSession varResolver;
        Map<String, String> headers = new LinkedHashMap<String, String>();

        public Builder mediaType(String mediaType) {
            this.mediaType = MediaType.forString((String)mediaType);
            return this;
        }

        public Builder mediaType(MediaType mediaType) {
            this.mediaType = mediaType;
            return this;
        }

        public Builder contents(Object ... contents) {
            this.contents.addAll(Arrays.asList(contents));
            return this;
        }

        public Builder header(String name, Object value) {
            this.headers.put(name, StringUtils.toString((Object)value));
            return this;
        }

        public Builder headers(Map<String, Object> headers) {
            for (Map.Entry<String, Object> e : headers.entrySet()) {
                this.header(e.getKey(), e.getValue());
            }
            return this;
        }

        public Builder varResolver(VarResolverSession varResolver) {
            this.varResolver = varResolver;
            return this;
        }

        public ReaderResource build() throws IOException {
            return new ReaderResource(this.mediaType, this.headers, this.varResolver, this.contents.toArray());
        }
    }
}

