/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.ini;

import org.apache.juneau.ini.Encoder;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.StringUtils;

public final class XorEncoder
implements Encoder {
    public static final XorEncoder INSTANCE = new XorEncoder();
    private static final String key = System.getProperty("org.apache.juneau.ini.XorEncoder.key", "nuy7og796Vh6G9O6bG230SHK0cc8QYkH");

    @Override
    public String encode(String fieldName, String in) {
        byte[] b = in.getBytes(IOUtils.UTF8);
        for (int i = 0; i < b.length; ++i) {
            int j = i % key.length();
            b[i] = (byte)(b[i] ^ key.charAt(j));
        }
        return StringUtils.base64Encode((byte[])b);
    }

    @Override
    public String decode(String fieldName, String in) {
        byte[] b = StringUtils.base64Decode((String)in);
        for (int i = 0; i < b.length; ++i) {
            int j = i % key.length();
            b[i] = (byte)(b[i] ^ key.charAt(j));
        }
        return new String(b, IOUtils.UTF8);
    }
}

