/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.ini;

import java.io.PrintWriter;
import java.util.AbstractSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.juneau.annotation.NameProperty;
import org.apache.juneau.annotation.ParentProperty;
import org.apache.juneau.ini.ConfigFileFormat;
import org.apache.juneau.ini.ConfigFileImpl;
import org.apache.juneau.ini.ConfigFileListener;
import org.apache.juneau.ini.ConfigUtils;
import org.apache.juneau.internal.StringUtils;

public class Section
implements Map<String, String> {
    private ConfigFileImpl configFile;
    String name;
    private LinkedList<String> lines = new LinkedList();
    private List<String> headerComments = new LinkedList<String>();
    private Map<String, String> entries;
    private ReadWriteLock lock = new ReentrantReadWriteLock();
    private boolean readOnly;

    public Section() {
        this.entries = new LinkedHashMap<String, String>();
    }

    public Section(Map<String, String> contents) {
        this.entries = new LinkedHashMap<String, String>(contents);
    }

    Section setReadOnly() {
        this.readOnly = true;
        this.entries = Collections.unmodifiableMap(this.entries);
        return this;
    }

    @ParentProperty
    public Section setParent(ConfigFileImpl configFile) {
        this.configFile = configFile;
        return this;
    }

    @NameProperty
    public Section setName(String name) {
        this.name = name;
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        Set<String> changes = this.createChanges();
        this.writeLock();
        try {
            if (changes != null) {
                for (String k : this.keySet()) {
                    changes.add(ConfigUtils.getFullKey(this.name, k));
                }
            }
            this.entries.clear();
            this.lines.clear();
            this.headerComments.clear();
        }
        finally {
            this.writeUnlock();
        }
        this.signalChanges(changes);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.entries.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.entries.containsValue(value);
    }

    @Override
    public Set<Map.Entry<String, String>> entrySet() {
        return new AbstractSet<Map.Entry<String, String>>(){

            @Override
            public Iterator<Map.Entry<String, String>> iterator() {
                return new Iterator<Map.Entry<String, String>>(){
                    Iterator<Map.Entry<String, String>> i;
                    Map.Entry<String, String> i2;
                    {
                        this.i = Section.this.entries.entrySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public Map.Entry<String, String> next() {
                        this.i2 = this.i.next();
                        return this.i2;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void remove() {
                        Set changes = Section.this.createChanges();
                        String key = this.i2.getKey();
                        String val = this.i2.getValue();
                        Section.this.addChange(changes, key, val, null);
                        Section.this.writeLock();
                        try {
                            this.i.remove();
                            Section.this.removeLine(key);
                        }
                        finally {
                            Section.this.writeUnlock();
                        }
                        Section.this.signalChanges(changes);
                    }
                };
            }

            @Override
            public int size() {
                return Section.this.entries.size();
            }
        };
    }

    @Override
    public String get(Object key) {
        String s = this.entries.get(key);
        return s;
    }

    @Override
    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    @Override
    public Set<String> keySet() {
        return new AbstractSet<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    Iterator<String> i;
                    String i2;
                    {
                        this.i = Section.this.entries.keySet().iterator();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public String next() {
                        this.i2 = this.i.next();
                        return this.i2;
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    @Override
                    public void remove() {
                        Set changes = Section.this.createChanges();
                        String key = this.i2;
                        String val = (String)Section.this.entries.get(key);
                        Section.this.addChange(changes, key, val, null);
                        Section.this.writeLock();
                        try {
                            this.i.remove();
                            Section.this.removeLine(key);
                        }
                        finally {
                            Section.this.writeUnlock();
                        }
                        Section.this.signalChanges(changes);
                    }
                };
            }

            @Override
            public int size() {
                return Section.this.entries.size();
            }
        };
    }

    @Override
    public String put(String key, String value) {
        return this.put(key, value, false);
    }

    public String put(String key, String value, boolean encoded) {
        Set<String> changes = this.createChanges();
        String s = this.put(key, value, encoded, changes);
        this.signalChanges(changes);
        return s;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String put(String key, String value, boolean encoded, Set<String> changes) {
        this.writeLock();
        try {
            this.addLine(key, encoded);
            String prev = this.entries.put(key, value);
            this.addChange(changes, key, prev, value);
            String string = prev;
            return string;
        }
        finally {
            this.writeUnlock();
        }
    }

    @Override
    public void putAll(Map<? extends String, ? extends String> map) {
        Set<String> changes = this.createChanges();
        for (Map.Entry<? extends String, ? extends String> e : map.entrySet()) {
            this.put(e.getKey(), e.getValue(), false, changes);
        }
        this.signalChanges(changes);
    }

    @Override
    public String remove(Object key) {
        Set<String> changes = this.createChanges();
        String old = this.remove(key, changes);
        this.signalChanges(changes);
        return old;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    String remove(Object key, Set<String> changes) {
        this.writeLock();
        try {
            String prev = this.entries.remove(key);
            this.addChange(changes, key.toString(), prev, null);
            this.removeLine(key.toString());
            String string = prev;
            return string;
        }
        finally {
            this.writeUnlock();
        }
    }

    private void removeLine(String key) {
        Iterator i = this.lines.iterator();
        while (i.hasNext()) {
            String k = (String)i.next();
            if (!k.startsWith("*") && !k.startsWith(">") || !k.substring(1).equals(key)) continue;
            i.remove();
            break;
        }
    }

    @Override
    public int size() {
        return this.entries.size();
    }

    @Override
    public Collection<String> values() {
        return Collections.unmodifiableCollection(this.entries.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isEncoded(String key) {
        this.readLock();
        try {
            for (String s : this.lines) {
                if (s.length() <= 1 || !s.substring(1).equals(key)) continue;
                boolean bl = s.charAt(0) == '*';
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Section addHeaderComments(List<String> comments) {
        this.writeLock();
        try {
            for (String c : comments) {
                if (c == null) {
                    c = "";
                }
                if (!c.startsWith("#")) {
                    c = "#" + c;
                }
                this.headerComments.add(c);
            }
            Section section = this;
            return section;
        }
        finally {
            this.writeUnlock();
        }
    }

    public void clearHeaderComments() {
        this.writeLock();
        try {
            this.headerComments.clear();
        }
        finally {
            this.writeUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeTo(PrintWriter out, ConfigFileFormat format) {
        this.readLock();
        try {
            if (format == ConfigFileFormat.INI) {
                for (String s : this.headerComments) {
                    out.append(s).println();
                }
                if (!this.name.equals("default")) {
                    out.append('[').append(this.name).append(']').println();
                }
                for (String l : this.lines) {
                    char c;
                    char c2 = c = l.length() > 0 ? l.charAt(0) : (char)'\u0000';
                    if (c == '>' || c == '*') {
                        boolean encode = c == '*';
                        String key = l.substring(1);
                        String val = this.entries.get(key);
                        if (val.indexOf(10) != -1) {
                            val = val.replaceAll("(\\r?\\n)", "$1\t");
                        }
                        if (val.indexOf(61) != -1) {
                            val = val.replace("=", "\\u003D");
                        }
                        if (val.indexOf(35) != -1) {
                            val = val.replace("#", "\\u0023");
                        }
                        out.append(key);
                        if (encode) {
                            out.append('*');
                        }
                        out.append(" = ");
                        if (encode) {
                            out.append('{').append(this.configFile.getEncoder().encode(key, val)).append('}');
                        } else {
                            out.append(val);
                        }
                        out.println();
                        continue;
                    }
                    out.append(l).println();
                }
            } else if (format == ConfigFileFormat.BATCH) {
                String section = this.name.replaceAll("\\.\\/", "_");
                for (String l : this.headerComments) {
                    if (!(l = Section.trimComment(l)).isEmpty()) {
                        out.append("rem ").append(l);
                    }
                    out.println();
                }
                for (String l : this.lines) {
                    char c;
                    char c3 = c = l.length() > 0 ? l.charAt(0) : (char)'\u0000';
                    if (c == '>' || c == '*') {
                        String key = l.substring(1);
                        String val = this.entries.get(key);
                        out.append("set ");
                        if (!this.name.equals("default")) {
                            out.append(section).append('_');
                        }
                        out.append(key.replaceAll("\\.\\/", "_")).append(" = ").append(val).println();
                        continue;
                    }
                    if (!(l = Section.trimComment(l)).isEmpty()) {
                        out.append("rem ").append(l);
                    }
                    out.println();
                }
            } else if (format == ConfigFileFormat.SHELL) {
                String section = this.name.replaceAll("\\.\\/", "_");
                for (String l : this.headerComments) {
                    if (!(l = Section.trimComment(l)).isEmpty()) {
                        out.append("# ").append(l);
                    }
                    out.println();
                }
                for (String l : this.lines) {
                    char c;
                    char c4 = c = l.length() > 0 ? l.charAt(0) : (char)'\u0000';
                    if (c == '>' || c == '*') {
                        String key = l.substring(1);
                        String val = this.entries.get(key).replaceAll("\\\\", "\\\\\\\\");
                        out.append("export ");
                        if (!this.name.equals("default")) {
                            out.append(section).append('_');
                        }
                        out.append(key.replaceAll("\\.\\/", "_")).append('=').append('\"').append(val).append('\"').println();
                        continue;
                    }
                    if (!(l = Section.trimComment(l)).isEmpty()) {
                        out.append("# ").append(l);
                    }
                    out.println();
                }
            }
        }
        finally {
            this.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Section addLines(Set<String> changes, String ... l) {
        this.writeLock();
        try {
            if (l == null) {
                l = new String[]{};
            }
            for (int i = 0; i < l.length; ++i) {
                String line = l[i];
                if (line == null) {
                    line = "";
                }
                if (ConfigUtils.isComment(line)) {
                    this.lines.add(line);
                    continue;
                }
                if (ConfigUtils.isAssignment(line)) {
                    boolean encoded;
                    String key = StringUtils.replaceUnicodeSequences((String)line.substring(0, line.indexOf(61)).trim());
                    String val = StringUtils.replaceUnicodeSequences((String)line.substring(line.indexOf(61) + 1).trim());
                    boolean bl = encoded = key.length() > 1 && key.endsWith("*");
                    if (encoded) {
                        key = key.substring(0, key.lastIndexOf(42));
                        String v = val.toString().trim();
                        if (v.startsWith("{") && v.endsWith("}")) {
                            val = this.configFile.getEncoder().decode(key, v.substring(1, v.length() - 1));
                        } else {
                            this.configFile.setHasBeenModified();
                        }
                    }
                    if (this.containsKey(key)) {
                        this.entries.remove(key);
                        this.lines.remove('*' + key);
                        this.lines.remove('>' + key);
                    }
                    this.lines.add((encoded ? (char)'*' : '>') + key);
                    this.addChange(changes, key, this.entries.put(key, val), val);
                    continue;
                }
                this.lines.add(line);
            }
            Section section = this;
            return section;
        }
        finally {
            this.writeUnlock();
        }
    }

    List<String> removeTrailingComments() {
        LinkedList<String> l = new LinkedList<String>();
        while (!this.lines.isEmpty() && this.lines.getLast().startsWith("#")) {
            l.addFirst(this.lines.removeLast());
        }
        return l;
    }

    private void addLine(String key, boolean encoded) {
        Iterator i = this.lines.iterator();
        while (i.hasNext()) {
            String k = (String)i.next();
            if (!k.startsWith("*") && !k.startsWith(">") || !k.substring(1).equals(key)) continue;
            if (k.startsWith("*") && encoded || k.startsWith(">") && !encoded) {
                return;
            }
            i.remove();
        }
        this.lines.add((encoded ? "*" : ">") + key);
    }

    private void readLock() {
        this.lock.readLock().lock();
    }

    private void readUnlock() {
        this.lock.readLock().unlock();
    }

    private void writeLock() {
        if (this.readOnly) {
            throw new UnsupportedOperationException("Cannot modify read-only ConfigFile.");
        }
        this.lock.writeLock().lock();
    }

    private void writeUnlock() {
        this.lock.writeLock().unlock();
    }

    private static String trimComment(String s) {
        return s.replaceAll("^\\s*\\#\\s*", "").trim();
    }

    private Set<String> createChanges() {
        return this.configFile != null && this.configFile.getListeners().size() > 0 ? new LinkedHashSet() : null;
    }

    private void signalChanges(Set<String> changes) {
        if (changes != null && !changes.isEmpty()) {
            for (ConfigFileListener l : this.configFile.getListeners()) {
                l.onChange(this.configFile, changes);
            }
        }
    }

    private void addChange(Set<String> changes, String key, String oldVal, String newVal) {
        if (changes != null && !StringUtils.isEquals((String)oldVal, (String)newVal)) {
            changes.add(ConfigUtils.getFullKey(this.name, key));
        }
    }
}

