/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.Future;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.StatusLine;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.apache.juneau.BeanContext;
import org.apache.juneau.BeanMap;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.FormattedRuntimeException;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PartType;
import org.apache.juneau.internal.ByteArrayInOutStream;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.internal.ObjectUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.internal.TeeOutputStream;
import org.apache.juneau.internal.TeeWriter;
import org.apache.juneau.parser.InputStreamParser;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.parser.ReaderParser;
import org.apache.juneau.rest.client.NameValuePairs;
import org.apache.juneau.rest.client.ResponsePattern;
import org.apache.juneau.rest.client.RestCallException;
import org.apache.juneau.rest.client.RestCallInterceptor;
import org.apache.juneau.rest.client.RestCallLogger;
import org.apache.juneau.rest.client.RestClient;
import org.apache.juneau.rest.client.RestRequestEntity;
import org.apache.juneau.rest.client.RetryOn;
import org.apache.juneau.rest.client.SerializedNameValuePair;
import org.apache.juneau.serializer.PartSerializer;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;
import org.apache.juneau.utils.IOPipe;
import org.apache.juneau.utils.PojoRest;

public final class RestCall {
    private final RestClient client;
    private final HttpRequestBase request;
    private HttpResponse response;
    private List<RestCallInterceptor> intercepters = new ArrayList<RestCallInterceptor>();
    private boolean isConnected = false;
    private boolean allowRedirectsOnPosts;
    private int retries = 1;
    private int redirectOnPostsTries = 5;
    private long retryInterval = -1L;
    private RetryOn retryOn;
    private boolean ignoreErrors;
    private boolean byLines = false;
    private TeeWriter writers = new TeeWriter(new Writer[0]);
    private StringWriter capturedResponseWriter;
    private String capturedResponse;
    private TeeOutputStream outputStreams = new TeeOutputStream(new OutputStream[0]);
    private boolean isClosed = false;
    private boolean isFailed = false;
    private Object input;
    private boolean hasInput;
    private Serializer serializer;
    private Parser parser;
    private URIBuilder uriBuilder;
    private NameValuePairs formData;

    protected RestCall(RestClient client, HttpRequestBase request, URI uri) throws RestCallException {
        this.client = client;
        this.request = request;
        for (RestCallInterceptor i : this.client.intercepters) {
            this.intercepter(i);
        }
        this.retryOn = client.retryOn;
        this.retries = client.retries;
        this.retryInterval = client.retryInterval;
        this.serializer = client.serializer;
        this.parser = client.parser;
        this.uriBuilder = new URIBuilder(uri);
    }

    public RestCall uri(Object uri) throws RestCallException {
        try {
            if (uri != null) {
                this.uriBuilder = new URIBuilder(this.client.toURI(uri));
            }
            return this;
        }
        catch (URISyntaxException e) {
            throw new RestCallException(e);
        }
    }

    public RestCall scheme(String scheme) {
        this.uriBuilder.setScheme(scheme);
        return this;
    }

    public RestCall host(String host) {
        this.uriBuilder.setHost(host);
        return this;
    }

    public RestCall port(int port) {
        this.uriBuilder.setPort(port);
        return this;
    }

    public RestCall query(String name, Object value, boolean skipIfEmpty, PartSerializer partSerializer) throws RestCallException {
        if (partSerializer == null) {
            partSerializer = this.client.getPartSerializer();
        }
        if (!"*".equals(name) && !StringUtils.isEmpty((String)name)) {
            if (!(value == null || ObjectUtils.isEmpty((Object)value) && skipIfEmpty)) {
                this.uriBuilder.addParameter(name, partSerializer.serialize(PartType.QUERY, value));
            }
        } else if (value instanceof NameValuePairs) {
            for (NameValuePair p : (NameValuePairs)value) {
                this.query(p.getName(), p.getValue(), skipIfEmpty, (PartSerializer)UrlEncodingSerializer.DEFAULT_PLAINTEXT);
            }
        } else if (value instanceof Map) {
            for (Map.Entry p : ((Map)value).entrySet()) {
                this.query((String)p.getKey(), p.getValue(), skipIfEmpty, partSerializer);
            }
        } else {
            if (this.isBean(value)) {
                return this.query(name, this.toBeanMap(value), skipIfEmpty, partSerializer);
            }
            if (value instanceof Reader) {
                try {
                    this.uriBuilder.setCustomQuery(IOUtils.read((Object)value));
                }
                catch (IOException e) {
                    throw new RestCallException(e);
                }
            } else if (value instanceof CharSequence) {
                String s = value.toString();
                if (!StringUtils.isEmpty((String)s)) {
                    this.uriBuilder.setCustomQuery(s);
                }
            } else {
                throw new FormattedRuntimeException("Invalid name ''{0}'' passed to query(name,value,skipIfEmpty) for data type ''{1}''", new Object[]{name, ClassUtils.getReadableClassNameForObject((Object)value)});
            }
        }
        return this;
    }

    public RestCall query(String name, Object value) throws RestCallException {
        return this.query(name, value, false, null);
    }

    public RestCall query(Map<String, Object> params) throws RestCallException {
        return this.query(null, params);
    }

    public RestCall queryIfNE(String name, Object value) throws RestCallException {
        return this.query(name, value, true, null);
    }

    public RestCall queryIfNE(Map<String, Object> params) throws RestCallException {
        return this.query(null, params, true, null);
    }

    public RestCall query(String query) {
        this.uriBuilder.setCustomQuery(query);
        return this;
    }

    public RestCall formData(String name, Object value, boolean skipIfEmpty, PartSerializer partSerializer) throws RestCallException {
        if (this.formData == null) {
            this.formData = new NameValuePairs();
        }
        if (partSerializer == null) {
            partSerializer = this.client.getPartSerializer();
        }
        if (!"*".equals(name) && !StringUtils.isEmpty((String)name)) {
            if (!(value == null || ObjectUtils.isEmpty((Object)value) && skipIfEmpty)) {
                this.formData.add(new SerializedNameValuePair(name, value, partSerializer));
            }
        } else if (value instanceof NameValuePairs) {
            for (NameValuePair p : (NameValuePairs)value) {
                if (p.getValue() == null || StringUtils.isEmpty((String)p.getValue()) && skipIfEmpty) continue;
                this.formData.add(p);
            }
        } else if (value instanceof Map) {
            for (Map.Entry p : ((Map)value).entrySet()) {
                this.formData((String)p.getKey(), p.getValue(), skipIfEmpty, partSerializer);
            }
        } else {
            if (this.isBean(value)) {
                return this.formData(name, this.toBeanMap(value), skipIfEmpty, partSerializer);
            }
            if (value instanceof Reader) {
                this.contentType("application/x-www-form-urlencoded");
                this.input(value);
            } else if (value instanceof CharSequence) {
                try {
                    this.contentType("application/x-www-form-urlencoded");
                    this.input(new StringEntity(value.toString()));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {}
            } else {
                throw new FormattedRuntimeException("Invalid name ''{0}'' passed to formData(name,value,skipIfEmpty) for data type ''{1}''", new Object[]{name, ClassUtils.getReadableClassNameForObject((Object)value)});
            }
        }
        return this;
    }

    public RestCall formData(String name, Object value) throws RestCallException {
        return this.formData(name, value, false, null);
    }

    public RestCall formData(NameValuePairs nameValuePairs) throws RestCallException {
        return this.formData(null, nameValuePairs);
    }

    public RestCall formData(Map<String, Object> params) throws RestCallException {
        return this.formData(null, params);
    }

    public RestCall formDataIfNE(String name, Object value) throws RestCallException {
        return this.formData(name, value, true, null);
    }

    public RestCall formDataIfNE(Map<String, Object> params) throws RestCallException {
        return this.formData(null, params, true, null);
    }

    public RestCall path(String name, Object value, PartSerializer partSerializer) throws RestCallException {
        String path = this.uriBuilder.getPath();
        if (partSerializer == null) {
            partSerializer = this.client.getPartSerializer();
        }
        if (!"*".equals(name) && !StringUtils.isEmpty((String)name)) {
            String var = "{" + name + "}";
            if (path.indexOf(var) == -1) {
                throw new RestCallException("Path variable {" + name + "} was not found in path.");
            }
            String newPath = path.replace(var, partSerializer.serialize(PartType.PATH, value));
            this.uriBuilder.setPath(newPath);
        } else if (value instanceof NameValuePairs) {
            for (NameValuePair p : (NameValuePairs)value) {
                this.path(p.getName(), p.getValue(), partSerializer);
            }
        } else if (value instanceof Map) {
            for (Map.Entry p : ((Map)value).entrySet()) {
                this.path((String)p.getKey(), p.getValue(), partSerializer);
            }
        } else {
            if (this.isBean(value)) {
                return this.path(name, this.toBeanMap(value), partSerializer);
            }
            if (value != null) {
                throw new FormattedRuntimeException("Invalid name ''{0}'' passed to path(name,value) for data type ''{1}''", new Object[]{name, ClassUtils.getReadableClassNameForObject((Object)value)});
            }
        }
        return this;
    }

    public RestCall path(String name, Object value) throws RestCallException {
        return this.path(name, value, null);
    }

    public RestCall userInfo(String userInfo) {
        this.uriBuilder.setUserInfo(userInfo);
        return this;
    }

    public RestCall userInfo(String username, String password) {
        this.uriBuilder.setUserInfo(username, password);
        return this;
    }

    public RestCall input(Object input) throws RestCallException {
        this.input = input;
        this.hasInput = true;
        this.formData = null;
        return this;
    }

    public RestCall serializer(Serializer serializer) {
        this.serializer = serializer;
        return this;
    }

    public RestCall parser(Parser parser) {
        this.parser = parser;
        return this;
    }

    public RestCall header(String name, Object value, boolean skipIfEmpty, PartSerializer partSerializer) throws RestCallException {
        if (partSerializer == null) {
            partSerializer = this.client.getPartSerializer();
        }
        if (!"*".equals(name) && !StringUtils.isEmpty((String)name)) {
            if (!(value == null || ObjectUtils.isEmpty((Object)value) && skipIfEmpty)) {
                this.request.setHeader(name, partSerializer.serialize(PartType.HEADER, value));
            }
        } else if (value instanceof NameValuePairs) {
            for (NameValuePair p : (NameValuePairs)value) {
                this.header(p.getName(), p.getValue(), skipIfEmpty, (PartSerializer)UrlEncodingSerializer.DEFAULT_PLAINTEXT);
            }
        } else if (value instanceof Map) {
            for (Map.Entry p : ((Map)value).entrySet()) {
                this.header((String)p.getKey(), p.getValue(), skipIfEmpty, partSerializer);
            }
        } else {
            if (this.isBean(value)) {
                return this.header(name, this.toBeanMap(value), skipIfEmpty, partSerializer);
            }
            throw new FormattedRuntimeException("Invalid name ''{0}'' passed to header(name,value,skipIfEmpty) for data type ''{1}''", new Object[]{name, ClassUtils.getReadableClassNameForObject((Object)value)});
        }
        return this;
    }

    public RestCall header(String name, Object value) throws RestCallException {
        return this.header(name, value, false, null);
    }

    public RestCall headers(Map<String, Object> values) throws RestCallException {
        return this.header(null, values, false, null);
    }

    public RestCall headerIfNE(String name, Object value) throws RestCallException {
        return this.header(name, value, true, null);
    }

    public RestCall headersIfNE(Map<String, Object> values) throws RestCallException {
        return this.header(null, values, true, null);
    }

    public RestCall accept(Object value) throws RestCallException {
        return this.header("Accept", value);
    }

    public RestCall acceptCharset(Object value) throws RestCallException {
        return this.header("Accept-Charset", value);
    }

    public RestCall acceptEncoding(Object value) throws RestCallException {
        return this.header("Accept-Encoding", value);
    }

    public RestCall acceptLanguage(Object value) throws RestCallException {
        return this.header("Accept-Language", value);
    }

    public RestCall authorization(Object value) throws RestCallException {
        return this.header("Authorization", value);
    }

    public RestCall cacheControl(Object value) throws RestCallException {
        return this.header("Cache-Control", value);
    }

    public RestCall connection(Object value) throws RestCallException {
        return this.header("Connection", value);
    }

    public RestCall contentLength(Object value) throws RestCallException {
        return this.header("Content-Length", value);
    }

    public RestCall contentType(Object value) throws RestCallException {
        return this.header("Content-Type", value);
    }

    public RestCall date(Object value) throws RestCallException {
        return this.header("Date", value);
    }

    public RestCall expect(Object value) throws RestCallException {
        return this.header("Expect", value);
    }

    public RestCall forwarded(Object value) throws RestCallException {
        return this.header("Forwarded", value);
    }

    public RestCall from(Object value) throws RestCallException {
        return this.header("From", value);
    }

    public RestCall host(Object value) throws RestCallException {
        return this.header("Host", value);
    }

    public RestCall ifMatch(Object value) throws RestCallException {
        return this.header("If-Match", value);
    }

    public RestCall ifModifiedSince(Object value) throws RestCallException {
        return this.header("If-Modified-Since", value);
    }

    public RestCall ifNoneMatch(Object value) throws RestCallException {
        return this.header("If-None-Match", value);
    }

    public RestCall ifRange(Object value) throws RestCallException {
        return this.header("If-Range", value);
    }

    public RestCall ifUnmodifiedSince(Object value) throws RestCallException {
        return this.header("If-Unmodified-Since", value);
    }

    public RestCall maxForwards(Object value) throws RestCallException {
        return this.header("Max-Forwards", value);
    }

    public RestCall origin(Object value) throws RestCallException {
        return this.header("Origin", value);
    }

    public RestCall pragma(Object value) throws RestCallException {
        return this.header("Pragma", value);
    }

    public RestCall proxyAuthorization(Object value) throws RestCallException {
        return this.header("Proxy-Authorization", value);
    }

    public RestCall range(Object value) throws RestCallException {
        return this.header("Range", value);
    }

    public RestCall referer(Object value) throws RestCallException {
        return this.header("Referer", value);
    }

    public RestCall te(Object value) throws RestCallException {
        return this.header("TE", value);
    }

    public RestCall userAgent(Object value) throws RestCallException {
        return this.header("User-Agent", value);
    }

    public RestCall upgrade(Object value) throws RestCallException {
        return this.header("Upgrade", value);
    }

    public RestCall via(Object value) throws RestCallException {
        return this.header("Via", value);
    }

    public RestCall warning(Object value) throws RestCallException {
        return this.header("Warning", value);
    }

    public RestCall clientVersion(String version) throws RestCallException {
        return this.header("X-Client-Version", version);
    }

    public RestCall retryable(int retries, long interval, RetryOn retryOn) throws RestCallException {
        HttpEntity e;
        if (this.request instanceof HttpEntityEnclosingRequestBase && this.input != null && this.input instanceof HttpEntity && (e = (HttpEntity)this.input) != null && !e.isRepeatable()) {
            throw new RestCallException("Attempt to make call retryable, but entity is not repeatable.");
        }
        this.retries = retries;
        this.retryInterval = interval;
        this.retryOn = retryOn == null ? RetryOn.DEFAULT : retryOn;
        return this;
    }

    public RestCall allowRedirectsOnPosts(boolean b) {
        this.allowRedirectsOnPosts = b;
        return this;
    }

    public RestCall redirectMaxAttempts(int maxAttempts) {
        this.redirectOnPostsTries = maxAttempts;
        return this;
    }

    public RestCall intercepter(RestCallInterceptor intercepter) {
        this.intercepters.add(intercepter);
        intercepter.onInit(this);
        return this;
    }

    public RestCall pipeTo(Writer w) {
        return this.pipeTo(w, false);
    }

    public RestCall pipeTo(Writer w, boolean close) {
        return this.pipeTo(null, w, close);
    }

    public RestCall pipeTo(String id, Writer w, boolean close) {
        this.writers.add(id, w, close);
        return this;
    }

    public Writer getWriter(String id) {
        return this.writers.getWriter(id);
    }

    public RestCall byLines() {
        this.byLines = true;
        return this;
    }

    public RestCall pipeTo(OutputStream os) {
        return this.pipeTo(os, false);
    }

    public RestCall pipeTo(OutputStream os, boolean close) {
        return this.pipeTo(null, os, close);
    }

    public RestCall pipeTo(String id, OutputStream os, boolean close) {
        this.outputStreams.add(id, os, close);
        return this;
    }

    public OutputStream getOutputStream(String id) {
        return this.outputStreams.getOutputStream(id);
    }

    public RestCall ignoreErrors() {
        this.ignoreErrors = true;
        return this;
    }

    public RestCall captureResponse() {
        if (this.capturedResponseWriter == null) {
            this.capturedResponseWriter = new StringWriter();
            this.writers.add((Writer)this.capturedResponseWriter, false);
        }
        return this;
    }

    public RestCall failurePattern(String errorPattern) {
        this.responsePattern(new ResponsePattern(errorPattern){

            @Override
            public void onMatch(RestCall rc, Matcher m) throws RestCallException {
                throw new RestCallException("Failure pattern detected.");
            }
        });
        return this;
    }

    public RestCall successPattern(String successPattern) {
        this.responsePattern(new ResponsePattern(successPattern){

            @Override
            public void onNoMatch(RestCall rc) throws RestCallException {
                throw new RestCallException("Success pattern not detected.");
            }
        });
        return this;
    }

    public RestCall responsePattern(final ResponsePattern responsePattern) {
        this.captureResponse();
        this.intercepter(new RestCallInterceptor(){

            @Override
            public void onClose(RestCall restCall) throws RestCallException {
                responsePattern.match(RestCall.this);
            }
        });
        return this;
    }

    public RestCall setConfig(RequestConfig config) {
        this.request.setConfig(config);
        return this;
    }

    @Deprecated
    public int execute() throws RestCallException {
        return this.run();
    }

    public int run() throws RestCallException {
        this.connect();
        try {
            StatusLine status = this.response.getStatusLine();
            int sc = status.getStatusCode();
            if (sc >= 400 && !this.ignoreErrors) {
                throw new RestCallException(sc, status.getReasonPhrase(), this.request.getMethod(), this.request.getURI(), this.getResponseAsString()).setHttpResponse(this.response);
            }
            if (this.outputStreams.size() > 0 || this.writers.size() > 0) {
                this.getReader();
            }
            int n = sc;
            return n;
        }
        catch (RestCallException e) {
            this.isFailed = true;
            throw e;
        }
        catch (IOException e) {
            this.isFailed = true;
            throw new RestCallException(e).setHttpResponse(this.response);
        }
        finally {
            this.close();
        }
    }

    public Future<Integer> runFuture() throws RestCallException {
        return this.client.getExecutorService(true).submit(new Callable<Integer>(){

            @Override
            public Integer call() throws Exception {
                return RestCall.this.run();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RestCall connect() throws RestCallException {
        if (this.isConnected) {
            return this;
        }
        this.isConnected = true;
        try {
            this.request.setURI(this.uriBuilder.build());
            if (this.hasInput || this.formData != null) {
                if (this.hasInput && this.formData != null) {
                    throw new RestCallException("Both input and form data found on same request.");
                }
                if (!(this.request instanceof HttpEntityEnclosingRequestBase)) {
                    throw new RestCallException(0, "Method does not support content entity.", this.request.getMethod(), this.request.getURI(), null);
                }
                Object entity = null;
                entity = this.formData != null ? new UrlEncodedFormEntity((List)this.formData) : (this.input instanceof NameValuePairs ? new UrlEncodedFormEntity((List)((NameValuePairs)this.input)) : (this.input instanceof HttpEntity ? (HttpEntity)this.input : new RestRequestEntity(this.input, this.getSerializer())));
                if (this.retries > 1 && !entity.isRepeatable()) {
                    throw new RestCallException("Rest call set to retryable, but entity is not repeatable.");
                }
                ((HttpEntityEnclosingRequestBase)this.request).setEntity((HttpEntity)entity);
            }
            int sc = 0;
            while (this.retries > 0) {
                Object ex;
                block25: {
                    --this.retries;
                    ex = null;
                    try {
                        this.response = this.client.execute((HttpUriRequest)this.request);
                        sc = this.response == null || this.response.getStatusLine() == null ? -1 : this.response.getStatusLine().getStatusCode();
                    }
                    catch (Exception e) {
                        ex = e;
                        sc = -1;
                        if (this.response == null) break block25;
                        EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
                    }
                }
                if (!this.retryOn.onResponse(this.response)) {
                    this.retries = 0;
                }
                if (this.retries > 0) {
                    for (RestCallInterceptor rci : this.intercepters) {
                        rci.onRetry(this, sc, (HttpRequest)this.request, this.response, (Exception)ex);
                    }
                    this.request.reset();
                    long w = this.retryInterval;
                    RestCall restCall = this;
                    synchronized (restCall) {
                        this.wait(w);
                        continue;
                    }
                }
                if (ex == null) continue;
                throw ex;
            }
            for (RestCallInterceptor rci : this.intercepters) {
                rci.onConnect(this, sc, (HttpRequest)this.request, this.response);
            }
            if (this.response == null) {
                throw new RestCallException("HttpClient returned a null response");
            }
            StatusLine sl = this.response.getStatusLine();
            String method = this.request.getMethod();
            sc = sl.getStatusCode();
            if (sc >= 400 && !this.ignoreErrors) {
                throw new RestCallException(sc, sl.getReasonPhrase(), method, this.request.getURI(), this.getResponseAsString()).setServerException(this.response.getFirstHeader("Exception-Name"), this.response.getFirstHeader("Exception-Message"), this.response.getFirstHeader("Exception-Trace")).setHttpResponse(this.response);
            }
            if ((sc == 307 || sc == 302) && this.allowRedirectsOnPosts && method.equalsIgnoreCase("POST")) {
                if (this.redirectOnPostsTries-- < 1) {
                    throw new RestCallException(sc, "Maximum number of redirects occurred.  Location header: " + this.response.getFirstHeader("Location"), method, this.request.getURI(), this.getResponseAsString());
                }
                Header h = this.response.getFirstHeader("Location");
                if (h != null) {
                    this.reset();
                    this.request.setURI(URI.create(h.getValue()));
                    ++this.retries;
                    this.connect();
                }
            }
        }
        catch (RestCallException e) {
            this.isFailed = true;
            try {
                this.close();
            }
            catch (RestCallException restCallException) {
                // empty catch block
            }
            throw e;
        }
        catch (Exception e) {
            this.isFailed = true;
            this.close();
            throw new RestCallException(e).setHttpResponse(this.response);
        }
        return this;
    }

    private void reset() {
        if (this.response != null) {
            EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
        }
        this.request.reset();
        this.isConnected = false;
        this.isClosed = false;
        this.isFailed = false;
        if (this.capturedResponseWriter != null) {
            this.capturedResponseWriter.getBuffer().setLength(0);
        }
    }

    public Reader getReader() throws IOException {
        String ct;
        InputStream is = this.getInputStream();
        if (is == null) {
            return null;
        }
        String cs = null;
        Header contentType = this.response.getLastHeader("Content-Type");
        String string = ct = contentType == null ? null : contentType.getValue();
        if (ct != null && ct.contains("charset=")) {
            cs = ct.substring(ct.indexOf("charset=") + 8).trim();
        }
        if (cs == null) {
            cs = "UTF-8";
        }
        InputStreamReader isr = new InputStreamReader(is, cs);
        if (this.writers.size() > 0) {
            StringWriter sw = new StringWriter();
            this.writers.add((Writer)sw, true);
            IOPipe.create((Object)isr, (Object)this.writers).byLines(this.byLines).run();
            return new StringReader(sw.toString());
        }
        return new InputStreamReader(is, cs);
    }

    public String getCapturedResponse() {
        if (!this.isClosed) {
            throw new IllegalStateException("This method cannot be called until the response has been consumed.");
        }
        if (this.capturedResponse == null && this.capturedResponseWriter != null && this.capturedResponseWriter.getBuffer().length() > 0) {
            this.capturedResponse = this.capturedResponseWriter.toString();
        }
        return this.capturedResponse;
    }

    protected Parser getParser() throws RestCallException {
        if (this.parser == null) {
            throw new RestCallException(0, "No parser defined on client", this.request.getMethod(), this.request.getURI(), null);
        }
        return this.parser;
    }

    protected Serializer getSerializer() throws RestCallException {
        if (this.serializer == null) {
            throw new RestCallException(0, "No serializer defined on client", this.request.getMethod(), this.request.getURI(), null);
        }
        return this.serializer;
    }

    public int getContentLength() throws IOException {
        this.connect();
        Header h = this.response.getLastHeader("Content-Length");
        if (h == null) {
            return -1;
        }
        long l = Long.parseLong(h.getValue());
        if (l > Integer.MAX_VALUE) {
            return Integer.MAX_VALUE;
        }
        return (int)l;
    }

    public InputStream getInputStream() throws IOException {
        if (this.isClosed) {
            throw new IllegalStateException("Method cannot be called.  Response has already been consumed.");
        }
        this.connect();
        if (this.response == null) {
            throw new RestCallException("Response was null");
        }
        if (this.response.getEntity() == null) {
            return null;
        }
        InputStream is = this.response.getEntity().getContent();
        if (this.outputStreams.size() > 0) {
            ByteArrayInOutStream baios = new ByteArrayInOutStream();
            this.outputStreams.add((OutputStream)baios, true);
            IOPipe.create((Object)is, (Object)baios).run();
            return baios.getInputStream();
        }
        return is;
    }

    public String getResponseAsString() throws IOException {
        try {
            String s;
            Reader r = this.getReader();
            String string = s = IOUtils.read((Reader)r).toString();
            return string;
        }
        catch (IOException e) {
            this.isFailed = true;
            throw e;
        }
        finally {
            this.close();
        }
    }

    public Future<String> getResponseAsStringFuture() throws RestCallException {
        return this.client.getExecutorService(true).submit(new Callable<String>(){

            @Override
            public String call() throws Exception {
                return RestCall.this.getResponseAsString();
            }
        });
    }

    public <T> T getResponse(Class<T> type) throws IOException, ParseException {
        BeanContext bc = this.getParser().getBeanContext();
        if (bc == null) {
            bc = BeanContext.DEFAULT;
        }
        return this.getResponse(bc.getClassMeta(type));
    }

    public <T> Future<T> getResponseFuture(final Class<T> type) throws RestCallException {
        return this.client.getExecutorService(true).submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return RestCall.this.getResponse(type);
            }
        });
    }

    public <T> T getResponse(Type type, Type ... args) throws IOException, ParseException {
        BeanContext bc = this.getParser().getBeanContext();
        if (bc == null) {
            bc = BeanContext.DEFAULT;
        }
        return this.getResponse(bc.getClassMeta(type, args));
    }

    public <T> Future<T> getResponseFuture(final Type type, final Type ... args) throws RestCallException {
        return this.client.getExecutorService(true).submit(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return RestCall.this.getResponse(type, args);
            }
        });
    }

    public PojoRest getResponsePojoRest(Class<?> innerType) throws IOException, ParseException {
        return new PojoRest(this.getResponse(innerType));
    }

    public PojoRest getResponsePojoRest() throws IOException, ParseException {
        return this.getResponsePojoRest(ObjectMap.class);
    }

    <T> T getResponse(ClassMeta<T> type) throws IOException, ParseException {
        try {
            if (type.getInnerClass().equals(HttpResponse.class)) {
                HttpResponse httpResponse = this.response;
                return (T)httpResponse;
            }
            if (type.getInnerClass().equals(Reader.class)) {
                Reader reader = this.getReader();
                return (T)reader;
            }
            if (type.getInnerClass().equals(InputStream.class)) {
                InputStream inputStream = this.getInputStream();
                return (T)inputStream;
            }
            Parser p = this.getParser();
            Object o = null;
            if (!p.isReaderParser()) {
                InputStream is = this.getInputStream();
                o = ((InputStreamParser)p).parse((Object)is, type);
            } else {
                Reader r = this.getReader();
                o = ((ReaderParser)p).parse((Object)r, type);
            }
            Object object = o;
            return (T)object;
        }
        catch (ParseException e) {
            this.isFailed = true;
            throw e;
        }
        catch (IOException e) {
            this.isFailed = true;
            throw e;
        }
        finally {
            this.close();
        }
    }

    BeanContext getBeanContext() throws RestCallException {
        BeanContext bc = this.getParser().getBeanContext();
        if (bc == null) {
            bc = BeanContext.DEFAULT;
        }
        return bc;
    }

    public HttpUriRequest getRequest() {
        return this.request;
    }

    public HttpResponse getResponse() throws IOException {
        this.connect();
        return this.response;
    }

    public RestCall header(Header header) {
        this.request.setHeader(header);
        return this;
    }

    @Deprecated
    public void consumeResponse() {
        if (this.response != null) {
            EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
        }
    }

    public RestCall close() throws RestCallException {
        if (this.response != null) {
            EntityUtils.consumeQuietly((HttpEntity)this.response.getEntity());
        }
        this.isClosed = true;
        if (!this.isFailed) {
            for (RestCallInterceptor r : this.intercepters) {
                r.onClose(this);
            }
        }
        return this;
    }

    public RestCall logTo(Level level, Logger log) {
        this.intercepter(new RestCallLogger(level, log));
        return this;
    }

    public RestCall debug() throws RestCallException {
        this.header("Debug", true);
        return this;
    }

    private boolean isBean(Object o) throws RestCallException {
        return this.getBeanContext().isBean(o);
    }

    private BeanMap<?> toBeanMap(Object o) throws RestCallException {
        return this.getBeanContext().createSession().toBeanMap(o);
    }
}

