/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.rest.client;

import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.HttpEntityEnclosingRequestBase;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIBuilder;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.CoreObject;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.PropertyStore;
import org.apache.juneau.internal.ClassUtils;
import org.apache.juneau.internal.ReflectionUtils;
import org.apache.juneau.internal.StringUtils;
import org.apache.juneau.json.JsonParser;
import org.apache.juneau.parser.Parser;
import org.apache.juneau.remoteable.FormData;
import org.apache.juneau.remoteable.FormDataIfNE;
import org.apache.juneau.remoteable.Header;
import org.apache.juneau.remoteable.HeaderIfNE;
import org.apache.juneau.remoteable.Path;
import org.apache.juneau.remoteable.Query;
import org.apache.juneau.remoteable.QueryIfNE;
import org.apache.juneau.remoteable.RemoteMethodArg;
import org.apache.juneau.remoteable.Remoteable;
import org.apache.juneau.remoteable.RemoteableMeta;
import org.apache.juneau.remoteable.RemoteableMetadataException;
import org.apache.juneau.remoteable.RemoteableMethodMeta;
import org.apache.juneau.remoteable.ReturnValue;
import org.apache.juneau.rest.client.HttpMethod;
import org.apache.juneau.rest.client.NameValuePairs;
import org.apache.juneau.rest.client.RestCall;
import org.apache.juneau.rest.client.RestCallException;
import org.apache.juneau.rest.client.RestCallInterceptor;
import org.apache.juneau.rest.client.RestCallLogger;
import org.apache.juneau.rest.client.RestRequestEntity;
import org.apache.juneau.rest.client.RetryOn;
import org.apache.juneau.serializer.PartSerializer;
import org.apache.juneau.serializer.Serializer;
import org.apache.juneau.urlencoding.UrlEncodingSerializer;

public class RestClient
extends CoreObject {
    private static final ConcurrentHashMap<Class, PartSerializer> partSerializerCache = new ConcurrentHashMap();
    private final Map<String, String> headers;
    private final CloseableHttpClient httpClient;
    private final boolean keepHttpClientOpen;
    private final UrlEncodingSerializer urlEncodingSerializer;
    private final PartSerializer partSerializer;
    private final String rootUrl;
    private volatile boolean isClosed = false;
    private final StackTraceElement[] creationStack;
    private StackTraceElement[] closedStack;
    final Serializer serializer;
    final Parser parser;
    final RetryOn retryOn;
    final int retries;
    final long retryInterval;
    final boolean debug;
    final RestCallInterceptor[] intercepters;
    private volatile ExecutorService executorService;
    boolean executorServiceShutdownOnClose = true;
    private Pattern absUrlPattern = Pattern.compile("^\\w+\\:\\/\\/.*");

    RestClient(PropertyStore propertyStore, CloseableHttpClient httpClient, boolean keepHttpClientOpen, Serializer serializer, Parser parser, UrlEncodingSerializer urlEncodingSerializer, PartSerializer partSerializer, Map<String, String> headers, List<RestCallInterceptor> intercepters, String rootUri, RetryOn retryOn, int retries, long retryInterval, boolean debug, ExecutorService executorService, boolean executorServiceShutdownOnClose) {
        super(propertyStore);
        this.httpClient = httpClient;
        this.keepHttpClientOpen = keepHttpClientOpen;
        this.serializer = serializer;
        this.parser = parser;
        this.urlEncodingSerializer = urlEncodingSerializer;
        this.partSerializer = partSerializer;
        ConcurrentHashMap<String, String> h2 = new ConcurrentHashMap<String, String>(headers);
        this.headers = Collections.unmodifiableMap(h2);
        this.rootUrl = rootUri;
        this.retryOn = retryOn;
        this.retries = retries;
        this.retryInterval = retryInterval;
        this.debug = debug;
        ArrayList<RestCallInterceptor> l = new ArrayList<RestCallInterceptor>(intercepters);
        if (debug) {
            l.add(RestCallLogger.DEFAULT);
        }
        this.intercepters = l.toArray(new RestCallInterceptor[l.size()]);
        this.creationStack = Boolean.getBoolean("org.apache.juneau.rest.client.RestClient.trackLifecycle") ? Thread.currentThread().getStackTrace() : null;
        this.executorService = executorService;
        this.executorServiceShutdownOnClose = executorServiceShutdownOnClose;
    }

    public void close() throws IOException {
        this.isClosed = true;
        if (this.httpClient != null && !this.keepHttpClientOpen) {
            this.httpClient.close();
        }
        if (this.executorService != null && this.executorServiceShutdownOnClose) {
            this.executorService.shutdown();
        }
        if (Boolean.getBoolean("org.apache.juneau.rest.client.RestClient.trackLifecycle")) {
            this.closedStack = Thread.currentThread().getStackTrace();
        }
    }

    public void closeQuietly() {
        this.isClosed = true;
        try {
            if (this.httpClient != null && !this.keepHttpClientOpen) {
                this.httpClient.close();
            }
            if (this.executorService != null && this.executorServiceShutdownOnClose) {
                this.executorService.shutdown();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        if (Boolean.getBoolean("org.apache.juneau.rest.client.RestClient.trackLifecycle")) {
            this.closedStack = Thread.currentThread().getStackTrace();
        }
    }

    protected HttpResponse execute(HttpUriRequest req) throws Exception {
        return this.httpClient.execute(req);
    }

    public RestCall doGet(Object url) throws RestCallException {
        return this.doCall("GET", url, false);
    }

    public RestCall doPut(Object url, Object o) throws RestCallException {
        return this.doCall("PUT", url, true).input(o);
    }

    public RestCall doPut(Object url) throws RestCallException {
        return this.doCall("PUT", url, true);
    }

    public RestCall doPost(Object url, Object o) throws RestCallException {
        return this.doCall("POST", url, true).input(o);
    }

    public RestCall doPost(Object url) throws RestCallException {
        return this.doCall("POST", url, true);
    }

    public RestCall doDelete(Object url) throws RestCallException {
        return this.doCall("DELETE", url, false);
    }

    public RestCall doOptions(Object url) throws RestCallException {
        return this.doCall("OPTIONS", url, true);
    }

    public RestCall doFormPost(Object url, Object o) throws RestCallException {
        return this.doCall("POST", url, true).input(o instanceof HttpEntity ? o : new RestRequestEntity(o, (Serializer)this.urlEncodingSerializer));
    }

    public RestCall doCallback(String callString) throws RestCallException {
        String s = callString;
        try {
            RestCall rc = null;
            String method = null;
            String uri = null;
            String content = null;
            ObjectMap h = null;
            int i = s.indexOf(32);
            if (i != -1) {
                method = s.substring(0, i).trim();
                if ((s = s.substring(i).trim()).length() > 0) {
                    if (s.charAt(0) == '{' && (i = s.indexOf(125)) != -1) {
                        String json = s.substring(0, i + 1);
                        h = (ObjectMap)JsonParser.DEFAULT.parse((Object)json, ObjectMap.class);
                        s = s.substring(i + 1).trim();
                    }
                    if (s.length() > 0) {
                        i = s.indexOf(32);
                        if (i == -1) {
                            uri = s;
                        } else {
                            uri = s.substring(0, i).trim();
                            if ((s = s.substring(i).trim()).length() > 0) {
                                content = s;
                            }
                        }
                    }
                }
            }
            if (method != null && uri != null) {
                rc = this.doCall(method, uri, content != null);
                if (content != null) {
                    rc.input(new StringEntity(content));
                }
                if (h != null) {
                    for (Map.Entry e : h.entrySet()) {
                        rc.header((String)e.getKey(), e.getValue());
                    }
                }
                return rc;
            }
        }
        catch (Exception e) {
            throw new RestCallException(e);
        }
        throw new RestCallException("Invalid format for call string.");
    }

    public RestCall doCall(HttpMethod method, Object url, Object content) throws RestCallException {
        RestCall rc = this.doCall(method.name(), url, method.hasContent());
        if (method.hasContent()) {
            rc.input(content);
        }
        return rc;
    }

    public RestCall doCall(String method, Object url, boolean hasContent) throws RestCallException {
        if (this.isClosed) {
            Exception e2 = null;
            if (this.closedStack != null) {
                e2 = new Exception("Creation stack:");
                e2.setStackTrace(this.closedStack);
                throw new RestCallException("RestClient.close() has already been called.  This client cannot be reused.").initCause(e2);
            }
            throw new RestCallException("RestClient.close() has already been called.  This client cannot be reused.  Closed location stack trace can be displayed by setting the system property 'org.apache.juneau.rest.client.RestClient.trackCreation' to true.");
        }
        Object req = null;
        RestCall restCall = null;
        final String methodUC = method.toUpperCase(Locale.ENGLISH);
        try {
            if (hasContent) {
                req = new HttpEntityEnclosingRequestBase(){

                    public String getMethod() {
                        return methodUC;
                    }
                };
                restCall = new RestCall(this, (HttpRequestBase)req, this.toURI(url));
            } else {
                req = new HttpRequestBase(){

                    public String getMethod() {
                        return methodUC;
                    }
                };
                restCall = new RestCall(this, (HttpRequestBase)req, this.toURI(url));
            }
        }
        catch (URISyntaxException e1) {
            throw new RestCallException(e1);
        }
        for (Map.Entry<String, String> e : this.headers.entrySet()) {
            restCall.header(e.getKey(), e.getValue());
        }
        if (this.parser != null && !req.containsHeader("Accept")) {
            req.setHeader("Accept", this.parser.getPrimaryMediaType().toString());
        }
        return restCall;
    }

    public <T> T getRemoteableProxy(Class<T> interfaceClass) {
        return this.getRemoteableProxy(interfaceClass, null);
    }

    public <T> T getRemoteableProxy(Class<T> interfaceClass, Object restUrl) {
        return this.getRemoteableProxy(interfaceClass, restUrl, this.serializer, this.parser);
    }

    public <T> T getRemoteableProxy(final Class<T> interfaceClass, Object restUrl, final Serializer serializer, final Parser parser) {
        if (restUrl == null) {
            String path;
            Remoteable r = (Remoteable)ReflectionUtils.getAnnotation(Remoteable.class, interfaceClass);
            String string = path = r == null ? "" : StringUtils.trimSlashes((String)r.path());
            if (path.indexOf("://") == -1) {
                if (this.rootUrl == null) {
                    throw new RemoteableMetadataException(interfaceClass, "Root URI has not been specified.  Cannot construct absolute path to remoteable proxy.", new Object[0]);
                }
                path = StringUtils.trimSlashes((String)this.rootUrl) + '/' + path;
            }
            restUrl = path;
        }
        final String restUrl2 = restUrl.toString();
        try {
            return (T)Proxy.newProxyInstance(interfaceClass.getClassLoader(), new Class[]{interfaceClass}, new InvocationHandler(){
                final RemoteableMeta rm;
                {
                    this.rm = new RemoteableMeta(interfaceClass, restUrl2);
                }

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    RemoteableMethodMeta rmm = this.rm.getMethodMeta(method);
                    if (rmm == null) {
                        throw new RuntimeException("Method is not exposed as a remoteable method.");
                    }
                    try {
                        RestCall rc;
                        String url = rmm.getUrl();
                        String httpMethod = rmm.getHttpMethod();
                        if (httpMethod.equals("DELETE")) {
                            rc = RestClient.this.doDelete(url);
                        } else if (httpMethod.equals("POST")) {
                            rc = RestClient.this.doPost(url);
                        } else if (httpMethod.equals("GET")) {
                            rc = RestClient.this.doGet(url);
                        } else if (httpMethod.equals("PUT")) {
                            rc = RestClient.this.doPut(url);
                        } else {
                            throw new RuntimeException("Unsupported method.");
                        }
                        rc.serializer(serializer).parser(parser);
                        for (RemoteMethodArg a : rmm.getPathArgs()) {
                            rc.path(a.name, args[a.index], a.serializer);
                        }
                        for (RemoteMethodArg a : rmm.getQueryArgs()) {
                            rc.query(a.name, args[a.index], a.skipIfNE, a.serializer);
                        }
                        for (RemoteMethodArg a : rmm.getFormDataArgs()) {
                            rc.formData(a.name, args[a.index], a.skipIfNE, a.serializer);
                        }
                        for (RemoteMethodArg a : rmm.getHeaderArgs()) {
                            rc.header(a.name, args[a.index], a.skipIfNE, a.serializer);
                        }
                        if (rmm.getBodyArg() != null) {
                            rc.input(args[rmm.getBodyArg()]);
                        }
                        if (rmm.getRequestBeanArgs().length > 0) {
                            BeanSession bs = RestClient.this.getBeanContext().createSession();
                            for (RemoteMethodArg rma : rmm.getRequestBeanArgs()) {
                                BeanMap bm = bs.toBeanMap(args[rma.index]);
                                for (BeanPropertyValue bpv : bm.getValues(false, new BeanPropertyValue[0])) {
                                    HeaderIfNE h2;
                                    Header h1;
                                    FormDataIfNE f2;
                                    FormData f1;
                                    QueryIfNE q2;
                                    BeanPropertyMeta pMeta = bpv.getMeta();
                                    Object val = bpv.getValue();
                                    Path p = (Path)pMeta.getAnnotation(Path.class);
                                    if (p != null) {
                                        rc.path(RestClient.getName(p.name(), p.value(), pMeta), val, RestClient.getPartSerializer(p.serializer(), rma.serializer));
                                    }
                                    if (val == null) continue;
                                    Query q1 = (Query)pMeta.getAnnotation(Query.class);
                                    if (q1 != null) {
                                        rc.query(RestClient.getName(q1.name(), q1.value(), pMeta), val, q1.skipIfEmpty(), RestClient.getPartSerializer(q1.serializer(), rma.serializer));
                                    }
                                    if ((q2 = (QueryIfNE)pMeta.getAnnotation(QueryIfNE.class)) != null) {
                                        rc.query(RestClient.getName(q2.name(), q2.value(), pMeta), val, true, RestClient.getPartSerializer(q2.serializer(), rma.serializer));
                                    }
                                    if ((f1 = (FormData)pMeta.getAnnotation(FormData.class)) != null) {
                                        rc.formData(RestClient.getName(f1.name(), f1.value(), pMeta), val, f1.skipIfEmpty(), RestClient.getPartSerializer(f1.serializer(), rma.serializer));
                                    }
                                    if ((f2 = (FormDataIfNE)pMeta.getAnnotation(FormDataIfNE.class)) != null) {
                                        rc.formData(RestClient.getName(f2.name(), f2.value(), pMeta), val, true, RestClient.getPartSerializer(f2.serializer(), rma.serializer));
                                    }
                                    if ((h1 = (Header)pMeta.getAnnotation(Header.class)) != null) {
                                        rc.header(RestClient.getName(h1.name(), h1.value(), pMeta), val, h1.skipIfEmpty(), RestClient.getPartSerializer(h1.serializer(), rma.serializer));
                                    }
                                    if ((h2 = (HeaderIfNE)pMeta.getAnnotation(HeaderIfNE.class)) == null) continue;
                                    rc.header(RestClient.getName(h2.name(), h2.value(), pMeta), val, true, RestClient.getPartSerializer(h2.serializer(), rma.serializer));
                                }
                            }
                        }
                        if (rmm.getOtherArgs().length > 0) {
                            Object[] otherArgs = new Object[rmm.getOtherArgs().length];
                            int i = 0;
                            for (Integer otherArg : rmm.getOtherArgs()) {
                                otherArgs[i++] = args[otherArg];
                            }
                            rc.input(otherArgs);
                        }
                        if (rmm.getReturns() == ReturnValue.HTTP_STATUS) {
                            rc.ignoreErrors();
                            int returnCode = rc.run();
                            Class<?> rt = method.getReturnType();
                            if (rt == Integer.class || rt == Integer.TYPE) {
                                return returnCode;
                            }
                            if (rt == Boolean.class || rt == Boolean.TYPE) {
                                return returnCode < 400;
                            }
                            throw new RestCallException("Invalid return type on method annotated with @RemoteableMethod(returns=HTTP_STATUS).  Only integer and booleans types are valid.");
                        }
                        Object v = rc.getResponse(method.getGenericReturnType(), new Type[0]);
                        if (v == null && method.getReturnType().isPrimitive()) {
                            v = ClassUtils.getPrimitiveDefault(method.getReturnType());
                        }
                        return v;
                    }
                    catch (RestCallException e) {
                        e.throwServerException(interfaceClass.getClassLoader());
                        throw new RuntimeException(e);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            });
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static String getName(String name1, String name2, BeanPropertyMeta pMeta) {
        String n = name1.isEmpty() ? name2 : name1;
        ClassMeta cm = pMeta.getClassMeta();
        if (n.isEmpty() && (cm.isMapOrBean() || cm.isReader() || cm.isInstanceOf(NameValuePairs.class))) {
            n = "*";
        }
        if (n.isEmpty()) {
            n = pMeta.getName();
        }
        return n;
    }

    private static PartSerializer getPartSerializer(Class c, PartSerializer c2) {
        if (c2 != null) {
            return c2;
        }
        if (c == PartSerializer.class) {
            return null;
        }
        PartSerializer pf = partSerializerCache.get(c);
        if (pf == null) {
            partSerializerCache.putIfAbsent(c, (PartSerializer)ClassUtils.newInstance(PartSerializer.class, (Object)c, (Object[])new Object[0]));
            pf = partSerializerCache.get(c);
        }
        return pf;
    }

    PartSerializer getPartSerializer() {
        return this.partSerializer;
    }

    URI toURI(Object url) throws URISyntaxException {
        String s;
        if (url instanceof URI) {
            return (URI)url;
        }
        if (url instanceof URL) {
            ((URL)url).toURI();
        }
        if (url instanceof URIBuilder) {
            return ((URIBuilder)url).build();
        }
        String string = s = url == null ? "" : url.toString();
        if (this.rootUrl != null && !this.absUrlPattern.matcher(s).matches()) {
            if (s.isEmpty()) {
                s = this.rootUrl;
            } else {
                StringBuilder sb = new StringBuilder(this.rootUrl);
                if (!s.startsWith("/")) {
                    sb.append('/');
                }
                sb.append(s);
                s = sb.toString();
            }
        }
        if (s.indexOf(123) != -1) {
            s = s.replace("{", "%7B").replace("}", "%7D");
        }
        return new URI(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ExecutorService getExecutorService(boolean create) {
        if (this.executorService != null || !create) {
            return this.executorService;
        }
        RestClient restClient = this;
        synchronized (restClient) {
            if (this.executorService == null) {
                this.executorService = new ThreadPoolExecutor(1, 1, 30L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(10));
            }
            return this.executorService;
        }
    }

    protected void finalize() throws Throwable {
        if (!this.isClosed && !this.keepHttpClientOpen) {
            System.err.println("WARNING:  RestClient garbage collected before it was finalized.");
            if (this.creationStack != null) {
                System.err.println("Creation Stack:");
                for (StackTraceElement e : this.creationStack) {
                    System.err.println(e);
                }
            } else {
                System.err.println("Creation stack traces can be displayed by setting the system property 'org.apache.juneau.rest.client.RestClient.trackLifecycle' to true.");
            }
        }
    }
}

