/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.yaml.proto;

import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.SerializerWriter;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.yaml.proto.YamlSerializerContext;
import org.apache.juneau.yaml.proto.YamlWriter;

public class YamlSerializerSession
extends WriterSerializerSession {
    private final boolean addBeanTypeProperties;

    protected YamlSerializerSession(YamlSerializerContext ctx, SerializerSessionArgs args) {
        super(ctx, args);
        ObjectMap p = this.getProperties();
        this.addBeanTypeProperties = p.isEmpty() ? ctx.addBeanTypeProperties : p.getBoolean("JsonSerializer.addBeanTypeProperties", ctx.addBeanTypeProperties);
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws Exception {
        this.serializeAnything(this.getJsonWriter(out), o, this.getExpectedRootType(o), "root", null);
    }

    SerializerWriter serializeAnything(YamlWriter out, Object o, ClassMeta<?> eType, String attrName, BeanPropertyMeta pMeta) throws Exception {
        ClassMeta<Object> aType;
        boolean isRecursion;
        if (o == null) {
            out.append("~");
            return out;
        }
        if (eType == null) {
            eType = this.object();
        }
        boolean bl = isRecursion = (aType = this.push(attrName, o, eType)) == null;
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        ClassMeta<Object> sType = aType;
        String typeName = this.getBeanTypeName(eType, aType, pMeta);
        PojoSwap<Object, ?> swap = aType.getPojoSwap(this);
        if (swap != null) {
            o = swap.swap(this, o);
            sType = swap.getSwapClassMeta(this);
            if (sType.isObject()) {
                sType = this.getClassMetaForObject(o);
            }
        }
        if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
            out.append("~");
        } else if (sType.isNumber() || sType.isBoolean()) {
            out.append(o);
        } else if (sType.isBean()) {
            this.serializeBeanMap(out, this.toBeanMap(o), typeName);
        } else if (sType.isUri() || pMeta != null && pMeta.isUri()) {
            out.uriValue(o);
        } else if (sType.isMap()) {
            if (o instanceof BeanMap) {
                this.serializeBeanMap(out, (BeanMap)o, typeName);
            } else {
                this.serializeMap(out, (Map)o, eType);
            }
        } else if (sType.isCollection()) {
            this.serializeCollection(out, (Collection)o, eType);
        } else if (sType.isArray()) {
            this.serializeCollection(out, YamlSerializerSession.toList(sType.getInnerClass(), o), eType);
        } else if (sType.isReader() || sType.isInputStream()) {
            IOUtils.pipe(o, (Writer)out);
        } else {
            out.stringValue(this.toString(o));
        }
        if (!isRecursion) {
            this.pop();
        }
        return out;
    }

    private SerializerWriter serializeMap(YamlWriter out, Map m, ClassMeta<?> type) throws Exception {
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        m = this.sort(m);
        int i = this.indent;
        Iterator mapEntries = m.entrySet().iterator();
        while (mapEntries.hasNext()) {
            Map.Entry e = mapEntries.next();
            Object value = e.getValue();
            Object key = this.generalize(e.getKey(), keyType);
            out.attr(this.toString(key)).append(':').s();
            this.serializeAnything(out, value, valueType, key == null ? null : this.toString(key), null);
            if (!mapEntries.hasNext()) continue;
            out.nl(i);
        }
        out.cre(i - 1);
        return out;
    }

    private SerializerWriter serializeBeanMap(YamlWriter out, BeanMap<?> m, String typeName) throws Exception {
        int i = this.indent;
        out.append('{');
        boolean addComma = false;
        for (BeanPropertyValue p : m.getValues(this.isTrimNulls(), typeName != null ? YamlSerializerSession.createBeanTypeNameProperty(m, typeName) : null)) {
            BeanPropertyMeta pMeta = p.getMeta();
            ClassMeta<?> cMeta = p.getClassMeta();
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                this.onBeanGetterException(pMeta, t);
            }
            if (this.canIgnoreValue(cMeta, key, value)) continue;
            if (addComma) {
                out.append(',').smi(i);
            }
            out.cr(i).attr(key).append(':').s(i);
            this.serializeAnything(out, value, cMeta, key, pMeta);
            addComma = true;
        }
        out.cre(i - 1).append('}');
        return out;
    }

    private SerializerWriter serializeCollection(YamlWriter out, Collection c, ClassMeta<?> type) throws Exception {
        ClassMeta<?> elementType = type.getElementType();
        c = this.sort(c);
        out.append('[');
        Iterator i = c.iterator();
        while (i.hasNext()) {
            Object value = i.next();
            out.cr(this.indent);
            this.serializeAnything(out, value, elementType, "<iterator>", null);
            if (!i.hasNext()) continue;
            out.append(',').smi(this.indent);
        }
        out.cre(this.indent - 1).append(']');
        return out;
    }

    @Override
    protected final boolean isAddBeanTypeProperties() {
        return this.addBeanTypeProperties;
    }

    protected final YamlWriter getJsonWriter(SerializerPipe out) throws Exception {
        Object output = out.getRawOutput();
        if (output instanceof YamlWriter) {
            return (YamlWriter)output;
        }
        YamlWriter w = new YamlWriter(out.getWriter(), this.getQuoteChar(), this.isTrimStrings(), this.getUriResolver());
        out.setWriter(w);
        return w;
    }
}

