/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.uon;

import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.juneau.BeanMap;
import org.apache.juneau.BeanPropertyMeta;
import org.apache.juneau.BeanPropertyValue;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.ObjectMap;
import org.apache.juneau.internal.IOUtils;
import org.apache.juneau.serializer.SerializerPipe;
import org.apache.juneau.serializer.SerializerSessionArgs;
import org.apache.juneau.serializer.SerializerWriter;
import org.apache.juneau.serializer.WriterSerializerSession;
import org.apache.juneau.transform.PojoSwap;
import org.apache.juneau.uon.UonSerializerContext;
import org.apache.juneau.uon.UonWriter;

public class UonSerializerSession
extends WriterSerializerSession {
    private final boolean encodeChars;
    private final boolean addBeanTypeProperties;
    private final boolean plainTextParams;

    public UonSerializerSession(UonSerializerContext ctx, Boolean encode, SerializerSessionArgs args) {
        super(ctx, args);
        ObjectMap p = this.getProperties();
        if (p.isEmpty()) {
            this.encodeChars = encode == null ? ctx.encodeChars : encode;
            this.addBeanTypeProperties = ctx.addBeanTypeProperties;
            this.plainTextParams = ctx.plainTextParams;
        } else {
            this.encodeChars = encode == null ? p.getBoolean("UonSerializer.encodeChars", ctx.encodeChars) : encode;
            this.addBeanTypeProperties = p.getBoolean("MsgPackSerializer.addBeanTypeProperties", ctx.addBeanTypeProperties);
            this.plainTextParams = p.getString("UonSerializer.paramFormat", "UON").equals("PLAINTEXT");
        }
    }

    @Override
    public final boolean isAddBeanTypeProperties() {
        return this.addBeanTypeProperties;
    }

    protected final UonWriter getUonWriter(SerializerPipe out) throws Exception {
        Object output = out.getRawOutput();
        if (output instanceof UonWriter) {
            return (UonWriter)output;
        }
        UonWriter w = new UonWriter(this, out.getWriter(), this.isUseWhitespace(), this.getMaxIndent(), this.encodeChars, this.isTrimStrings(), this.plainTextParams, this.getUriResolver());
        out.setWriter(w);
        return w;
    }

    @Override
    protected void doSerialize(SerializerPipe out, Object o) throws Exception {
        this.serializeAnything(this.getUonWriter(out), o, this.getExpectedRootType(o), "root", null);
    }

    protected SerializerWriter serializeAnything(UonWriter out, Object o, ClassMeta<?> eType, String attrName, BeanPropertyMeta pMeta) throws Exception {
        ClassMeta<Object> aType;
        boolean isRecursion;
        if (o == null) {
            out.appendObject(null, false);
            return out;
        }
        if (eType == null) {
            eType = this.object();
        }
        boolean bl = isRecursion = (aType = this.push(attrName, o, eType)) == null;
        if (aType == null) {
            o = null;
            aType = this.object();
        }
        ClassMeta<Object> sType = aType;
        String typeName = this.getBeanTypeName(eType, aType, pMeta);
        PojoSwap<Object, ?> swap = aType.getPojoSwap(this);
        if (swap != null) {
            o = swap.swap(this, o);
            sType = swap.getSwapClassMeta(this);
            if (sType.isObject()) {
                sType = this.getClassMetaForObject(o);
            }
        }
        if (o == null || sType.isChar() && ((Character)o).charValue() == '\u0000') {
            out.appendObject(null, false);
        } else if (sType.isBoolean()) {
            out.appendBoolean(o);
        } else if (sType.isNumber()) {
            out.appendNumber(o);
        } else if (sType.isBean()) {
            this.serializeBeanMap(out, this.toBeanMap(o), typeName);
        } else if (sType.isUri() || pMeta != null && pMeta.isUri()) {
            out.appendUri(o);
        } else if (sType.isMap()) {
            if (o instanceof BeanMap) {
                this.serializeBeanMap(out, (BeanMap)o, typeName);
            } else {
                this.serializeMap(out, (Map)o, eType);
            }
        } else if (sType.isCollection()) {
            this.serializeCollection(out, (Collection)o, eType);
        } else if (sType.isArray()) {
            this.serializeCollection(out, UonSerializerSession.toList(sType.getInnerClass(), o), eType);
        } else if (sType.isReader() || sType.isInputStream()) {
            IOUtils.pipe(o, (Writer)out);
        } else {
            out.appendObject(o, false);
        }
        if (!isRecursion) {
            this.pop();
        }
        return out;
    }

    private SerializerWriter serializeMap(UonWriter out, Map m, ClassMeta<?> type) throws Exception {
        m = this.sort(m);
        ClassMeta<?> keyType = type.getKeyType();
        ClassMeta<?> valueType = type.getValueType();
        if (!this.plainTextParams) {
            out.append('(');
        }
        Iterator mapEntries = m.entrySet().iterator();
        while (mapEntries.hasNext()) {
            Map.Entry e = mapEntries.next();
            Object value = e.getValue();
            Object key = this.generalize(e.getKey(), keyType);
            out.cr(this.indent).appendObject(key, false).append('=');
            this.serializeAnything(out, value, valueType, key == null ? null : this.toString(key), null);
            if (!mapEntries.hasNext()) continue;
            out.append(',');
        }
        if (m.size() > 0) {
            out.cre(this.indent - 1);
        }
        if (!this.plainTextParams) {
            out.append(')');
        }
        return out;
    }

    private SerializerWriter serializeBeanMap(UonWriter out, BeanMap<?> m, String typeName) throws Exception {
        if (!this.plainTextParams) {
            out.append('(');
        }
        boolean addComma = false;
        for (BeanPropertyValue p : m.getValues(this.isTrimNulls(), typeName != null ? UonSerializerSession.createBeanTypeNameProperty(m, typeName) : null)) {
            BeanPropertyMeta pMeta = p.getMeta();
            ClassMeta<?> cMeta = p.getClassMeta();
            String key = p.getName();
            Object value = p.getValue();
            Throwable t = p.getThrown();
            if (t != null) {
                this.onBeanGetterException(pMeta, t);
            }
            if (this.canIgnoreValue(cMeta, key, value)) continue;
            if (addComma) {
                out.append(',');
            }
            out.cr(this.indent).appendObject(key, false).append('=');
            this.serializeAnything(out, value, cMeta, key, pMeta);
            addComma = true;
        }
        if (m.size() > 0) {
            out.cre(this.indent - 1);
        }
        if (!this.plainTextParams) {
            out.append(')');
        }
        return out;
    }

    private SerializerWriter serializeCollection(UonWriter out, Collection c, ClassMeta<?> type) throws Exception {
        ClassMeta<?> elementType = type.getElementType();
        c = this.sort(c);
        if (!this.plainTextParams) {
            out.append('@').append('(');
        }
        Iterator i = c.iterator();
        while (i.hasNext()) {
            out.cr(this.indent);
            this.serializeAnything(out, i.next(), elementType, "<iterator>", null);
            if (!i.hasNext()) continue;
            out.append(',');
        }
        if (c.size() > 0) {
            out.cre(this.indent - 1);
        }
        if (!this.plainTextParams) {
            out.append(')');
        }
        return out;
    }
}

