/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.transform;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.LinkedList;
import java.util.List;
import org.apache.juneau.BeanSession;
import org.apache.juneau.ClassMeta;
import org.apache.juneau.annotation.BeanIgnore;
import org.apache.juneau.parser.ParseException;
import org.apache.juneau.serializer.SerializeException;
import org.apache.juneau.transform.PojoSwap;

public class SurrogateSwap<T, F>
extends PojoSwap<T, F> {
    private Constructor<F> constructor;
    private Method untransformMethod;

    protected SurrogateSwap(Class<T> forClass, Constructor<F> constructor, Method untransformMethod) {
        super(forClass, constructor.getDeclaringClass());
        this.constructor = constructor;
        this.untransformMethod = untransformMethod;
    }

    public static List<SurrogateSwap<?, ?>> findPojoSwaps(Class<?> c) {
        LinkedList l = new LinkedList();
        for (Constructor<?> cc : c.getConstructors()) {
            int mod;
            Class<?>[] pt;
            if (cc.getAnnotation(BeanIgnore.class) != null || (pt = cc.getParameterTypes()).length != 1 || pt[0] == c.getDeclaringClass() || !Modifier.isPublic(mod = cc.getModifiers())) continue;
            Method unswapMethod = null;
            for (Method m : c.getMethods()) {
                int mod2;
                Class<?>[] mpt;
                if (!pt[0].equals(m.getReturnType()) || (mpt = m.getParameterTypes()).length != 1 || !mpt[0].equals(c) || !Modifier.isPublic(mod2 = m.getModifiers()) || !Modifier.isStatic(mod2)) continue;
                unswapMethod = m;
            }
            l.add(new SurrogateSwap(pt[0], cc, unswapMethod));
        }
        return l;
    }

    @Override
    public F swap(BeanSession session, T o) throws SerializeException {
        try {
            return this.constructor.newInstance(o);
        }
        catch (Exception e) {
            throw new SerializeException(e);
        }
    }

    @Override
    public T unswap(BeanSession session, F f, ClassMeta<?> hint) throws ParseException {
        if (this.untransformMethod == null) {
            throw new ParseException("static valueOf({0}) method not implement on surrogate class ''{1}''", f.getClass().getName(), this.getNormalClass().getName());
        }
        try {
            return (T)this.untransformMethod.invoke(null, f);
        }
        catch (Exception e) {
            throw new ParseException(e);
        }
    }
}

