/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.Map;
import java.util.TreeMap;
import org.apache.juneau.internal.ArrayUtils;

public class TeeOutputStream
extends OutputStream {
    private OutputStream[] outputStreams = new OutputStream[0];
    private Map<String, OutputStream> outputStreamMap;

    public TeeOutputStream(OutputStream ... outputStreams) {
        this.outputStreams = outputStreams;
    }

    public TeeOutputStream(Collection<OutputStream> outputStreams) {
        this.outputStreams = outputStreams.toArray(new OutputStream[outputStreams.size()]);
    }

    public TeeOutputStream add(OutputStream os, boolean close) {
        if (os == null) {
            return this;
        }
        if (!close) {
            os = new NoCloseOutputStream(os);
        }
        if (os == this) {
            throw new RuntimeException("Cannot add this output stream to itself.");
        }
        for (OutputStream os2 : this.outputStreams) {
            if (os2 != os) continue;
            throw new RuntimeException("Cannot add this output stream again.");
        }
        if (os instanceof TeeOutputStream) {
            for (OutputStream os2 : ((TeeOutputStream)os).outputStreams) {
                this.add(os2, true);
            }
        } else {
            this.outputStreams = ArrayUtils.append(this.outputStreams, os);
        }
        return this;
    }

    public OutputStream getOutputStream(String id) {
        if (this.outputStreamMap != null) {
            return this.outputStreamMap.get(id);
        }
        return null;
    }

    public TeeOutputStream add(String id, OutputStream os, boolean close) {
        if (id != null) {
            if (this.outputStreamMap == null) {
                this.outputStreamMap = new TreeMap<String, OutputStream>();
            }
            this.outputStreamMap.put(id, os);
        }
        return this.add(os, close);
    }

    public int size() {
        return this.outputStreams.length;
    }

    @Override
    public void write(int b) throws IOException {
        for (OutputStream os : this.outputStreams) {
            os.write(b);
        }
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        for (OutputStream os : this.outputStreams) {
            os.write(b, off, len);
        }
    }

    @Override
    public void flush() throws IOException {
        for (OutputStream os : this.outputStreams) {
            os.flush();
        }
    }

    @Override
    public void close() throws IOException {
        for (OutputStream os : this.outputStreams) {
            os.close();
        }
    }

    private static class NoCloseOutputStream
    extends OutputStream {
        private OutputStream os;

        private NoCloseOutputStream(OutputStream os) {
            this.os = os;
        }

        @Override
        public void write(int b) throws IOException {
            this.os.write(b);
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            this.os.write(b, off, len);
        }

        @Override
        public void flush() throws IOException {
            this.os.flush();
        }

        @Override
        public void close() throws IOException {
        }
    }
}

