/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juneau.internal;

public final class AsciiSet {
    final boolean[] store = new boolean[128];

    public AsciiSet(String chars) {
        for (int i = 0; i < chars.length(); ++i) {
            char c = chars.charAt(i);
            if (c >= '\u0080') continue;
            this.store[c] = true;
        }
    }

    public boolean contains(char c) {
        if (c > '\u007f') {
            return false;
        }
        return this.store[c];
    }

    public boolean contains(int c) {
        if (c < 0 || c > 127) {
            return false;
        }
        return this.store[c];
    }

    public boolean contains(CharSequence s) {
        if (s == null) {
            return false;
        }
        for (int i = 0; i < s.length(); ++i) {
            if (!this.contains(s.charAt(i))) continue;
            return true;
        }
        return false;
    }
}

